/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.compat.quark;

import net.mehvahdjukaar.supplementaries.block.tiles.SafeBlockTile;
import net.mehvahdjukaar.supplementaries.common.CommonUtil;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.EmptyHandler;
import vazkii.arl.util.AbstractDropIn;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.base.module.ModuleLoader;
import vazkii.quark.content.management.module.ShulkerBoxRightClickModule;

public class SafeDropIn
extends AbstractDropIn {
    private static final SafeBlockTile DUMMY_SAFE_TILE = new SafeBlockTile();
    private static final BlockState DEFAULT_SAFE = ((Block)ModRegistry.SACK.get()).func_176223_P();

    private boolean tryAddToShulkerBox(ItemStack sack, ItemStack stack, boolean simulate, PlayerEntity player) {
        CompoundNBT cmp;
        if (CommonUtil.isAllowedInShulker(stack) && !(cmp = ItemNBTHelper.getCompound((ItemStack)sack, (String)"BlockEntityTag", (boolean)false)).func_74764_b("LootTable") && cmp != null) {
            cmp = cmp.func_74737_b();
            cmp.func_74778_a("id", "supplementaries:safe");
            Item i = sack.func_77973_b();
            if (i == ModRegistry.SAFE_ITEM.get()) {
                DUMMY_SAFE_TILE.func_230337_a_(DEFAULT_SAFE, cmp);
                if (!DUMMY_SAFE_TILE.canPlayerOpen(player, false)) {
                    return false;
                }
                LazyOptional handlerHolder = DUMMY_SAFE_TILE.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                if (handlerHolder.isPresent()) {
                    boolean did;
                    IItemHandler handler = (IItemHandler)handlerHolder.orElseGet(EmptyHandler::new);
                    ItemStack result = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack.func_77946_l(), (boolean)simulate);
                    boolean bl = did = result.func_190926_b() || result.func_190916_E() != stack.func_190916_E();
                    if (!simulate && did) {
                        stack.func_190920_e(result.func_190916_E());
                        CompoundNBT compoundnbt = DUMMY_SAFE_TILE.func_189515_b(cmp);
                        if (!compoundnbt.isEmpty()) {
                            sack.func_77983_a("BlockEntityTag", (INBT)compoundnbt);
                        }
                    }
                    return did;
                }
            }
        }
        return false;
    }

    public boolean canDropItemIn(PlayerEntity player, ItemStack stack, ItemStack incoming) {
        return ModuleLoader.INSTANCE.isModuleEnabled(ShulkerBoxRightClickModule.class) && this.tryAddToShulkerBox(stack, incoming, true, player);
    }

    public ItemStack dropItemIn(PlayerEntity player, ItemStack stack, ItemStack incoming) {
        this.tryAddToShulkerBox(stack, incoming, false, player);
        return stack;
    }

    public boolean canDropItemIn(PlayerEntity player, ItemStack stack, ItemStack incoming, Slot slot) {
        return this.canDropItemIn(player, stack, incoming);
    }

    public ItemStack dropItemIn(PlayerEntity player, ItemStack stack, ItemStack incoming, Slot slot) {
        return this.dropItemIn(player, stack, incoming);
    }
}

