/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.util;

import java.util.Optional;
import net.mehvahdjukaar.selene.blocks.IOwnerProtected;
import net.mehvahdjukaar.supplementaries.api.IRotatable;
import net.mehvahdjukaar.supplementaries.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.common.VectorUtils;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CakeBlock;
import net.minecraft.block.ChestBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.PistonHeadBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BedPart;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.ChestType;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.SlabType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BlockUtils {
    public static <T extends Comparable<T>, A extends Property<T>> BlockState replaceProperty(BlockState from, BlockState to, A property) {
        if (from.func_235901_b_(property)) {
            return (BlockState)to.func_206870_a(property, from.func_177229_b(property));
        }
        return to;
    }

    public static void addOptionalOwnership(LivingEntity placer, TileEntity tileEntity) {
        if (ServerConfigs.cached.SERVER_PROTECTION && placer instanceof PlayerEntity) {
            ((IOwnerProtected)tileEntity).setOwner(placer.func_110124_au());
        }
    }

    public static void addOptionalOwnership(LivingEntity placer, World world, BlockPos pos) {
        TileEntity tile;
        if (ServerConfigs.cached.SERVER_PROTECTION && placer instanceof PlayerEntity && (tile = world.func_175625_s(pos)) instanceof IOwnerProtected) {
            ((IOwnerProtected)tile).setOwner(placer.func_110124_au());
        }
    }

    public static Optional<Direction> tryRotatingBlockAndConnected(Direction face, boolean ccw, BlockPos targetPos, World level, Vector3d hit) {
        BlockState state = level.func_180495_p(targetPos);
        if (state.func_177230_c() instanceof IRotatable) {
            return ((IRotatable)state.func_177230_c()).rotateOverAxis(state, (IWorldReader)level, targetPos, ccw ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90, face, hit);
        }
        Optional<Direction> special = BlockUtils.tryRotatingSpecial(face, ccw, targetPos, level, state, hit);
        if (special.isPresent()) {
            return special;
        }
        return BlockUtils.tryRotatingBlock(face, ccw, targetPos, level, state, hit);
    }

    public static Optional<Direction> tryRotatingBlock(Direction face, boolean ccw, BlockPos targetPos, World level, Vector3d hit) {
        return BlockUtils.tryRotatingBlock(face, ccw, targetPos, level, level.func_180495_p(targetPos), hit);
    }

    public static Optional<Direction> tryRotatingBlock(Direction dir, boolean ccw, BlockPos targetPos, World world, BlockState state, Vector3d hit) {
        BlockState rotated;
        if (state.func_177230_c() instanceof IRotatable) {
            return ((IRotatable)state.func_177230_c()).rotateOverAxis(state, (IWorldReader)world, targetPos, ccw ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90, dir, hit);
        }
        Optional<BlockState> optional = BlockUtils.getRotatedState(dir, ccw, targetPos, world, state);
        if (optional.isPresent() && (rotated = optional.get()).func_196955_c((IWorldReader)world, targetPos) && (rotated = Block.func_199770_b((BlockState)rotated, (IWorld)world, (BlockPos)targetPos)) != state) {
            if (world instanceof ServerWorld) {
                world.func_180501_a(targetPos, rotated, 11);
            }
            return Optional.of(dir);
        }
        return Optional.empty();
    }

    public static Optional<BlockState> getRotatedState(Direction dir, boolean ccw, BlockPos targetPos, World world, BlockState state) {
        if (BlockUtils.isBlacklisted(state)) {
            return Optional.empty();
        }
        Rotation rot = ccw ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90;
        Block block2 = state.func_177230_c();
        if (state.func_235901_b_((Property)BlockProperties.FLIPPED)) {
            return Optional.of(state.func_235896_a_((Property)BlockProperties.FLIPPED));
        }
        if (dir.func_176740_k() == Direction.Axis.Y) {
            int bites;
            if (block2 == Blocks.field_150414_aQ && (bites = ((Integer)state.func_177229_b((Property)CakeBlock.field_176589_a)).intValue()) != 0) {
                return Optional.of(((BlockState)((Block)ModRegistry.DIRECTIONAL_CAKE.get()).func_176223_P().func_206870_a((Property)CakeBlock.field_176589_a, (Comparable)Integer.valueOf(bites))).rotate((IWorld)world, targetPos, rot));
            }
            BlockState rotated = state.rotate((IWorld)world, targetPos, rot);
            if (rotated == state) {
                if (state.func_235901_b_((Property)BlockStateProperties.field_208155_H)) {
                    rotated = (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H)));
                } else if (state.func_235901_b_((Property)BlockStateProperties.field_208157_J)) {
                    rotated = (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J)));
                } else if (state.func_235901_b_((Property)RotatedPillarBlock.field_176298_M)) {
                    block0 : switch (rot) {
                        case COUNTERCLOCKWISE_90: 
                        case CLOCKWISE_90: {
                            switch ((Direction.Axis)state.func_177229_b((Property)RotatedPillarBlock.field_176298_M)) {
                                case X: {
                                    rotated = (BlockState)state.func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.Z);
                                    break block0;
                                }
                                case Z: {
                                    rotated = (BlockState)state.func_206870_a((Property)RotatedPillarBlock.field_176298_M, (Comparable)Direction.Axis.X);
                                }
                            }
                        }
                    }
                }
            }
            return Optional.of(rotated);
        }
        if (state.func_235901_b_((Property)BlockStateProperties.field_208155_H)) {
            return Optional.of(BlockUtils.rotateBlockStateOnAxis(state, dir, ccw));
        }
        if (state.func_235901_b_((Property)BlockStateProperties.field_208148_A)) {
            Direction.Axis targetAxis = (Direction.Axis)state.func_177229_b((Property)BlockStateProperties.field_208148_A);
            Direction.Axis myAxis = dir.func_176740_k();
            if (myAxis == Direction.Axis.X) {
                return Optional.of(state.func_206870_a((Property)BlockStateProperties.field_208148_A, (Comparable)(targetAxis == Direction.Axis.Y ? Direction.Axis.Z : Direction.Axis.Y)));
            }
            if (myAxis == Direction.Axis.Z) {
                return Optional.of(state.func_206870_a((Property)BlockStateProperties.field_208148_A, (Comparable)(targetAxis == Direction.Axis.Y ? Direction.Axis.X : Direction.Axis.Y)));
            }
        }
        if (block2 instanceof StairsBlock) {
            boolean positive;
            Direction facing = (Direction)state.func_177229_b((Property)StairsBlock.field_176309_a);
            if (facing.func_176740_k() == dir.func_176740_k()) {
                return Optional.empty();
            }
            boolean flipped = dir.func_176743_c() == Direction.AxisDirection.POSITIVE ^ ccw;
            Half half = (Half)state.func_177229_b((Property)StairsBlock.field_176308_b);
            boolean top = half == Half.TOP;
            boolean bl = positive = facing.func_176743_c() == Direction.AxisDirection.POSITIVE;
            if (top ^ positive ^ flipped) {
                half = top ? Half.BOTTOM : Half.TOP;
            } else {
                facing = facing.func_176734_d();
            }
            return Optional.of(((BlockState)state.func_206870_a((Property)StairsBlock.field_176308_b, (Comparable)half)).func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)facing));
        }
        if (state.func_235901_b_((Property)SlabBlock.field_196505_a)) {
            SlabType type = (SlabType)state.func_177229_b((Property)SlabBlock.field_196505_a);
            if (type == SlabType.DOUBLE) {
                return Optional.empty();
            }
            return Optional.of(state.func_206870_a((Property)SlabBlock.field_196505_a, (Comparable)(type == SlabType.BOTTOM ? SlabType.TOP : SlabType.BOTTOM)));
        }
        if (state.func_235901_b_((Property)TrapDoorBlock.field_176285_M)) {
            return Optional.of(state.func_235896_a_((Property)TrapDoorBlock.field_176285_M));
        }
        return Optional.empty();
    }

    private static BlockState rotateBlockStateOnAxis(BlockState state, Direction axis, boolean ccw) {
        Vector3d rotated;
        Vector3d targetNormal = VectorUtils.ItoD(((Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H)).func_176730_m());
        Vector3d myNormal = VectorUtils.ItoD(axis.func_176730_m());
        if (!ccw) {
            targetNormal = targetNormal.func_186678_a(-1.0);
        }
        if ((rotated = myNormal.func_72431_c(targetNormal)) != Vector3d.field_186680_a) {
            Direction newDir = Direction.func_210769_a((double)rotated.func_82615_a(), (double)rotated.func_82617_b(), (double)rotated.func_82616_c());
            return (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)newDir);
        }
        return state;
    }

    private static boolean isBlacklisted(BlockState state) {
        if (state.func_177230_c() instanceof BedBlock) {
            return true;
        }
        if (state.func_235901_b_((Property)BlockStateProperties.field_208140_ao) && state.func_177229_b((Property)BlockStateProperties.field_208140_ao) != ChestType.SINGLE) {
            return true;
        }
        if (state.func_235901_b_((Property)BlockStateProperties.field_208181_h) && ((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208181_h)).booleanValue()) {
            return true;
        }
        if (state.func_235901_b_((Property)BlockStateProperties.field_208195_v)) {
            return true;
        }
        return state.func_177230_c() == Blocks.field_150378_br;
    }

    private static Optional<Direction> tryRotatingSpecial(Direction face, boolean ccw, BlockPos pos, World level, BlockState state, Vector3d hit) {
        Rotation rot;
        Block b = state.func_177230_c();
        Rotation rotation = rot = ccw ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90;
        if (state.func_235901_b_((Property)BlockStateProperties.field_208138_am)) {
            int r = (Integer)state.func_177229_b((Property)BlockStateProperties.field_208138_am);
            if ((r += ccw ? -1 : 1) < 0) {
                r += 16;
            }
            level.func_180501_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208138_am, (Comparable)Integer.valueOf(r %= 16)), 2);
            return Optional.of(Direction.UP);
        }
        if (state.func_235901_b_((Property)BlockStateProperties.field_208181_h) && ((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208181_h)).booleanValue() && state.func_235901_b_((Property)PistonHeadBlock.field_176387_N)) {
            BlockPos newHeadPos;
            BlockState newBase = BlockUtils.rotateBlockStateOnAxis(state, face, ccw);
            BlockPos headPos = pos.func_177972_a((Direction)state.func_177229_b((Property)PistonHeadBlock.field_176387_N));
            if (level.func_180495_p(headPos).func_235901_b_((Property)PistonHeadBlock.field_176327_M) && level.func_180495_p(newHeadPos = pos.func_177972_a((Direction)newBase.func_177229_b((Property)PistonHeadBlock.field_176387_N))).func_185904_a().func_76222_j()) {
                level.func_180501_a(newHeadPos, BlockUtils.rotateBlockStateOnAxis(level.func_180495_p(headPos), face, ccw), 2);
                level.func_180501_a(pos, newBase, 2);
                level.func_217377_a(headPos, false);
                return Optional.of(face);
            }
            return Optional.empty();
        }
        if (state.func_235901_b_((Property)BlockStateProperties.field_208195_v) && state.func_235901_b_((Property)PistonHeadBlock.field_176387_N)) {
            BlockPos newHeadPos;
            BlockState newBase = BlockUtils.rotateBlockStateOnAxis(state, face, ccw);
            BlockPos headPos = pos.func_177972_a(((Direction)state.func_177229_b((Property)PistonHeadBlock.field_176387_N)).func_176734_d());
            if (level.func_180495_p(headPos).func_235901_b_((Property)BlockStateProperties.field_208181_h) && level.func_180495_p(newHeadPos = pos.func_177972_a(((Direction)newBase.func_177229_b((Property)PistonHeadBlock.field_176387_N)).func_176734_d())).func_185904_a().func_76222_j()) {
                level.func_180501_a(newHeadPos, BlockUtils.rotateBlockStateOnAxis(level.func_180495_p(headPos), face, ccw), 2);
                level.func_180501_a(pos, newBase, 2);
                level.func_217377_a(headPos, false);
                return Optional.of(face);
            }
            return Optional.empty();
        }
        if (b instanceof BedBlock && face.func_176740_k() == Direction.Axis.Y) {
            BlockState newBed = state.rotate((IWorld)level, pos, rot);
            BlockPos oldPos = pos.func_177972_a(BlockUtils.getConnectedBedDirection(state));
            BlockPos targetPos = pos.func_177972_a(BlockUtils.getConnectedBedDirection(newBed));
            if (level.func_180495_p(targetPos).func_185904_a().func_76222_j()) {
                level.func_180501_a(targetPos, level.func_180495_p(oldPos).rotate((IWorld)level, oldPos, rot), 2);
                level.func_180501_a(pos, newBed, 2);
                level.func_217377_a(oldPos, false);
                return Optional.of(face);
            }
            return Optional.empty();
        }
        if (b instanceof ChestBlock && face.func_176740_k() == Direction.Axis.Y) {
            if (state.func_177229_b((Property)ChestBlock.field_196314_b) != ChestType.SINGLE) {
                BlockState newChest = state.rotate((IWorld)level, pos, rot);
                BlockPos oldPos = pos.func_177972_a(ChestBlock.func_196311_i((BlockState)state));
                BlockPos targetPos = pos.func_177972_a(ChestBlock.func_196311_i((BlockState)newChest));
                if (level.func_180495_p(targetPos).func_185904_a().func_76222_j()) {
                    BlockState connectedNewState = level.func_180495_p(oldPos).rotate((IWorld)level, oldPos, rot);
                    level.func_180501_a(targetPos, connectedNewState, 2);
                    level.func_180501_a(pos, newChest, 2);
                    TileEntity tile = level.func_175625_s(oldPos);
                    if (tile != null) {
                        CompoundNBT tag = tile.func_189515_b(new CompoundNBT());
                        TileEntity target = TileEntity.func_235657_b_((BlockState)level.func_180495_p(targetPos), (CompoundNBT)tag);
                        if (target != null) {
                            level.func_175690_a(targetPos, target);
                            target.func_145836_u();
                        }
                        tile.func_145843_s();
                    }
                    level.func_175656_a(oldPos, Blocks.field_150350_a.func_176223_P());
                    return Optional.of(face);
                }
            }
            return Optional.empty();
        }
        if (DoorBlock.func_235492_h_((BlockState)state)) {
            // empty if block
        }
        return Optional.empty();
    }

    private static Direction getConnectedBedDirection(BlockState bedState) {
        BedPart part = (BedPart)bedState.func_177229_b((Property)BedBlock.field_176472_a);
        Direction dir = (Direction)bedState.func_177229_b((Property)BedBlock.field_185512_D);
        return part == BedPart.FOOT ? dir : dir.func_176734_d();
    }
}

