/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.tiles;

import java.util.Random;
import net.mehvahdjukaar.supplementaries.block.blocks.LaserBlock;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;

public class LaserBlockTile
extends TileEntity
implements ITickableTileEntity {
    public BlockPos endpos = null;
    public int lenght = 0;
    public float offset = -1.0f;
    public float prevWidth = 0.0f;
    public float width = 0.0f;
    public static final int MAXLENGHT = 15;

    public LaserBlockTile() {
        super((TileEntityType)ModRegistry.LASER_BLOCK_TILE.get());
    }

    public void updateBeam() {
        if (this.canEmit()) {
            BlockPos p = this.field_174879_c;
            Direction dir = this.getDirection();
            int i = 0;
            boolean noblockfound = false;
            for (i = 0; i <= 15; ++i) {
                p = this.field_174879_c.func_177967_a(dir, i + 1);
                BlockState state = this.field_145850_b.func_180495_p(p);
                if (state.func_200016_a((IBlockReader)this.field_145850_b, p) < 15 || !state.func_224755_d((IBlockReader)this.field_145850_b, p, dir.func_176734_d())) continue;
                noblockfound = false;
                break;
            }
            if (this.lenght != i) {
                this.lenght = i;
                this.field_145850_b.func_184138_a(this.field_174879_c, this.func_195044_w(), this.func_195044_w(), 2);
            }
            if (noblockfound) {
                this.endpos = null;
                i = 16;
            } else {
                this.endpos = p;
                this.updateReceivingLaser();
            }
        }
    }

    public void updateReceivingLaser() {
        BlockState state;
        if (this.endpos != null && (state = this.field_145850_b.func_180495_p(this.endpos)).func_177230_c() instanceof LaserBlock && (Integer)state.func_177229_b((Property)LaserBlock.RECEIVING) != MathHelper.func_76125_a((int)(16 - this.lenght), (int)0, (int)15) && state.func_177229_b((Property)LaserBlock.FACING) == ((Direction)this.func_195044_w().func_177229_b((Property)LaserBlock.FACING)).func_176734_d()) {
            this.field_145850_b.func_180501_a(this.endpos, (BlockState)state.func_206870_a((Property)LaserBlock.RECEIVING, (Comparable)Integer.valueOf(MathHelper.func_76125_a((int)(16 - this.lenght), (int)0, (int)15))), 3);
        }
    }

    public void turnOffReceivingLaser() {
        BlockState state;
        if (this.endpos != null && (state = this.field_145850_b.func_180495_p(this.endpos)).func_177230_c() instanceof LaserBlock && (Integer)state.func_177229_b((Property)LaserBlock.RECEIVING) != 0 && state.func_177229_b((Property)LaserBlock.FACING) == ((Direction)this.func_195044_w().func_177229_b((Property)LaserBlock.FACING)).func_176734_d()) {
            this.field_145850_b.func_180501_a(this.endpos, (BlockState)state.func_206870_a((Property)LaserBlock.RECEIVING, (Comparable)Integer.valueOf(0)), 3);
        }
    }

    public boolean canEmit() {
        return this.isPowered() && !this.isReceiving();
    }

    public boolean isReceiving() {
        return (Integer)this.func_195044_w().func_177229_b((Property)LaserBlock.RECEIVING) > 0;
    }

    public boolean isPowered() {
        return (Boolean)this.func_195044_w().func_177229_b((Property)LaserBlock.POWERED);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public double func_145833_n() {
        return 128.0;
    }

    public void func_73660_a() {
        if (this.field_145850_b.func_201670_d()) {
            if (this.offset == -1.0f) {
                this.offset = new Random(this.func_174877_v().func_218275_a()).nextFloat() * (float)Math.PI * 2.0f;
            }
            this.prevWidth = this.width;
            float angle = this.offset + (float)(this.func_145831_w().func_82737_E() % 24000L) / 50.0f;
            this.width = MathHelper.func_76126_a((float)(angle % (float)Math.PI * 2.0f));
        } else if (this.field_145850_b != null && this.field_145850_b.func_82737_E() % 20L == 0L) {
            this.updateBeam();
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.lenght = compound.func_74762_e("Length");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("Length", this.lenght);
        return compound;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
        this.updateBeam();
    }

    public void func_145843_s() {
        super.func_145843_s();
    }

    public Direction getDirection() {
        return (Direction)this.func_195044_w().func_177229_b((Property)LaserBlock.FACING);
    }
}

