/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.blocks;

import net.mehvahdjukaar.selene.blocks.WaterBlock;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import org.jetbrains.annotations.Nullable;

public class VerticalSlabBlock
extends WaterBlock {
    public static final EnumProperty<VerticalSlabType> TYPE = EnumProperty.func_177709_a((String)"type", VerticalSlabType.class);

    public VerticalSlabBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(TYPE, (Comparable)((Object)VerticalSlabType.NORTH))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{TYPE});
    }

    public boolean func_220074_n(BlockState state) {
        return state.func_177229_b(TYPE) != VerticalSlabType.DOUBLE;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return ((VerticalSlabType)((Object)state.func_177229_b(VerticalSlabBlock.TYPE))).shape;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        BlockState blockstate = context.func_195991_k().func_180495_p(blockpos);
        if (blockstate.func_177230_c() == this) {
            return (BlockState)((BlockState)blockstate.func_206870_a(TYPE, (Comparable)((Object)VerticalSlabType.DOUBLE))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.func_195991_k().func_204610_c(blockpos).func_206886_c() == Fluids.field_204546_a))).func_206870_a(TYPE, (Comparable)((Object)VerticalSlabType.fromDirection(this.getDirectionForPlacement(context))));
    }

    private Direction getDirectionForPlacement(BlockItemUseContext context) {
        Direction direction = context.func_196000_l();
        if (direction.func_176740_k() != Direction.Axis.Y) {
            return direction;
        }
        BlockPos pos = context.func_195995_a();
        Vector3d vec = context.func_221532_j().func_178788_d(new Vector3d((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p())).func_178786_a(0.5, 0.0, 0.5);
        double angle = Math.atan2(vec.field_72450_a, vec.field_72449_c) * -180.0 / Math.PI;
        return Direction.func_176733_a((double)angle).func_176734_d();
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext context) {
        VerticalSlabType slabtype = (VerticalSlabType)((Object)state.func_177229_b(TYPE));
        return slabtype != VerticalSlabType.DOUBLE && context.func_195996_i().func_77973_b() == this.func_199767_j() && context.func_196012_c() && context.func_196000_l() == slabtype.direction && this.getDirectionForPlacement(context) == slabtype.direction;
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        return state.func_177229_b(TYPE) != VerticalSlabType.DOUBLE && super.func_204509_a(worldIn, pos, state, fluidStateIn);
    }

    public boolean func_204510_a(IBlockReader worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return state.func_177229_b(TYPE) != VerticalSlabType.DOUBLE && super.func_204510_a(worldIn, pos, state, fluidIn);
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return type == PathType.WATER && worldIn.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a);
    }

    public static enum VerticalSlabType implements IStringSerializable
    {
        NORTH(Direction.NORTH),
        SOUTH(Direction.SOUTH),
        WEST(Direction.WEST),
        EAST(Direction.EAST),
        DOUBLE(null);

        private final String name;
        @Nullable
        public final Direction direction;
        public final VoxelShape shape;

        private VerticalSlabType(Direction direction) {
            this.direction = direction;
            String string2 = this.name = direction == null ? "double" : direction.func_176610_l();
            if (direction == null) {
                this.shape = VoxelShapes.func_197868_b();
            } else {
                boolean isNegativeAxis = direction.func_176743_c() == Direction.AxisDirection.NEGATIVE;
                double min = isNegativeAxis ? 8.0 : 0.0;
                double max = isNegativeAxis ? 16.0 : 8.0;
                this.shape = direction.func_176740_k() == Direction.Axis.X ? Block.func_208617_a((double)min, (double)0.0, (double)0.0, (double)max, (double)16.0, (double)16.0) : Block.func_208617_a((double)0.0, (double)0.0, (double)min, (double)16.0, (double)16.0, (double)max);
            }
        }

        public static VerticalSlabType fromDirection(Direction direction) {
            for (VerticalSlabType type : VerticalSlabType.values()) {
                if (type.direction == null || direction != type.direction) continue;
                return type;
            }
            return null;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

