/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.blocks;

import java.util.Random;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.block.blocks.RopeBlock;
import net.mehvahdjukaar.supplementaries.block.tiles.CrackedBellBlockTile;
import net.mehvahdjukaar.supplementaries.block.util.IBellConnection;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FallingBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.HorizontalFaceBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BellAttachment;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.stats.Stats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class CrackedBellBlock
extends FallingBlock {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final EnumProperty<BellAttachment> ATTACHMENT = BlockStateProperties.field_222511_P;
    public static final BooleanProperty POWERED = BlockStateProperties.field_208194_u;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    public static final EnumProperty<IBellConnection.BellConnection> BELL_CONNECTION = BlockProperties.BELL_CONNECTION;
    private static final VoxelShape BELL_TOP_SHAPE = Block.func_208617_a((double)4.0, (double)3.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    private static final VoxelShape BELL_BOTTOM_SHAPE = Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0);
    private static final VoxelShape FLOOR_SHAPE = VoxelShapes.func_197872_a((VoxelShape)BELL_BOTTOM_SHAPE, (VoxelShape)BELL_TOP_SHAPE);
    private static final VoxelShape BELL_SHAPE = FLOOR_SHAPE.func_197751_a(0.0, 0.0625, 0.0);
    private static final VoxelShape NORTH_SOUTH_BETWEEN = VoxelShapes.func_197872_a((VoxelShape)BELL_SHAPE, (VoxelShape)Block.func_208617_a((double)7.0, (double)13.0, (double)0.0, (double)9.0, (double)15.0, (double)16.0));
    private static final VoxelShape EAST_WEST_BETWEEN = VoxelShapes.func_197872_a((VoxelShape)BELL_SHAPE, (VoxelShape)Block.func_208617_a((double)0.0, (double)13.0, (double)7.0, (double)16.0, (double)15.0, (double)9.0));
    private static final VoxelShape TO_WEST = VoxelShapes.func_197872_a((VoxelShape)BELL_SHAPE, (VoxelShape)Block.func_208617_a((double)0.0, (double)13.0, (double)7.0, (double)13.0, (double)15.0, (double)9.0));
    private static final VoxelShape TO_EAST = VoxelShapes.func_197872_a((VoxelShape)BELL_SHAPE, (VoxelShape)Block.func_208617_a((double)3.0, (double)13.0, (double)7.0, (double)16.0, (double)15.0, (double)9.0));
    private static final VoxelShape TO_NORTH = VoxelShapes.func_197872_a((VoxelShape)BELL_SHAPE, (VoxelShape)Block.func_208617_a((double)7.0, (double)13.0, (double)0.0, (double)9.0, (double)15.0, (double)13.0));
    private static final VoxelShape TO_SOUTH = VoxelShapes.func_197872_a((VoxelShape)BELL_SHAPE, (VoxelShape)Block.func_208617_a((double)7.0, (double)13.0, (double)3.0, (double)9.0, (double)15.0, (double)16.0));
    private static final VoxelShape CEILING_SHAPE = VoxelShapes.func_197872_a((VoxelShape)BELL_SHAPE, (VoxelShape)Block.func_208617_a((double)7.0, (double)13.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0));

    public CrackedBellBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).func_206870_a(BELL_CONNECTION, (Comparable)((Object)IBellConnection.BellConnection.NONE))).func_206870_a((Property)FACING, (Comparable)Direction.NORTH)).func_206870_a(ATTACHMENT, (Comparable)BellAttachment.FLOOR)).func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public int func_189876_x(BlockState p_189876_1_, IBlockReader p_189876_2_, BlockPos p_189876_3_) {
        return 4540232;
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_189539_a(BlockState state, World world, BlockPos pos, int index, int data) {
        super.func_189539_a(state, world, pos, index, data);
        TileEntity tileentity = world.func_175625_s(pos);
        return tileentity != null && tileentity.func_145842_c(index, data);
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block neighbor, BlockPos neighborPos, boolean moving) {
        boolean flag = world.func_175640_z(pos);
        if (flag != (Boolean)state.func_177229_b((Property)POWERED)) {
            if (flag) {
                this.attemptToRing(world, pos, null);
            }
            world.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWERED, (Comparable)Boolean.valueOf(flag)), 3);
        }
    }

    public void func_220066_a(World world, BlockState state, BlockRayTraceResult hit, ProjectileEntity projectile) {
        Entity entity2 = projectile.func_234616_v_();
        PlayerEntity playerentity = entity2 instanceof PlayerEntity ? (PlayerEntity)entity2 : null;
        this.onHit(world, state, hit, playerentity);
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        return this.onHit(world, state, hit, player) ? ActionResultType.func_233537_a_((boolean)world.field_72995_K) : ActionResultType.PASS;
    }

    public boolean onHit(World world, BlockState state, BlockRayTraceResult hit, @Nullable PlayerEntity player) {
        BlockPos blockpos;
        Direction direction = hit.func_216354_b();
        boolean flag = this.isProperHit(state, direction, hit.func_216347_e().field_72448_b - (double)(blockpos = hit.func_216350_a()).func_177956_o());
        if (flag) {
            boolean flag1 = this.attemptToRing(world, blockpos, direction);
            if (flag1 && player != null) {
                player.func_195066_a(Stats.field_219740_ax);
            }
            return true;
        }
        return false;
    }

    private boolean isProperHit(BlockState state, Direction dir, double p_220129_3_) {
        if (dir.func_176740_k() != Direction.Axis.Y && !(p_220129_3_ > (double)0.8124f)) {
            Direction direction = (Direction)state.func_177229_b((Property)FACING);
            BellAttachment bellattachment = (BellAttachment)state.func_177229_b(ATTACHMENT);
            switch (bellattachment) {
                case SINGLE_WALL: 
                case DOUBLE_WALL: {
                    return direction.func_176740_k() != dir.func_176740_k();
                }
                case CEILING: {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean attemptToRing(World world, BlockPos pos, @Nullable Direction direction) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (!world.field_72995_K && tileentity instanceof CrackedBellBlockTile) {
            if (direction == null) {
                direction = (Direction)world.func_180495_p(pos).func_177229_b((Property)FACING);
            }
            ((CrackedBellBlockTile)tileentity).onHit(direction);
            world.func_184133_a(null, pos, SoundEvents.field_219603_Y, SoundCategory.BLOCKS, 2.0f, 0.65f);
            return true;
        }
        return false;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        BellAttachment bellattachment = (BellAttachment)state.func_177229_b(ATTACHMENT);
        if (bellattachment == BellAttachment.FLOOR) {
            return FLOOR_SHAPE;
        }
        if (bellattachment == BellAttachment.CEILING) {
            return CEILING_SHAPE;
        }
        if (bellattachment == BellAttachment.DOUBLE_WALL) {
            return direction != Direction.NORTH && direction != Direction.SOUTH ? EAST_WEST_BETWEEN : NORTH_SOUTH_BETWEEN;
        }
        if (direction == Direction.NORTH) {
            return TO_NORTH;
        }
        if (direction == Direction.SOUTH) {
            return TO_SOUTH;
        }
        return direction == Direction.EAST ? TO_EAST : TO_WEST;
    }

    public BlockRenderType func_149645_b(BlockState p_149645_1_) {
        return BlockRenderType.MODEL;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        boolean water = context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a;
        Direction direction = context.func_196000_l();
        BlockPos blockpos = context.func_195995_a();
        World world = context.func_195991_k();
        Direction.Axis direction$axis = direction.func_176740_k();
        if (direction$axis == Direction.Axis.Y) {
            BlockState blockstate = (BlockState)((BlockState)this.func_176223_P().func_206870_a(ATTACHMENT, (Comparable)(direction == Direction.DOWN ? BellAttachment.CEILING : BellAttachment.FLOOR))).func_206870_a((Property)FACING, (Comparable)context.func_195992_f());
            if (blockstate.func_196955_c((IWorldReader)context.func_195991_k(), blockpos)) {
                return blockstate;
            }
        } else {
            boolean flag = direction$axis == Direction.Axis.X && world.func_180495_p(blockpos.func_177976_e()).func_224755_d((IBlockReader)world, blockpos.func_177976_e(), Direction.EAST) && world.func_180495_p(blockpos.func_177974_f()).func_224755_d((IBlockReader)world, blockpos.func_177974_f(), Direction.WEST) || direction$axis == Direction.Axis.Z && world.func_180495_p(blockpos.func_177978_c()).func_224755_d((IBlockReader)world, blockpos.func_177978_c(), Direction.SOUTH) && world.func_180495_p(blockpos.func_177968_d()).func_224755_d((IBlockReader)world, blockpos.func_177968_d(), Direction.NORTH);
            BlockState blockstate1 = (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)direction.func_176734_d())).func_206870_a(ATTACHMENT, (Comparable)(flag ? BellAttachment.DOUBLE_WALL : BellAttachment.SINGLE_WALL));
            if (blockstate1.func_196955_c((IWorldReader)context.func_195991_k(), context.func_195995_a())) {
                return blockstate1;
            }
            boolean flag1 = world.func_180495_p(blockpos.func_177977_b()).func_224755_d((IBlockReader)world, blockpos.func_177977_b(), Direction.UP);
            if ((blockstate1 = (BlockState)blockstate1.func_206870_a(ATTACHMENT, (Comparable)(flag1 ? BellAttachment.FLOOR : BellAttachment.CEILING))).func_196955_c((IWorldReader)context.func_195991_k(), context.func_195995_a())) {
                return blockstate1;
            }
        }
        return null;
    }

    public BlockState func_196271_a(BlockState state, Direction dir, BlockState p_196271_3_, IWorld world, BlockPos pos, BlockPos p_196271_6_) {
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        BellAttachment bellattachment = (BellAttachment)state.func_177229_b(ATTACHMENT);
        Direction direction = CrackedBellBlock.getConnectedDirection(state).func_176734_d();
        if (direction == dir && !state.func_196955_c((IWorldReader)world, pos) && bellattachment != BellAttachment.DOUBLE_WALL) {
            return Blocks.field_150350_a.func_176223_P();
        }
        if (dir.func_176740_k() == ((Direction)state.func_177229_b((Property)FACING)).func_176740_k()) {
            if (bellattachment == BellAttachment.DOUBLE_WALL && !p_196271_3_.func_224755_d((IBlockReader)world, p_196271_6_, dir)) {
                return (BlockState)((BlockState)state.func_206870_a(ATTACHMENT, (Comparable)BellAttachment.SINGLE_WALL)).func_206870_a((Property)FACING, (Comparable)dir.func_176734_d());
            }
            if (bellattachment == BellAttachment.SINGLE_WALL && direction.func_176734_d() == dir && p_196271_3_.func_224755_d((IBlockReader)world, p_196271_6_, (Direction)state.func_177229_b((Property)FACING))) {
                return (BlockState)state.func_206870_a(ATTACHMENT, (Comparable)BellAttachment.DOUBLE_WALL);
            }
        }
        return super.func_196271_a(state, dir, p_196271_3_, world, pos, p_196271_6_);
    }

    public static boolean canFall(BlockState state, BlockPos pos, IWorld world) {
        boolean isAttached;
        Direction direction = CrackedBellBlock.getConnectedDirection(state).func_176734_d();
        switch (direction) {
            case UP: {
                isAttached = RopeBlock.isSupportingCeiling(pos.func_177984_a(), (IWorldReader)world);
                break;
            }
            case DOWN: {
                isAttached = !world.func_175623_d(pos.func_177977_b()) && !CrackedBellBlock.func_185759_i((BlockState)world.func_180495_p(pos.func_177977_b()));
                break;
            }
            default: {
                isAttached = HorizontalFaceBlock.func_220185_b((IWorldReader)world, (BlockPos)pos, (Direction)direction);
            }
        }
        return !isAttached && pos.func_177956_o() >= 0;
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (CrackedBellBlock.canFall(state, pos, (IWorld)world)) {
            FallingBlockEntity fallingblockentity = new FallingBlockEntity((World)world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, (BlockState)world.func_180495_p(pos).func_206870_a(ATTACHMENT, (Comparable)BellAttachment.FLOOR));
            this.func_149829_a(fallingblockentity);
            world.func_217376_c((Entity)fallingblockentity);
        }
    }

    protected void func_149829_a(FallingBlockEntity entity2) {
        entity2.func_145806_a(true);
    }

    public void func_176502_a_(World world, BlockPos pos, BlockState state, BlockState onState, FallingBlockEntity entity2) {
        if (!entity2.func_174814_R()) {
            world.func_217379_c(1031, pos, 0);
        }
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    private static Direction getConnectedDirection(BlockState p_220131_0_) {
        switch ((BellAttachment)p_220131_0_.func_177229_b(ATTACHMENT)) {
            case FLOOR: {
                return Direction.UP;
            }
            case CEILING: {
                return Direction.DOWN;
            }
        }
        return ((Direction)p_220131_0_.func_177229_b((Property)FACING)).func_176734_d();
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.DESTROY;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FACING, ATTACHMENT, POWERED, WATERLOGGED, BELL_CONNECTION});
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new CrackedBellBlockTile();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    public boolean func_196266_a(BlockState state, IBlockReader reader, BlockPos pos, PathType pathType) {
        return false;
    }
}

