/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.blockout.Log;
import com.ldtteam.structurize.blocks.interfaces.IBlueprintDataProvider;
import com.ldtteam.structurize.network.messages.IMessage;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class AddRemoveTagMessage
implements IMessage {
    private boolean add = false;
    private String tag = "";
    private final BlockPos anchorPos;
    private final BlockPos tagPos;

    public AddRemoveTagMessage(PacketBuffer buf) {
        this.add = buf.readBoolean();
        this.tag = buf.func_150789_c(Short.MAX_VALUE);
        this.anchorPos = buf.func_179259_c();
        this.tagPos = buf.func_179259_c();
    }

    public AddRemoveTagMessage(boolean add, String tag, BlockPos tagPos, BlockPos anchorPos) {
        this.anchorPos = anchorPos;
        this.tagPos = tagPos;
        this.add = add;
        this.tag = tag;
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.writeBoolean(this.add);
        buf.func_180714_a(this.tag);
        buf.func_179255_a(this.anchorPos);
        buf.func_179255_a(this.tagPos);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.SERVER;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        if (ctxIn.getSender() == null) {
            return;
        }
        TileEntity te = ctxIn.getSender().field_70170_p.func_175625_s(this.anchorPos);
        if (te instanceof IBlueprintDataProvider) {
            IBlueprintDataProvider dataTE = (IBlueprintDataProvider)te;
            if (this.add) {
                dataTE.addTag(this.tagPos, this.tag);
            } else {
                dataTE.removeTag(this.tagPos, this.tag);
            }
        } else {
            Log.getLogger().info("Tried to add data tag to invalid tileentity:" + te);
        }
    }
}

