/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.blocks.decorative;

import com.ldtteam.structurize.blocks.types.ShingleFaceType;
import com.ldtteam.structurize.blocks.types.ShingleSlabShapeType;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.Material;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DyeColor;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import org.jetbrains.annotations.NotNull;

public class BlockShingleSlab
extends HorizontalBlock
implements IWaterLoggable {
    public static final EnumProperty<ShingleSlabShapeType> SHAPE = EnumProperty.func_177709_a((String)"shape", ShingleSlabShapeType.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static final float BLOCK_HARDNESS = 3.0f;
    private static final float RESISTANCE = 1.0f;
    private static final int FOUR_CONNECTIONS = 4;
    private static final int THREE_CONNECTIONS = 3;
    private static final int TWO_CONNECTIONS = 2;
    private static final int ONE_CONNECTION = 1;
    private final ShingleFaceType faceType;
    private final DyeColor color;

    public BlockShingleSlab(ShingleFaceType faceType, DyeColor color) {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d).func_200948_a(3.0f, 1.0f));
        this.faceType = faceType;
        this.color = color;
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction HORIZONTAL_FACING, BlockState HORIZONTAL_FACINGState, IWorld worldIn, BlockPos currentPos, BlockPos HORIZONTAL_FACINGPos) {
        if (((Boolean)stateIn.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return BlockShingleSlab.getSlabShape(stateIn, worldIn, currentPos);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        @NotNull Direction facing = context.func_195999_j() == null ? Direction.NORTH : Direction.func_176733_a((double)context.func_195999_j().field_70177_z);
        return BlockShingleSlab.getSlabShape((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)field_185512_D, (Comparable)facing)).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.func_195991_k().func_204610_c(context.func_195995_a()).func_206886_c() == Fluids.field_204546_a)), (IWorld)context.func_195991_k(), context.func_195995_a());
    }

    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public ShingleFaceType getFaceType() {
        return this.faceType;
    }

    public DyeColor getColor() {
        return this.color;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)15.9, (double)7.9, (double)15.9);
    }

    private static BlockState getSlabShape(@NotNull BlockState state, @NotNull IWorld world, @NotNull BlockPos position) {
        BlockState shapeState;
        boolean north = world.func_180495_p(position.func_177978_c()).func_177230_c() instanceof BlockShingleSlab;
        boolean south = world.func_180495_p(position.func_177968_d()).func_177230_c() instanceof BlockShingleSlab;
        boolean east = world.func_180495_p(position.func_177974_f()).func_177230_c() instanceof BlockShingleSlab;
        boolean west = world.func_180495_p(position.func_177976_e()).func_177230_c() instanceof BlockShingleSlab;
        boolean[] connectors = new boolean[]{north, south, east, west};
        int amount = 0;
        for (boolean check : connectors) {
            if (!check) continue;
            ++amount;
        }
        if (amount == 1) {
            shapeState = (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)ShingleSlabShapeType.ONE_WAY));
            if (north) {
                return (BlockState)shapeState.func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH);
            }
            if (south) {
                return (BlockState)shapeState.func_206870_a((Property)field_185512_D, (Comparable)Direction.SOUTH);
            }
            if (east) {
                return (BlockState)shapeState.func_206870_a((Property)field_185512_D, (Comparable)Direction.EAST);
            }
            if (west) {
                return (BlockState)shapeState.func_206870_a((Property)field_185512_D, (Comparable)Direction.WEST);
            }
        }
        if (amount == 2) {
            if (north && east) {
                shapeState = (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)ShingleSlabShapeType.CURVED));
                return (BlockState)shapeState.func_206870_a((Property)field_185512_D, (Comparable)Direction.WEST);
            }
            if (north && west) {
                shapeState = (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)ShingleSlabShapeType.CURVED));
                return (BlockState)shapeState.func_206870_a((Property)field_185512_D, (Comparable)Direction.SOUTH);
            }
            if (south && east) {
                shapeState = (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)ShingleSlabShapeType.CURVED));
                return (BlockState)shapeState.func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH);
            }
            if (south && west) {
                shapeState = (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)ShingleSlabShapeType.CURVED));
                return (BlockState)shapeState.func_206870_a((Property)field_185512_D, (Comparable)Direction.EAST);
            }
            if (north && south) {
                shapeState = (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)ShingleSlabShapeType.TWO_WAY));
                return (BlockState)shapeState.func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH);
            }
            if (east && west) {
                shapeState = (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)ShingleSlabShapeType.TWO_WAY));
                return (BlockState)shapeState.func_206870_a((Property)field_185512_D, (Comparable)Direction.EAST);
            }
        }
        if (amount == 3) {
            shapeState = (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)ShingleSlabShapeType.THREE_WAY));
            if (north && east && west) {
                return (BlockState)shapeState.func_206870_a((Property)field_185512_D, (Comparable)Direction.NORTH);
            }
            if (south && east && west) {
                return (BlockState)shapeState.func_206870_a((Property)field_185512_D, (Comparable)Direction.SOUTH);
            }
            if (east && north && south) {
                return (BlockState)shapeState.func_206870_a((Property)field_185512_D, (Comparable)Direction.EAST);
            }
            if (west && north && south) {
                return (BlockState)shapeState.func_206870_a((Property)field_185512_D, (Comparable)Direction.WEST);
            }
        }
        if (amount == 4) {
            shapeState = (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)ShingleSlabShapeType.FOUR_WAY));
            return shapeState;
        }
        return (BlockState)state.func_206870_a(SHAPE, (Comparable)((Object)ShingleSlabShapeType.TOP));
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return type == PathType.WATER && worldIn.func_204610_c(pos).func_206884_a((ITag)FluidTags.field_206959_a);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_185512_D, SHAPE, WATERLOGGED});
    }
}

