/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structures.lib;

import com.ldtteam.structures.blueprints.v1.Blueprint;
import com.ldtteam.structures.client.BlueprintBlockAccess;
import com.ldtteam.structures.client.BlueprintBlockInfoTransformHandler;
import com.ldtteam.structures.client.BlueprintEntityInfoTransformHandler;
import com.ldtteam.structurize.api.util.Log;
import com.ldtteam.structurize.util.BlockInfo;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BlueprintUtils {
    private static final Function<BlockPos, BlockInfo> DEFAULT_FACTORY = pos -> new BlockInfo((BlockPos)pos, Blocks.field_150350_a.func_176223_P(), null);

    private BlueprintUtils() {
        throw new IllegalArgumentException("Utils class");
    }

    public static TileEntity getTileEntityFromPos(Blueprint blueprint, BlockPos pos, BlueprintBlockAccess access) {
        BlockInfo blockInfo = BlueprintUtils.getBlockInfoFromPos(blueprint, pos);
        if (blockInfo.getTileEntityData() != null) {
            return BlueprintUtils.constructTileEntity(blockInfo, access);
        }
        return null;
    }

    public static BlockInfo getBlockInfoFromPos(Blueprint blueprint, BlockPos pos) {
        BlockInfo blockInfo = blueprint.getBlockInfoAsMap().get(pos);
        return blockInfo == null ? DEFAULT_FACTORY.apply(pos) : blockInfo;
    }

    @NotNull
    public static List<TileEntity> instantiateTileEntities(@NotNull Blueprint blueprint, @NotNull BlueprintBlockAccess blockAccess) {
        return blueprint.getBlockInfoAsList().stream().map(blockInfo -> BlueprintBlockInfoTransformHandler.getInstance().Transform((BlockInfo)blockInfo)).filter(blockInfo -> blockInfo.getTileEntityData() != null).map(blockInfo -> BlueprintUtils.constructTileEntity(blockInfo, blockAccess)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @NotNull
    public static List<Entity> instantiateEntities(@NotNull Blueprint blueprint, @NotNull BlueprintBlockAccess blockAccess) {
        return blueprint.getEntitiesAsList().stream().map(entityInfo -> BlueprintEntityInfoTransformHandler.getInstance().Transform((CompoundNBT)entityInfo)).map(entityInfo -> BlueprintUtils.constructEntity(entityInfo, blockAccess)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    private static TileEntity constructTileEntity(@NotNull BlockInfo info, @NotNull BlueprintBlockAccess blockAccess) {
        if (info.getTileEntityData() == null) {
            return null;
        }
        String entityId = info.getTileEntityData().func_74779_i("id");
        try {
            CompoundNBT compound = info.getTileEntityData().func_74737_b();
            compound.func_74768_a("x", info.getPos().func_177958_n());
            compound.func_74768_a("y", info.getPos().func_177956_o());
            compound.func_74768_a("z", info.getPos().func_177952_p());
            TileEntity entity = TileEntity.func_235657_b_((BlockState)info.getState(), (CompoundNBT)compound);
            if (entity != null) {
                entity.func_226984_a_((World)blockAccess, info.getPos());
            }
            return entity;
        }
        catch (Exception ex) {
            Log.getLogger().error("Could not create tile entity: " + entityId + " with nbt: " + info.toString(), (Throwable)ex);
            return null;
        }
    }

    @Nullable
    private static Entity constructEntity(@Nullable CompoundNBT info, @NotNull BlueprintBlockAccess blockAccess) {
        if (info == null) {
            return null;
        }
        String entityId = info.func_74779_i("id");
        try {
            Entity entity;
            CompoundNBT compound = info.func_74737_b();
            compound.func_186854_a("UUID", UUID.randomUUID());
            Optional type = EntityType.func_220347_a((CompoundNBT)compound);
            if (type.isPresent() && (entity = ((EntityType)type.get()).func_200721_a((World)blockAccess)) != null) {
                entity.deserializeNBT(compound);
                return entity;
            }
            return null;
        }
        catch (Exception ex) {
            Log.getLogger().error("Could not create entity: " + entityId + " with nbt: " + info.toString(), (Throwable)ex);
            return null;
        }
    }
}

