/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.controls;

import com.ldtteam.blockout.Alignment;
import com.ldtteam.blockout.PaneParams;
import com.ldtteam.blockout.controls.Button;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.util.ResourceLocation;

public class ButtonVanilla
extends Button {
    private static final ResourceLocation TEXTURE = new ResourceLocation("textures/gui/widgets.png");
    private static final int TEXTURE_SIZE = 256;
    private static final int TEXTURE_INNER_U_OFFSET = 2;
    private static final int TEXTURE_INNER_V_OFFSET = 2;
    private static final int TEXTURE_INNER_U_WIDTH = 196;
    private static final int TEXTURE_INNER_V_HEIGHT = 15;
    private static final int DEFAULT_BUTTON_WIDTH = 200;
    private static final int DEFAULT_BUTTON_HEIGHT = 20;
    private static final int ENABLED_COLOR = 0xE0E0E0;
    private static final int HOVER_COLOR = 0xFFFFA0;
    private static final int DISABLED_COLOR = 0xA0A0A0;
    private static final int ENABLED_TEXTURE_V = 66;
    private static final int HOVER_TEXTURE_V = 86;
    private static final int DISABLED_TEXTURE_V = 46;

    public ButtonVanilla() {
        super(Alignment.MIDDLE, 0xE0E0E0, 0xFFFFA0, 0xA0A0A0, true, true);
        this.width = 200;
        this.height = 20;
        this.recalcTextBox();
    }

    public ButtonVanilla(PaneParams params) {
        super(params, Alignment.MIDDLE, 0xE0E0E0, 0xFFFFA0, 0xA0A0A0, true, true);
        if (this.width == 0) {
            this.width = 200;
        }
        if (this.height == 0) {
            this.height = 20;
        }
        this.recalcTextBox();
    }

    @Override
    public void drawSelf(MatrixStack ms, double mx, double my) {
        this.mc.func_110434_K().func_110577_a(TEXTURE);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean u = false;
        int v = this.enabled ? (this.wasCursorInPane ? 86 : 66) : 46;
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.blendFunc((int)770, (int)771);
        if (this.width == 200 && this.height == 20) {
            this.func_238474_b_(ms, this.x, this.y, 0, v, this.width, this.height);
        } else {
            ButtonVanilla.blitRepeatable(ms, this.x, this.y, this.width, this.height, 0, v, 200, 20, 256, 256, 2, 2, 196, 15);
        }
        RenderSystem.disableBlend();
        super.drawSelf(ms, mx, my);
    }

    private void recalcTextBox() {
        this.textOffsetX = 2;
        this.textOffsetY = 2;
        this.textWidth = this.width - 4;
        this.textHeight = this.height - 5;
        this.recalcTextRendering();
    }

    @Override
    public void setSize(int w, int h) {
        super.setSize(w, h);
        this.recalcTextBox();
    }
}

