/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.controls;

import com.ldtteam.blockout.Alignment;
import com.ldtteam.blockout.PaneParams;
import com.ldtteam.blockout.Parsers;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.Image;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;

public class ButtonImage
extends Button {
    private static final int DEFAULT_BUTTON_SIZE = 20;
    protected ResourceLocation image;
    protected ResourceLocation imageHighlight;
    protected ResourceLocation imageDisabled;
    protected int imageOffsetX = 0;
    protected int imageOffsetY = 0;
    protected int imageWidth = 0;
    protected int imageHeight = 0;
    protected int imageMapWidth = 256;
    protected int imageMapHeight = 256;
    protected int highlightOffsetX = 0;
    protected int highlightOffsetY = 0;
    protected int highlightWidth = 0;
    protected int highlightHeight = 0;
    protected int highlightMapWidth = 256;
    protected int highlightMapHeight = 256;
    protected int disabledOffsetX = 0;
    protected int disabledOffsetY = 0;
    protected int disabledWidth = 0;
    protected int disabledHeight = 0;
    protected int disabledMapWidth = 256;
    protected int disabledMapHeight = 256;

    public ButtonImage() {
        super(Alignment.MIDDLE, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, false, false);
        this.width = 20;
        this.height = 20;
        this.recalcTextRendering();
    }

    public ButtonImage(PaneParams params) {
        super(params, Alignment.MIDDLE, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, false, false);
        this.loadImageInfo(params);
        this.loadHighlightInfo(params);
        this.loadDisabledInfo(params);
        this.loadTextInfo(params);
    }

    private void loadImageInfo(PaneParams params) {
        this.image = params.getResource("source", this::loadImageDimensions);
        params.applyShorthand("imageoffset", Parsers.INT, 2, a -> {
            this.imageOffsetX = (Integer)a.get(0);
            this.imageOffsetY = (Integer)a.get(1);
        });
        params.applyShorthand("imagesize", Parsers.INT, 2, a -> {
            this.imageWidth = (Integer)a.get(0);
            this.imageHeight = (Integer)a.get(1);
        });
    }

    private void loadHighlightInfo(PaneParams params) {
        this.imageHighlight = params.getResource("highlight", this::loadImageHighlightDimensions);
        params.applyShorthand("highlightoffset", Parsers.INT, 2, a -> {
            this.highlightOffsetX = (Integer)a.get(0);
            this.highlightOffsetY = (Integer)a.get(1);
        });
        params.applyShorthand("highlightsize", Parsers.INT, 2, a -> {
            this.highlightWidth = (Integer)a.get(0);
            this.highlightHeight = (Integer)a.get(1);
        });
    }

    private void loadDisabledInfo(PaneParams params) {
        this.imageDisabled = params.getResource("disabled", this::loadImageDisabledDimensions);
        params.applyShorthand("disabledoffset", Parsers.INT, 2, a -> {
            this.disabledOffsetX = (Integer)a.get(0);
            this.disabledOffsetY = (Integer)a.get(1);
        });
        params.applyShorthand("disabledsize", Parsers.INT, 2, a -> {
            this.disabledWidth = (Integer)a.get(0);
            this.disabledHeight = (Integer)a.get(1);
        });
    }

    private void loadTextInfo(PaneParams params) {
        this.textColor = params.getColor("textcolor", this.textColor);
        this.textHoverColor = params.getColor("texthovercolor", this.textColor);
        this.textDisabledColor = params.getColor("textdisabledcolor", this.textColor);
        params.applyShorthand("textoffset", Parsers.INT, 2, a -> {
            this.textOffsetX = (Integer)a.get(0);
            this.textOffsetY = (Integer)a.get(1);
        });
        params.applyShorthand("textbox", Parsers.INT, 2, a -> {
            this.textWidth = (Integer)a.get(0);
            this.textHeight = (Integer)a.get(1);
        });
        this.recalcTextRendering();
    }

    private void loadImageDimensions(ResourceLocation rl) {
        Tuple<Integer, Integer> dimensions = Image.getImageDimensions(rl);
        this.imageMapWidth = (Integer)dimensions.func_76341_a();
        this.imageMapHeight = (Integer)dimensions.func_76340_b();
    }

    private void loadImageHighlightDimensions(ResourceLocation rl) {
        Tuple<Integer, Integer> dimensions = Image.getImageDimensions(rl);
        this.highlightMapWidth = (Integer)dimensions.func_76341_a();
        this.highlightMapHeight = (Integer)dimensions.func_76340_b();
    }

    private void loadImageDisabledDimensions(ResourceLocation rl) {
        Tuple<Integer, Integer> dimensions = Image.getImageDimensions(rl);
        this.disabledMapWidth = (Integer)dimensions.func_76341_a();
        this.disabledMapHeight = (Integer)dimensions.func_76340_b();
    }

    public void setImage(String source) {
        this.setImage(source, 0, 0, 0, 0);
    }

    public void setImage(String source, int offsetX, int offsetY, int w, int h) {
        this.setImage(source != null ? new ResourceLocation(source) : null, offsetX, offsetY, w, h);
    }

    public void setImage(ResourceLocation loc, int offsetX, int offsetY, int w, int h) {
        this.image = loc;
        this.imageOffsetX = offsetX;
        this.imageOffsetY = offsetY;
        this.imageHeight = w;
        this.imageWidth = h;
        this.loadImageDimensions(loc);
    }

    public void setImage(ResourceLocation loc) {
        this.setImage(loc, 0, 0, 0, 0);
    }

    public void setImageHighlight(String source) {
        this.setImageHighlight(source, 0, 0, 0, 0);
    }

    public void setImageHighlight(String source, int offsetX, int offsetY, int w, int h) {
        this.setImageHighlight(source != null ? new ResourceLocation(source) : null, offsetX, offsetY, w, h);
    }

    public void setImageHighlight(ResourceLocation loc, int offsetX, int offsetY, int w, int h) {
        this.imageHighlight = loc;
        this.highlightOffsetX = offsetX;
        this.highlightOffsetY = offsetY;
        this.highlightHeight = w;
        this.highlightWidth = h;
        this.loadImageHighlightDimensions(loc);
    }

    public void setImageHighlight(ResourceLocation loc) {
        this.setImageHighlight(loc, 0, 0, 0, 0);
    }

    public void setImageDisabled(String source) {
        this.setImageHighlight(source, 0, 0, 0, 0);
    }

    public void setImageDisabled(String source, int offsetX, int offsetY, int w, int h) {
        this.setImageHighlight(source != null ? new ResourceLocation(source) : null, offsetX, offsetY, w, h);
    }

    public void setImageDisabled(ResourceLocation loc) {
        this.setImageHighlight(loc, 0, 0, 0, 0);
    }

    public void setImageDisabled(ResourceLocation loc, int offsetX, int offsetY, int w, int h) {
        this.imageDisabled = loc;
        this.disabledOffsetX = offsetX;
        this.disabledOffsetY = offsetY;
        this.disabledHeight = w;
        this.disabledWidth = h;
        this.loadImageDisabledDimensions(loc);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void drawSelf(MatrixStack ms, double mx, double my) {
        ResourceLocation bind = this.image;
        int u = this.imageOffsetX;
        int v = this.imageOffsetY;
        int w = this.imageWidth;
        int h = this.imageHeight;
        int mapWidth = this.imageMapWidth;
        int mapHeight = this.imageMapHeight;
        if (!this.enabled) {
            if (this.imageDisabled == null) return;
            bind = this.imageDisabled;
            u = this.disabledOffsetX;
            v = this.disabledOffsetY;
            w = this.disabledWidth;
            h = this.disabledHeight;
            mapWidth = this.disabledMapWidth;
            mapHeight = this.disabledMapHeight;
        } else if (this.wasCursorInPane && this.imageHighlight != null) {
            bind = this.imageHighlight;
            u = this.highlightOffsetX;
            v = this.highlightOffsetY;
            w = this.highlightWidth;
            h = this.highlightHeight;
            mapWidth = this.highlightMapWidth;
            mapHeight = this.highlightMapHeight;
        }
        if (w == 0 || w > this.getWidth()) {
            w = this.getWidth();
        }
        if (h == 0 || h > this.getHeight()) {
            h = this.getHeight();
        }
        this.mc.func_110434_K().func_110577_a(bind);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        RenderSystem.blendFunc((int)770, (int)771);
        if (this.enabled || this.imageDisabled != null) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ButtonImage.func_238463_a_((MatrixStack)ms, (int)this.x, (int)this.y, (float)u, (float)v, (int)w, (int)h, (int)mapWidth, (int)mapHeight);
        } else {
            RenderSystem.color4f((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
            ButtonImage.func_238463_a_((MatrixStack)ms, (int)this.x, (int)this.y, (float)u, (float)v, (int)w, (int)h, (int)mapWidth, (int)mapHeight);
        }
        RenderSystem.disableBlend();
        super.drawSelf(ms, mx, my);
    }

    @Override
    public void setSize(int w, int h) {
        int newTextWidth = (int)((double)(this.textWidth * w) / (double)this.width);
        int newTextHeight = (int)((double)(this.textHeight * h) / (double)this.height);
        super.setSize(w, h);
        this.textWidth = newTextWidth;
        this.textHeight = newTextHeight;
        this.recalcTextRendering();
    }

    public void setTextOffset(int textOffsetX, int textOffsetY) {
        this.textOffsetX = MathHelper.func_76125_a((int)textOffsetX, (int)0, (int)this.width);
        this.textOffsetY = MathHelper.func_76125_a((int)textOffsetY, (int)0, (int)this.height);
    }

    public void setTextRenderBox(int textWidth, int textHeight) {
        this.textWidth = MathHelper.func_76125_a((int)textWidth, (int)0, (int)(this.width - this.textOffsetX));
        this.textHeight = MathHelper.func_76125_a((int)textHeight, (int)0, (int)(this.height - this.textOffsetY));
        this.recalcTextRendering();
    }
}

