/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.structurize.Network;
import com.ldtteam.structurize.client.gui.WindowUndoRedo;
import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.network.messages.IMessage;
import com.ldtteam.structurize.util.ChangeStorage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class OperationHistoryMessage
implements IMessage {
    private List<Tuple<String, Integer>> operationIDs = new ArrayList<Tuple<String, Integer>>();

    public OperationHistoryMessage(PacketBuffer buf) {
        int count = buf.readInt();
        this.operationIDs = new ArrayList<Tuple<String, Integer>>();
        for (int i = 0; i < count; ++i) {
            this.operationIDs.add((Tuple<String, Integer>)new Tuple((Object)buf.func_218666_n(), (Object)buf.readInt()));
        }
    }

    public OperationHistoryMessage() {
    }

    @Override
    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.operationIDs.size());
        for (Tuple<String, Integer> operation : this.operationIDs) {
            buf.func_180714_a((String)operation.func_76341_a());
            buf.writeInt(((Integer)operation.func_76340_b()).intValue());
        }
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return null;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        if (isLogicalServer) {
            if (ctxIn.getSender() == null) {
                return;
            }
            List<ChangeStorage> operations = Manager.getChangeStoragesForPlayer(ctxIn.getSender().func_110124_au());
            this.operationIDs = new ArrayList<Tuple<String, Integer>>();
            for (ChangeStorage storage : operations) {
                this.operationIDs.add((Tuple<String, Integer>)new Tuple((Object)storage.getOperation(), (Object)storage.getID()));
            }
            Network.getNetwork().sendToPlayer(this, ctxIn.getSender());
        } else {
            WindowUndoRedo.lastOperations = this.operationIDs;
        }
    }
}

