/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.event;

import com.ldtteam.blockout.hooks.HookManager;
import com.ldtteam.blockout.hooks.HookRegistries;
import com.ldtteam.structures.blueprints.v1.Blueprint;
import com.ldtteam.structures.client.BlueprintHandler;
import com.ldtteam.structures.client.StructureClientHandler;
import com.ldtteam.structures.helpers.Settings;
import com.ldtteam.structurize.api.util.BlockPosUtil;
import com.ldtteam.structurize.blocks.interfaces.IBlueprintDataProvider;
import com.ldtteam.structurize.items.ModItems;
import com.ldtteam.structurize.optifine.OptifineCompat;
import com.ldtteam.structurize.util.RenderUtils;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeBuffers;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.NotNull;

public class ClientEventSubscriber {
    public static final RenderTypeBuffers renderBuffers = new RenderTypeBuffers();

    @SubscribeEvent
    public static void renderWorldLastEvent(@NotNull RenderWorldLastEvent event) {
        ItemStack itemStack;
        Settings.instance.startStructurizePass();
        OptifineCompat.getInstance().preBlueprintDraw();
        MatrixStack matrixStack = event.getMatrixStack();
        float partialTicks = event.getPartialTicks();
        IRenderTypeBuffer.Impl renderBuffer = renderBuffers.func_228487_b_();
        Supplier<IVertexBuilder> linesWithCullAndDepth = () -> renderBuffer.getBuffer(RenderType.func_228659_m_());
        Supplier<IVertexBuilder> linesWithoutCullAndDepth = () -> renderBuffer.getBuffer(RenderUtils.LINES_GLINT);
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        Blueprint blueprint = Settings.instance.getActiveStructure();
        if (blueprint != null) {
            Minecraft.func_71410_x().func_213239_aq().func_76320_a("struct_render");
            BlockPos pos2 = Settings.instance.getPosition();
            BlockPos posMinusOffset = pos2.func_177973_b((Vector3i)blueprint.getPrimaryBlockOffset());
            StructureClientHandler.renderStructure(blueprint, partialTicks, pos2, matrixStack);
            ClientEventSubscriber.renderAnchorPos(pos2, matrixStack, linesWithoutCullAndDepth.get());
            RenderUtils.renderWhiteOutlineBox(posMinusOffset, posMinusOffset.func_177982_a(blueprint.getSizeX() - 1, blueprint.getSizeY() - 1, blueprint.getSizeZ() - 1), matrixStack, linesWithCullAndDepth.get());
            renderBuffer.func_228462_a_(RenderType.func_228659_m_());
            renderBuffer.func_228462_a_(RenderUtils.LINES_GLINT);
            Minecraft.func_71410_x().func_213239_aq().func_76319_b();
        }
        if (Settings.instance.getBox() != null) {
            Minecraft.func_71410_x().func_213239_aq().func_76320_a("struct_box");
            Settings.instance.getAnchorPos().ifPresent(pos -> ClientEventSubscriber.renderAnchorPos(pos, matrixStack, (IVertexBuilder)linesWithoutCullAndDepth.get()));
            RenderUtils.renderWhiteOutlineBox((BlockPos)Settings.instance.getBox().func_76341_a(), (BlockPos)Settings.instance.getBox().func_76340_b(), matrixStack, linesWithoutCullAndDepth.get());
            renderBuffer.func_228462_a_(RenderUtils.LINES_GLINT);
            Minecraft.func_71410_x().func_213239_aq().func_76319_b();
        }
        if ((itemStack = player.func_184586_b(Hand.MAIN_HAND)).func_77973_b() == ModItems.tagTool.get() && itemStack.func_196082_o().func_74764_b("anchorpostag")) {
            BlockPos tagAnchor = BlockPosUtil.readFromNBT(itemStack.func_77978_p(), "anchorpostag");
            TileEntity te = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_175625_s(tagAnchor);
            ClientEventSubscriber.renderAnchorPos(tagAnchor, matrixStack, linesWithoutCullAndDepth.get());
            if (te instanceof IBlueprintDataProvider) {
                Map<BlockPos, List<String>> tagPosList = ((IBlueprintDataProvider)te).getWorldTagPosMap();
                for (Map.Entry<BlockPos, List<String>> entry : tagPosList.entrySet()) {
                    RenderUtils.renderWhiteOutlineBox(entry.getKey(), entry.getKey(), matrixStack, linesWithoutCullAndDepth.get());
                    IRenderTypeBuffer.Impl buffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
                    RenderUtils.renderDebugText(entry.getKey(), entry.getValue(), matrixStack, true, 3, (IRenderTypeBuffer)buffer);
                    RenderSystem.disableDepthTest();
                    buffer.func_228461_a_();
                    RenderSystem.enableDepthTest();
                }
                renderBuffer.func_228462_a_(RenderUtils.LINES_GLINT);
            }
        }
        renderBuffer.func_228461_a_();
        OptifineCompat.getInstance().postBlueprintDraw();
        Settings.instance.endStructurizePass();
        Vector3d viewPosition = Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216785_c();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(-viewPosition.func_82615_a(), -viewPosition.func_82617_b(), -viewPosition.func_82616_c());
        HookRegistries.render(matrixStack, partialTicks);
        matrixStack.func_227865_b_();
    }

    private static void renderAnchorPos(BlockPos anchorPos, MatrixStack ms, IVertexBuilder buffer) {
        RenderUtils.renderBox(anchorPos, anchorPos, 1.0f, 0.0f, 0.0f, 1.0f, 0.0, ms, buffer);
    }

    @SubscribeEvent
    public static void onClientTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Minecraft.func_71410_x().func_213239_aq().func_76320_a("structurize");
        if (Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_71441_e.func_82737_E() % 100L == 0L) {
            Minecraft.func_71410_x().func_213239_aq().func_76320_a("blueprint_manager_tick");
            BlueprintHandler.getInstance().cleanCache();
            Minecraft.func_71410_x().func_213239_aq().func_76319_b();
        }
        if (Minecraft.func_71410_x().field_71441_e != null) {
            Minecraft.func_71410_x().func_213239_aq().func_76320_a("hook_manager_tick");
            HookRegistries.tick(Minecraft.func_71410_x().field_71441_e.func_82737_E());
            Minecraft.func_71410_x().func_213239_aq().func_76319_b();
        }
        Minecraft.func_71410_x().func_213239_aq().func_76319_b();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onMouseScrollEvent(InputEvent.MouseScrollEvent event) {
        event.setCanceled(HookManager.onScroll(event.getScrollDelta()));
    }
}

