/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.client.gui;

import com.ldtteam.blockout.Log;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.ButtonImage;
import com.ldtteam.blockout.controls.Image;
import com.ldtteam.blockout.views.DropDownList;
import com.ldtteam.structures.blueprints.v1.Blueprint;
import com.ldtteam.structures.blueprints.v1.DataFixerUtils;
import com.ldtteam.structures.helpers.Settings;
import com.ldtteam.structures.lib.BlueprintTagUtils;
import com.ldtteam.structurize.Network;
import com.ldtteam.structurize.Structurize;
import com.ldtteam.structurize.client.gui.AbstractWindowSkeleton;
import com.ldtteam.structurize.client.gui.DialogDoneCancel;
import com.ldtteam.structurize.client.gui.WindowStructureNameEntry;
import com.ldtteam.structurize.client.gui.WindowUndoRedo;
import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.management.StructureName;
import com.ldtteam.structurize.management.Structures;
import com.ldtteam.structurize.network.messages.BuildToolPasteMessage;
import com.ldtteam.structurize.network.messages.LSStructureDisplayerMessage;
import com.ldtteam.structurize.network.messages.SchematicRequestMessage;
import com.ldtteam.structurize.network.messages.SchematicSaveMessage;
import com.ldtteam.structurize.placement.structure.CreativeStructureHandler;
import com.ldtteam.structurize.util.BlockUtils;
import com.ldtteam.structurize.util.LanguageHandler;
import com.ldtteam.structurize.util.PlacementSettings;
import com.ldtteam.structurize.util.StructureLoadingUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WindowBuildTool
extends AbstractWindowSkeleton {
    private static final String RES_STRING = "textures/gui/buildtool/%s.png";
    private static final String GREEN_POS = "_green";
    private static final int POSSIBLE_ROTATIONS = 4;
    private static final int ROTATE_RIGHT = 1;
    private static final int ROTATE_180 = 2;
    private static final int ROTATE_LEFT = 3;
    private static final String IMAGE_ROTATION = "rotation";
    private static final String BUTTON_PASTE = "pastecomplete";
    private static final String BUTTON_PASTE_NICE = "pastenice";
    private static final String BUTTON_SHOW_INVIS = "showinvis";
    private static final String LABEL_WARNING = "warning";
    @NotNull
    private final List<String> sections = new ArrayList<String>();
    @NotNull
    private List<String> styles = new ArrayList<String>();
    @NotNull
    private List<String> schematics = new ArrayList<String>();
    @NotNull
    private BlockPos pos = new BlockPos(0, 0, 0);
    private int rotation = 0;
    private int groundstyle;
    private DropDownList sectionsDropDownList;
    private DropDownList stylesDropDownList;
    private DropDownList schematicsDropDownList;
    private Button renameButton;
    private Button deleteButton;
    private DialogDoneCancel confirmDeleteDialog;
    private boolean init = true;

    public WindowBuildTool(@Nullable BlockPos pos, String folder, int rotation, int groundstyle) {
        super("structurize:gui/windowbuildtool.xml");
        if (!this.hasPermission()) {
            return;
        }
        if (pos != null) {
            Settings.instance.setupStaticMode(folder);
            this.rotation = rotation;
        }
        this.init(pos, rotation, groundstyle);
    }

    public WindowBuildTool(@Nullable BlockPos pos, int groundstyle) {
        super("structurize:gui/windowbuildtool.xml");
        if (!this.hasPermission()) {
            return;
        }
        this.init(pos, 0, groundstyle);
    }

    private void init(BlockPos pos, int rot, int groundstyle) {
        @Nullable Blueprint structure = Settings.instance.getActiveStructure();
        this.groundstyle = groundstyle;
        if (structure != null) {
            this.rotation = Settings.instance.getRotation();
        } else if (pos != null) {
            this.pos = pos;
            Settings.instance.setPosition(pos);
            Settings.instance.setRotation(rot);
        }
        this.initBuildingTypeNavigation();
        this.initStyleNavigation();
        this.initSchematicNavigation();
        this.registerButton("confirm", this::confirmClicked);
        this.registerButton("cancel", this::cancelClicked);
        this.registerButton("left", this::moveLeftClicked);
        this.registerButton("mirror", this::mirror);
        this.registerButton("right", this::moveRightClicked);
        this.registerButton("down", this::moveBackClicked);
        this.registerButton("up", this::moveForwardClicked);
        this.registerButton("plus", WindowBuildTool::moveUpClicked);
        this.registerButton("minus", WindowBuildTool::moveDownClicked);
        this.registerButton("rotateRight", this::rotateRightClicked);
        this.registerButton("rotateLeft", this::rotateLeftClicked);
        this.registerButton(BUTTON_PASTE, this::pasteComplete);
        this.registerButton(BUTTON_PASTE_NICE, this::pasteNice);
        this.registerButton(BUTTON_SHOW_INVIS, this::showInvis);
        this.registerButton("rename", this::renameClicked);
        this.registerButton("delete", this::deleteClicked);
        this.registerButton("undoredo", (Button b) -> {
            this.close();
            new WindowUndoRedo().open();
        });
        this.renameButton = this.findPaneOfTypeByID("rename", Button.class);
        this.deleteButton = this.findPaneOfTypeByID("delete", Button.class);
        Structures.loadScannedStyleMaps();
        if (Settings.instance.isStaticSchematicMode()) {
            this.sections.clear();
            this.sections.add("schematics");
            this.setStructureName(Settings.instance.getStructureName());
        } else {
            this.sections.clear();
            PlayerInventory inventory = this.mc.field_71439_g.field_71071_by;
            List<String> allSections = Structures.getSections();
            for (String section : allSections) {
                if (!section.equals("schematics") && !section.equals("scans") && !this.hasMatchingBlock(inventory, section)) continue;
                this.sections.add(section);
            }
            if (Minecraft.func_71410_x().field_71439_g.func_184812_l_()) {
                this.findPaneOfTypeByID(BUTTON_PASTE, Button.class).setVisible(true);
                this.findPaneOfTypeByID(BUTTON_PASTE_NICE, Button.class).setVisible(true);
            } else {
                this.findPaneOfTypeByID(BUTTON_PASTE, Button.class).setVisible(false);
                this.findPaneOfTypeByID("undoredo", Button.class).setVisible(false);
                this.findPaneOfTypeByID(BUTTON_PASTE_NICE, Button.class).setVisible(false);
            }
            this.setStructureName(Settings.instance.getStructureName());
        }
        if (Manager.isSchematicDownloaded()) {
            Manager.setSchematicDownloaded(false);
        }
        if (!DataFixerUtils.isVanillaDF) {
            this.findPaneByID(LABEL_WARNING).show();
        }
        this.updateRotationState();
        this.init = false;
        this.changeSchematic();
    }

    private void showInvis() {
        Settings.instance.toggleLightPlaceholderRendering();
    }

    public void pasteNice() {
        this.paste(false);
    }

    private void pasteComplete() {
        this.paste(true);
    }

    private void paste(boolean complete) {
        String sname = Settings.instance.isStaticSchematicMode() ? this.schematics.get(this.schematicsDropDownList.getSelectedIndex()) : this.schematics.get(this.schematicsDropDownList.getSelectedIndex());
        StructureName structureName = new StructureName(sname);
        if (structureName.getPrefix().equals("scans") && ServerLifecycleHooks.getCurrentServer() == null) {
            this.requestAndPlaceScannedSchematic(structureName, true, complete);
        } else {
            this.paste(structureName, complete);
        }
        Settings.instance.softReset();
        this.close();
    }

    public String getSectionName(String name) {
        return name;
    }

    private void initBuildingTypeNavigation() {
        this.registerButton("previousBuildingType", this::previousSection);
        this.registerButton("nextBuildingType", this::nextSection);
        this.sectionsDropDownList = this.findPaneOfTypeByID("buildingType", DropDownList.class);
        this.sectionsDropDownList.setHandler(this::onDropDownListChanged);
        this.sectionsDropDownList.setDataProvider(new SectionDropDownList());
    }

    private void initStyleNavigation() {
        this.registerButton("previousStyle", this::previousStyle);
        this.registerButton("nextStyle", this::nextStyle);
        this.stylesDropDownList = this.findPaneOfTypeByID("style", DropDownList.class);
        this.stylesDropDownList.setHandler(this::onDropDownListChanged);
        this.stylesDropDownList.setDataProvider(new DropDownList.DataProvider(){

            @Override
            public int getElementCount() {
                return WindowBuildTool.this.styles.size();
            }

            @Override
            public String getLabel(int index) {
                if (index >= 0 && index < WindowBuildTool.this.styles.size()) {
                    return (String)WindowBuildTool.this.styles.get(index);
                }
                return "";
            }
        });
    }

    private void initSchematicNavigation() {
        this.registerButton("previousSchematic", this::previousSchematic);
        this.registerButton("nextSchematic", this::nextSchematic);
        this.schematicsDropDownList = this.findPaneOfTypeByID("schematic", DropDownList.class);
        this.schematicsDropDownList.setHandler(this::onDropDownListChanged);
        this.schematicsDropDownList.setDataProvider(new DropDownList.DataProvider(){

            @Override
            public int getElementCount() {
                return WindowBuildTool.this.schematics.size();
            }

            @Override
            public String getLabel(int index) {
                StructureName sn = new StructureName((String)WindowBuildTool.this.schematics.get(index));
                return sn.getLocalizedName();
            }
        });
    }

    private void mirror() {
        Settings.instance.mirror();
        this.updateRotationState();
    }

    @Override
    public void onOpened() {
        super.onOpened();
        if (!this.hasPermission()) {
            this.close();
        }
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (Manager.isSchematicDownloaded()) {
            Manager.setSchematicDownloaded(false);
            this.changeSchematic();
        }
    }

    @Override
    public void onClosed() {
        if (Settings.instance.getActiveStructure() != null) {
            Settings.instance.setSchematicInfo(this.schematics.get(this.schematicsDropDownList.getSelectedIndex()), this.rotation);
            if (!Settings.instance.hasReceivedInfo()) {
                Settings.instance.setReceivedInfo();
                LanguageHandler.sendPlayerMessage((PlayerEntity)Minecraft.func_71410_x().field_71439_g, "com.structurize.gui.buildtool.leave.tip", new Object[0]);
            }
            Network.getNetwork().sendToServer(new LSStructureDisplayerMessage(Settings.instance.serializeNBT(), true));
        }
    }

    private void nextSection() {
        this.sectionsDropDownList.selectNext();
    }

    private void previousSection() {
        this.sectionsDropDownList.selectPrevious();
    }

    private void nextStyle() {
        this.stylesDropDownList.selectNext();
    }

    private void previousStyle() {
        this.stylesDropDownList.selectPrevious();
    }

    private void updateStyles() {
        int newIndex;
        String currentStyle = "";
        if (this.stylesDropDownList.getSelectedIndex() > -1 && this.stylesDropDownList.getSelectedIndex() < this.styles.size()) {
            currentStyle = this.styles.get(this.stylesDropDownList.getSelectedIndex());
            Settings.instance.setStyle(currentStyle);
        }
        if (Settings.instance.isStaticSchematicMode()) {
            this.styles = new ArrayList<String>();
            this.styles.add(Settings.instance.getStaticSchematicName());
        } else {
            this.styles = Structures.getStylesFor(this.sections.get(this.sectionsDropDownList.getSelectedIndex()));
        }
        if (currentStyle.isEmpty()) {
            currentStyle = Settings.instance.getStyle();
        }
        if ((newIndex = this.styles.indexOf(currentStyle)) == -1) {
            newIndex = 0;
        }
        boolean enabled = Settings.instance.isStaticSchematicMode() ? false : this.styles.size() > 1;
        this.findPaneOfTypeByID("previousStyle", Button.class).setEnabled(enabled);
        this.findPaneOfTypeByID("style", DropDownList.class).setEnabled(enabled);
        this.findPaneOfTypeByID("nextStyle", Button.class).setEnabled(enabled);
        this.stylesDropDownList.setSelectedIndex(newIndex);
    }

    private void nextSchematic() {
        this.schematicsDropDownList.selectNext();
    }

    private void previousSchematic() {
        this.schematicsDropDownList.selectPrevious();
    }

    private void updateSchematics() {
        String schematic = "";
        if (this.schematicsDropDownList.getSelectedIndex() > -1 && this.schematicsDropDownList.getSelectedIndex() < this.schematics.size()) {
            schematic = this.schematics.get(this.schematicsDropDownList.getSelectedIndex());
        }
        String currentSchematic = schematic.isEmpty() ? "" : new StructureName(schematic).getSchematic();
        String section = this.sections.get(this.sectionsDropDownList.getSelectedIndex());
        String style = this.styles.get(this.stylesDropDownList.getSelectedIndex());
        this.schematics = Structures.getSchematicsFor(section, style);
        int newIndex = -1;
        for (int i = 0; i < this.schematics.size(); ++i) {
            StructureName sn = new StructureName(this.schematics.get(i));
            if (!sn.getSchematic().equals(currentSchematic)) continue;
            newIndex = i;
            break;
        }
        if (newIndex == -1) {
            newIndex = 0;
        }
        boolean enabled = this.schematics.size() > 1;
        this.findPaneOfTypeByID("previousSchematic", Button.class).setEnabled(enabled);
        this.findPaneOfTypeByID("schematic", DropDownList.class).setEnabled(enabled);
        this.findPaneOfTypeByID("nextSchematic", Button.class).setEnabled(enabled);
        this.schematicsDropDownList.setSelectedIndex(newIndex);
    }

    private void onDropDownListChanged(DropDownList list) {
        if (list == this.sectionsDropDownList) {
            String name = this.sections.get(this.sectionsDropDownList.getSelectedIndex());
            if ("scans".equals(name)) {
                this.renameButton.setVisible(true);
                this.deleteButton.setVisible(true);
            } else {
                this.renameButton.setVisible(false);
                this.deleteButton.setVisible(false);
            }
            this.updateStyles();
        } else if (list == this.stylesDropDownList) {
            this.updateSchematics();
        } else if (list == this.schematicsDropDownList) {
            this.changeSchematic();
        }
    }

    private void setStructureName(String structureName) {
        if (structureName != null) {
            StructureName sn = new StructureName(structureName);
            int sectionIndex = this.sections.indexOf(sn.getSection());
            if (sectionIndex != -1) {
                this.sectionsDropDownList.setSelectedIndex(sectionIndex);
                int styleIndex = this.styles.indexOf(sn.getStyle());
                if (styleIndex != -1) {
                    this.stylesDropDownList.setSelectedIndex(styleIndex);
                    int schematicIndex = this.schematics.indexOf(sn.toString());
                    if (schematicIndex != -1) {
                        this.schematicsDropDownList.setSelectedIndex(schematicIndex);
                    } else {
                        this.schematicsDropDownList.setSelectedIndex(0);
                    }
                } else {
                    this.stylesDropDownList.setSelectedIndex(0);
                }
            } else {
                this.sectionsDropDownList.setSelectedIndex(0);
            }
        } else {
            this.sectionsDropDownList.setSelectedIndex(0);
            int styleIndex = this.styles.indexOf(Settings.instance.getStyle());
            if (styleIndex != -1) {
                this.stylesDropDownList.setSelectedIndex(styleIndex);
            }
        }
    }

    public boolean hasMatchingBlock(@NotNull PlayerInventory inventory, String hut) {
        return true;
    }

    private static void moveUpClicked() {
        Settings.instance.moveTo(new BlockPos(0, 1, 0));
    }

    private static void moveDownClicked() {
        Settings.instance.moveTo(new BlockPos(0, -1, 0));
    }

    private void moveLeftClicked() {
        Settings.instance.moveTo(new BlockPos(0, 0, 0).func_177972_a(this.mc.field_71439_g.func_174811_aO().func_176735_f()));
    }

    private void moveRightClicked() {
        Settings.instance.moveTo(new BlockPos(0, 0, 0).func_177972_a(this.mc.field_71439_g.func_174811_aO().func_176746_e()));
    }

    private void moveForwardClicked() {
        Settings.instance.moveTo(new BlockPos(0, 0, 0).func_177972_a(this.mc.field_71439_g.func_174811_aO()));
    }

    private void moveBackClicked() {
        Settings.instance.moveTo(new BlockPos(0, 0, 0).func_177972_a(this.mc.field_71439_g.func_174811_aO().func_176734_d()));
    }

    private void rotateRightClicked() {
        this.rotation = (this.rotation + 1) % 4;
        WindowBuildTool.updateRotation(this.rotation);
        this.updateRotationState();
    }

    private void rotateLeftClicked() {
        this.rotation = (this.rotation + 3) % 4;
        WindowBuildTool.updateRotation(this.rotation);
        this.updateRotationState();
    }

    private void updateRotationState() {
        String rotation;
        this.findPaneOfTypeByID("mirror", ButtonImage.class).setImage(new ResourceLocation("structurize", String.format(RES_STRING, "mirror" + (Settings.instance.getMirror().equals((Object)Mirror.NONE) ? "" : GREEN_POS))));
        switch (Settings.instance.getRotation()) {
            case 1: {
                rotation = "right_green";
                break;
            }
            case 2: {
                rotation = "down_green";
                break;
            }
            case 3: {
                rotation = "left_green";
                break;
            }
            default: {
                rotation = "up_green";
            }
        }
        this.findPaneOfTypeByID(IMAGE_ROTATION, Image.class).setImage(new ResourceLocation("structurize", String.format(RES_STRING, rotation)));
    }

    private void changeSchematic() {
        if (this.init) {
            return;
        }
        if (this.schematics.get(this.schematicsDropDownList.getSelectedIndex()).equals(Settings.instance.getStructureName()) && Settings.instance.getActiveStructure() != null) {
            return;
        }
        Settings.instance.setStructureName(this.schematics.get(this.schematicsDropDownList.getSelectedIndex()));
        WindowBuildTool.commonStructureUpdate();
        if (Settings.instance.getPosition() == null) {
            Settings.instance.setPosition(this.pos);
        }
        this.adjustToGroundOffset();
    }

    private void adjustToGroundOffset() {
        Blueprint blueprint = Settings.instance.getActiveStructure();
        if (blueprint != null) {
            int groundOffset;
            switch (this.groundstyle) {
                case 2: {
                    groundOffset = BlueprintTagUtils.getGroundAnchorOffsetFromGroundLevels(blueprint, BlueprintTagUtils.getNumberOfGroundLevels(blueprint, 1));
                    break;
                }
                case 3: {
                    groundOffset = BlueprintTagUtils.getGroundAnchorOffsetFromGroundLevels(blueprint, BlueprintTagUtils.getNumberOfGroundLevels(blueprint, 3));
                    break;
                }
                default: {
                    groundOffset = BlueprintTagUtils.getGroundAnchorOffset(blueprint, 1);
                }
            }
            Settings.instance.setGroundOffset(--groundOffset);
        }
    }

    public static void commonStructureUpdate() {
        String sname = Settings.instance.getStructureName();
        if (sname == null) {
            return;
        }
        StructureName structureName = new StructureName(sname);
        String md5 = Structures.getMD5(structureName.toString());
        CreativeStructureHandler structure = new CreativeStructureHandler((World)Minecraft.func_71410_x().field_71441_e, new BlockPos(0, 0, 0), structureName.toString(), new PlacementSettings(Settings.instance.getMirror(), BlockUtils.getRotation(Settings.instance.getRotation())), true);
        if (!structure.hasBluePrint() || !structure.isCorrectMD5(md5)) {
            if (!structure.hasBluePrint()) {
                Log.getLogger().info("Blueprint structure " + structureName + " missing");
            } else {
                Log.getLogger().info("structure " + structureName + " md5 error");
            }
            Log.getLogger().info("Request To Server for structure " + structureName);
            if (ServerLifecycleHooks.getCurrentServer() == null) {
                Network.getNetwork().sendToServer(new SchematicRequestMessage(structureName.toString()));
                Settings.instance.resetBlueprint();
                Settings.instance.setStructureName(structureName.toString());
                return;
            }
            Log.getLogger().error("WindowBuildTool: Need to download schematic on a standalone client/server. This should never happen");
        }
        Settings.instance.setStructureName(structureName.toString());
        Settings.instance.setActiveSchematic(structure.getBluePrint());
    }

    public void requestAndPlaceScannedSchematic(@NotNull StructureName structureName, boolean paste, boolean complete) {
        if (!((Boolean)Structurize.getConfig().getServer().allowPlayerSchematics.get()).booleanValue()) {
            return;
        }
        if (Structures.hasMD5(structureName)) {
            String md5 = Structures.getMD5(structureName.toString());
            String serverSideName = "cache/" + md5;
            if (!Structures.hasMD5(new StructureName(serverSideName))) {
                byte[] structureAsByteArray = StructureLoadingUtils.getByteArray(structureName.toString());
                if (structureAsByteArray.length > 0) {
                    UUID id = UUID.randomUUID();
                    if (structureAsByteArray.length <= 30000) {
                        Network.getNetwork().sendToServer(new SchematicSaveMessage(structureAsByteArray, id, 1, 1));
                    } else {
                        int pieces = structureAsByteArray.length / 30000;
                        Log.getLogger().info("BuilderTool: sending: " + pieces + " pieces with the schematic " + structureName + "(md5:" + md5 + ") to the server");
                        for (int i = 1; i <= pieces; ++i) {
                            int start = (i - 1) * 30000;
                            int size = i == pieces ? structureAsByteArray.length - start : 30000;
                            byte[] bytes = Arrays.copyOfRange(structureAsByteArray, start, size);
                            Network.getNetwork().sendToServer(new SchematicSaveMessage(bytes, id, pieces, i));
                        }
                    }
                } else {
                    Log.getLogger().warn("BuildTool: Can not load " + structureName);
                }
            } else {
                Log.getLogger().warn("BuildTool: server does not have " + serverSideName);
            }
            if (paste || this.pasteDirectly()) {
                Network.getNetwork().sendToServer(new BuildToolPasteMessage(serverSideName, structureName.toString(), Settings.instance.getPosition(), BlockUtils.getRotation(Settings.instance.getRotation()), false, Settings.instance.getMirror(), complete));
            } else {
                this.place(new StructureName(serverSideName));
            }
        } else {
            if (this.pasteDirectly()) {
                this.paste(structureName, complete);
            } else {
                this.place(structureName);
            }
            Log.getLogger().warn("BuilderTool: Can not send schematic without md5: " + structureName);
        }
    }

    public static void requestScannedSchematic(@NotNull StructureName structureName) {
        if (!((Boolean)Structurize.getConfig().getServer().allowPlayerSchematics.get()).booleanValue()) {
            return;
        }
        if (Structures.hasMD5(structureName)) {
            String md5 = Structures.getMD5(structureName.toString());
            String serverSideName = "cache/" + md5;
            if (!Structures.hasMD5(new StructureName(serverSideName))) {
                byte[] structureAsByteArray = StructureLoadingUtils.getByteArray(structureName.toString());
                if (structureAsByteArray.length > 0) {
                    UUID id = UUID.randomUUID();
                    if (structureAsByteArray.length <= 30000) {
                        Network.getNetwork().sendToServer(new SchematicSaveMessage(structureAsByteArray, id, 1, 1));
                    } else {
                        int pieces = structureAsByteArray.length / 30000;
                        Log.getLogger().info("BuilderTool: sending: " + pieces + " pieces with the schematic " + structureName + "(md5:" + md5 + ") to the server");
                        for (int i = 1; i <= pieces; ++i) {
                            int start = (i - 1) * 30000;
                            int size = i == pieces ? structureAsByteArray.length - start : 30000;
                            byte[] bytes = Arrays.copyOfRange(structureAsByteArray, start, size);
                            Network.getNetwork().sendToServer(new SchematicSaveMessage(bytes, id, pieces, i));
                        }
                    }
                } else {
                    Log.getLogger().warn("BuilderTool: Can not load " + structureName);
                }
            } else {
                Log.getLogger().warn("BuilderTool: server does not have " + serverSideName);
            }
        } else {
            Log.getLogger().warn("BuilderTool: Can not send schematic without md5: " + structureName);
        }
    }

    public void place(StructureName structureName) {
    }

    public void checkAndPlace() {
    }

    public boolean hasPermission() {
        boolean result = Minecraft.func_71410_x().field_71439_g.func_184812_l_();
        if (!result) {
            LanguageHandler.sendMessageToPlayer((PlayerEntity)Minecraft.func_71410_x().field_71439_g, "structurize.gui.buildtool.creative_only", new Object[0]);
        }
        return result;
    }

    public boolean pasteDirectly() {
        return true;
    }

    public void paste(StructureName name, boolean complete) {
        Network.getNetwork().sendToServer(new BuildToolPasteMessage(name.toString(), name.toString(), Settings.instance.getPosition(), BlockUtils.getRotation(Settings.instance.getRotation()), false, Settings.instance.getMirror(), complete));
    }

    private void confirmClicked() {
        if (Settings.instance.isStaticSchematicMode() && Settings.instance.getActiveStructure() != null) {
            this.checkAndPlace();
        } else {
            StructureName structureName = new StructureName(this.schematics.get(this.schematicsDropDownList.getSelectedIndex()));
            if (structureName.getPrefix().equals("scans") && ServerLifecycleHooks.getCurrentServer() == null) {
                this.requestAndPlaceScannedSchematic(structureName, false, false);
            } else if (this.pasteDirectly()) {
                this.paste(structureName, false);
            } else {
                this.place(structureName);
            }
            if (!Screen.func_231173_s_()) {
                this.cancelClicked();
            }
        }
    }

    public void cancelClicked() {
        Settings.instance.softReset();
        Network.getNetwork().sendToServer(new LSStructureDisplayerMessage(null, false));
        this.close();
    }

    private static void updateRotation(int rotation) {
        PlacementSettings settings = new PlacementSettings();
        switch (rotation) {
            case 1: {
                settings.setRotation(Rotation.CLOCKWISE_90);
                break;
            }
            case 2: {
                settings.setRotation(Rotation.CLOCKWISE_180);
                break;
            }
            case 3: {
                settings.setRotation(Rotation.COUNTERCLOCKWISE_90);
                break;
            }
            default: {
                settings.setRotation(Rotation.NONE);
            }
        }
        Settings.instance.setRotation(rotation);
        settings.setMirror(Settings.instance.getMirror());
    }

    private void renameClicked() {
        StructureName structureName = new StructureName(this.schematics.get(this.schematicsDropDownList.getSelectedIndex()));
        @NotNull WindowStructureNameEntry window = new WindowStructureNameEntry(structureName);
        window.open();
    }

    private void deleteClicked() {
        this.confirmDeleteDialog = new DialogDoneCancel(this.getWindow());
        this.confirmDeleteDialog.setHandler(this::onDialogClosed);
        StructureName structureName = new StructureName(this.schematics.get(this.schematicsDropDownList.getSelectedIndex()));
        this.confirmDeleteDialog.setTitle(LanguageHandler.format("com.ldtteam.gui.structure.delete.title", new Object[0]));
        this.confirmDeleteDialog.setTextContent(LanguageHandler.format("com.ldtteam.gui.structure.delete.body", structureName.toString()));
        this.confirmDeleteDialog.open();
    }

    public void onDialogClosed(DialogDoneCancel dialog, int buttonId) {
        StructureName structureName;
        if (dialog == this.confirmDeleteDialog && buttonId == 1 && "scans".equals((structureName = new StructureName(this.schematics.get(this.schematicsDropDownList.getSelectedIndex()))).getPrefix()) && Structures.deleteScannedStructure(structureName)) {
            Structures.loadScannedStyleMaps();
            if (this.schematics.size() > 1) {
                this.schematicsDropDownList.selectNext();
                this.stylesDropDownList.setSelectedIndex(this.stylesDropDownList.getSelectedIndex());
            } else if (this.styles.size() > 1) {
                this.stylesDropDownList.selectNext();
            } else {
                this.sectionsDropDownList.selectNext();
            }
        }
    }

    private class SectionDropDownList
    implements DropDownList.DataProvider {
        private SectionDropDownList() {
        }

        @Override
        public int getElementCount() {
            return WindowBuildTool.this.sections.size();
        }

        @Override
        public String getLabel(int index) {
            String name = (String)WindowBuildTool.this.sections.get(index);
            if ("scans".equals(name)) {
                return LanguageHandler.translateKey("com.ldtteam.structurize.gui.buildtool.scans");
            }
            if ("schematics".equals(name)) {
                return LanguageHandler.translateKey("com.ldtteam.structurize.gui.buildtool.decorations");
            }
            return WindowBuildTool.this.getSectionName(name);
        }
    }
}

