/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.api.generation;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.StairsBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.state.Property;
import net.minecraft.state.properties.Half;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.IGeneratedBlockstate;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ModBlockStateProvider
extends BlockStateProvider {
    private static ModBlockStateProvider instance;
    private Map<ResourceLocation, BlockModelBuilder> blocks;
    private Map<ResourceLocation, ItemModelBuilder> items;
    private Map<Block, IGeneratedBlockstate> states;

    public ModBlockStateProvider(DataGenerator gen, String modid, ExistingFileHelper exFileHelper) {
        super(gen, modid, exFileHelper);
        this.blocks = this.models().generatedModels;
        this.items = this.itemModels().generatedModels;
        this.states = this.registeredBlocks;
        instance = this;
    }

    protected void registerStatesAndModels() {
        this.models().generatedModels.putAll(this.blocks);
        this.itemModels().generatedModels.putAll(this.items);
        this.registeredBlocks.putAll(this.states);
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        this.blocks = new HashMap<ResourceLocation, BlockModelBuilder>(this.models().generatedModels);
        this.items = new HashMap<ResourceLocation, ItemModelBuilder>(this.itemModels().generatedModels);
        this.states = new LinkedHashMap<Block, IGeneratedBlockstate>(this.registeredBlocks);
        super.func_200398_a(cache);
    }

    public ResourceLocation findTexture(String directory, String model, Block ... blocks) {
        ResourceLocation name = new ResourceLocation("");
        for (Block block : blocks) {
            if (block.getRegistryName() == null) continue;
            name = block.getRegistryName();
            if (!model.isEmpty() && this.models().existingFileHelper.exists(name, ResourcePackType.CLIENT_RESOURCES, "_" + model + ".png", "textures/" + directory)) {
                return new ResourceLocation(name.func_110624_b(), directory + "/" + name.func_110623_a() + "_" + model);
            }
            if (!this.models().existingFileHelper.exists(name, ResourcePackType.CLIENT_RESOURCES, (model.isEmpty() ? "" : "_" + model) + ".png", "textures/" + directory)) continue;
            return new ResourceLocation(name.func_110624_b(), directory + "/" + name.func_110623_a());
        }
        return new ResourceLocation(name.func_110624_b(), directory + "/" + name.func_110623_a());
    }

    public void stairsBlockUnlockUV(StairsBlock block, ModelFile stairs, ModelFile stairsInner, ModelFile stairsOuter) {
        this.getVariantBuilder((Block)block).forAllStatesExcept(state -> {
            Direction facing = (Direction)state.func_177229_b((Property)StairsBlock.field_176309_a);
            Half half = (Half)state.func_177229_b((Property)StairsBlock.field_176308_b);
            StairsShape shape = (StairsShape)state.func_177229_b((Property)StairsBlock.field_176310_M);
            int yRot = (int)facing.func_176746_e().func_185119_l();
            if (shape == StairsShape.INNER_LEFT || shape == StairsShape.OUTER_LEFT) {
                yRot += 270;
            }
            if (shape != StairsShape.STRAIGHT && half == Half.TOP) {
                yRot += 90;
            }
            return ConfiguredModel.builder().modelFile(shape == StairsShape.STRAIGHT ? stairs : (shape == StairsShape.INNER_LEFT || shape == StairsShape.INNER_RIGHT ? stairsInner : stairsOuter)).rotationX(half == Half.BOTTOM ? 0 : 180).rotationY(yRot %= 360).uvLock(false).build();
        }, new Property[]{StairsBlock.field_204513_t});
    }

    public static ModBlockStateProvider getInstance() {
        return instance;
    }
}

