/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.api.blocks;

import com.ldtteam.structurize.api.blocks.BlockType;
import com.ldtteam.structurize.api.blocks.IGenerated;
import com.ldtteam.structurize.api.generation.ModBlockStateProvider;
import com.ldtteam.structurize.api.generation.ModBlockTagsProvider;
import com.ldtteam.structurize.api.generation.ModItemModelProvider;
import com.ldtteam.structurize.api.generation.ModItemTagsProvider;
import com.ldtteam.structurize.api.generation.ModLanguageProvider;
import com.ldtteam.structurize.api.generation.ModRecipeProvider;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;

public interface IBlockCollection
extends IGenerated {
    public String getName();

    default public String getPluralName() {
        return this.getName() + "s";
    }

    public List<RegistryObject<Block>> getRegisteredBlocks();

    default public Block getMainBlock() {
        return (Block)this.getMainRegisteredBlock().get();
    }

    default public RegistryObject<Block> getMainRegisteredBlock() {
        return this.getRegisteredBlocks().get(0);
    }

    default public AbstractBlock.Properties getProperties() {
        return AbstractBlock.Properties.func_200949_a((Material)Material.field_151575_d, (MaterialColor)MaterialColor.field_151663_o).func_200948_a(2.0f, 3.0f).func_200947_a(SoundType.field_185848_a);
    }

    default public List<RegistryObject<Block>> create(DeferredRegister<Block> registrar, DeferredRegister<Item> itemRegistrar, final ItemGroup group, BiConsumer<BlockType, RegistryObject<Block>> creationListener, BlockType ... types) {
        LinkedList<RegistryObject<Block>> results = new LinkedList<RegistryObject<Block>>();
        for (final BlockType type : types) {
            final RegistryObject block = registrar.register(type.withSuffix(this.getName(), this.getPluralName()), (Supplier)new Supplier<Block>(){

                @Override
                public Block get() {
                    return type.constructor.apply(IBlockCollection.this.getProperties());
                }
            });
            itemRegistrar.register(type.withSuffix(this.getName(), this.getPluralName()), (Supplier)new Supplier<Item>(){

                @Override
                public Item get() {
                    return new BlockItem((Block)block.get(), new Item.Properties().func_200916_a(group));
                }
            });
            creationListener.accept(type, (RegistryObject<Block>)block);
            results.add((RegistryObject<Block>)block);
        }
        return results;
    }

    public void provideMainRecipe(Consumer<IFinishedRecipe> var1, ICriterionInstance var2);

    default public ResourceLocation findTexture(Block block, String model) {
        return ModBlockStateProvider.getInstance().findTexture(this.getTextureDirectory(), model, block, this.getMainBlock());
    }

    default public ResourceLocation findTexture(Block block) {
        return this.findTexture(block, "");
    }

    @Override
    default public void generateBlockStates(ModBlockStateProvider states) {
        for (RegistryObject<Block> ro : this.getRegisteredBlocks()) {
            Block block = (Block)ro.get();
            ResourceLocation name = block.getRegistryName();
            if (name == null) {
                return;
            }
            switch (BlockType.fromSuffix(block)) {
                case STAIRS: {
                    states.stairsBlock((StairsBlock)block, this.findTexture(block, "side"), this.findTexture(block, "bottom"), this.findTexture(block, "top"));
                    break;
                }
                case WALL: {
                    states.wallBlock((WallBlock)block, this.findTexture(block));
                    break;
                }
                case FENCE: {
                    states.fenceBlock((FenceBlock)block, this.findTexture(block));
                    break;
                }
                case FENCE_GATE: {
                    states.fenceGateBlock((FenceGateBlock)block, this.findTexture(block));
                    break;
                }
                case SLAB: {
                    ResourceLocation side = this.findTexture(block, "side");
                    ResourceLocation bottom = this.findTexture(block, "bottom");
                    ResourceLocation top = this.findTexture(block, "top");
                    states.slabBlock((SlabBlock)block, (ModelFile)states.models().slab(name.func_110623_a(), side, bottom, top), (ModelFile)states.models().slabTop(name.func_110623_a() + "_top", side, bottom, top), (ModelFile)states.models().cubeBottomTop(name.func_110623_a() + "_double", side, bottom, top));
                    break;
                }
                case PLANKS: 
                case BLOCK: {
                    states.simpleBlock(block, (ModelFile)states.models().cubeAll(block.getRegistryName().func_110623_a(), this.findTexture(block)));
                    break;
                }
                case TRAPDOOR: {
                    states.trapdoorBlock((TrapDoorBlock)block, this.findTexture(block), false);
                    break;
                }
                case DOOR: {
                    states.doorBlock((DoorBlock)block, this.findTexture(block, "lower"), this.findTexture(block, "upper"));
                }
            }
        }
    }

    @Override
    default public void generateItemModels(ModItemModelProvider models) {
        for (RegistryObject<Block> ro : this.getRegisteredBlocks()) {
            Block block = (Block)ro.get();
            if (block.getRegistryName() == null) continue;
            String name = block.getRegistryName().func_110623_a();
            switch (BlockType.fromSuffix(block)) {
                case SLAB: {
                    models.slab(name, this.findTexture(block, "side"), this.findTexture(block, "bottom"), this.findTexture(block, "top"));
                    break;
                }
                case STAIRS: {
                    models.stairs(name, this.findTexture(block, "side"), this.findTexture(block, "bottom"), this.findTexture(block, "top"));
                    break;
                }
                case WALL: {
                    models.wallInventory(name, this.findTexture(block));
                    break;
                }
                case FENCE: {
                    models.fenceInventory(name, this.findTexture(block));
                    break;
                }
                case FENCE_GATE: {
                    models.fenceGate(name, this.findTexture(block));
                    break;
                }
                case PLANKS: 
                case BLOCK: {
                    models.withUncheckedParent(name, "block/" + name);
                    break;
                }
                case TRAPDOOR: {
                    models.withUncheckedParent(name, "block/" + name + "_bottom");
                    break;
                }
                case DOOR: {
                    models.singleTexture(name, models.mcLoc("item/generated"), "layer0", models.modLoc("items/" + name));
                }
            }
        }
    }

    @Override
    default public void generateRecipes(ModRecipeProvider provider) {
        this.getRegisteredBlocks().forEach(ro -> provider.add(consumer -> {
            if (ro.get() == this.getMainBlock()) {
                this.provideMainRecipe((Consumer<IFinishedRecipe>)consumer, ModRecipeProvider.getDefaultCriterion((IItemProvider)this.getMainBlock()));
                return;
            }
            BlockType.fromSuffix((Block)ro.get()).formRecipe((IItemProvider)ro.get(), (IItemProvider)this.getMainBlock(), ModRecipeProvider.getDefaultCriterion((IItemProvider)this.getMainBlock())).func_200464_a(consumer);
        }));
    }

    @Override
    default public void generateTags(ModBlockTagsProvider blocks, ModItemTagsProvider items) {
        this.getRegisteredBlocks().forEach(ro -> BlockType.fromSuffix((Block)((Block)ro.get())).blockTag.forEach(tag -> ModBlockTagsProvider.getInstance().buildTag((ITag.INamedTag<Block>)tag).func_240532_a_((Object)ro.get())));
    }

    @Override
    default public void generateTranslations(ModLanguageProvider lang) {
        lang.autoTranslate(this.getRegisteredBlocks().stream().map(RegistryObject::get).collect(Collectors.toList()));
    }
}

