/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structures.blueprints.v1;

import com.ldtteam.structures.blueprints.v1.DataVersion;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixerUpper;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraft.util.datafix.TypeReferences;

public class DataFixerUtils {
    public static boolean isVanillaDF = DataFixesManager.func_210901_a() instanceof DataFixerUpper;

    private DataFixerUtils() {
    }

    public static CompoundNBT runDataFixer(CompoundNBT dataIn, DSL.TypeReference dataType, DataVersion startVersion) {
        return DataFixerUtils.runDataFixer(dataIn, dataType, startVersion.getDataVersion(), SharedConstants.func_215069_a().getWorldVersion());
    }

    public static CompoundNBT runDataFixer(CompoundNBT dataIn, DSL.TypeReference dataType, int startVersion) {
        return DataFixerUtils.runDataFixer(dataIn, dataType, startVersion, SharedConstants.func_215069_a().getWorldVersion());
    }

    public static CompoundNBT runDataFixer(CompoundNBT dataIn, DSL.TypeReference dataType, DataVersion startVersion, DataVersion endVersion) {
        return DataFixerUtils.runDataFixer(dataIn, dataType, startVersion.getDataVersion(), endVersion.getDataVersion());
    }

    public static CompoundNBT runDataFixer(CompoundNBT dataIn, DSL.TypeReference dataType, int startVersion, int endVersion) {
        return DataFixerUtils.runDataFixer(dataIn, dataType, startVersion, endVersion, startVersion <= DataVersion.pre1466.getDataVersion() && DataVersion.post1466.getDataVersion() <= endVersion && dataType == TypeReferences.field_211294_j);
    }

    public static CompoundNBT runDataFixer(CompoundNBT dataIn, DSL.TypeReference dataType, int startVersion, int endVersion, boolean debugNonBlockstate) {
        return startVersion == endVersion ? dataIn : (debugNonBlockstate && dataType != TypeReferences.field_211296_l ? DataFixerUtils.runDataFixerCascade(dataIn, dataType, startVersion, endVersion) : (CompoundNBT)DataFixesManager.func_210901_a().update(dataType, new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)dataIn), startVersion, endVersion).getValue());
    }

    public static CompoundNBT runDataFixerCascade(CompoundNBT dataIn, DSL.TypeReference dataType, int startVersion, int endVersion) {
        CompoundNBT fixedNbt = dataIn;
        DataVersion currentVersion = DataVersion.findFromDataVersion(startVersion);
        while (currentVersion.getDataVersion() < endVersion) {
            fixedNbt = (CompoundNBT)DataFixesManager.func_210901_a().update(dataType, new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)fixedNbt), currentVersion.getDataVersion(), currentVersion.getSuccessor().getDataVersion()).getValue();
            if ((currentVersion = currentVersion.getSuccessor()) != DataVersion.pre1466 || dataType != TypeReferences.field_211294_j) continue;
            currentVersion = DataVersion.post1466;
        }
        return fixedNbt;
    }
}

