/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.views;

import com.ldtteam.blockout.Color;
import com.ldtteam.blockout.PaneParams;
import com.ldtteam.blockout.Render;
import com.ldtteam.blockout.views.View;
import com.mojang.blaze3d.matrix.MatrixStack;
import org.jetbrains.annotations.NotNull;

public class Box
extends View {
    private float lineWidth = 1.0f;
    private int color = -16777216;

    public Box() {
    }

    public Box(@NotNull PaneParams params) {
        super(params);
        this.lineWidth = params.getFloat("linewidth", this.lineWidth);
        this.color = params.getColor("color", this.color);
    }

    public void setColor(int red, int green, int blue) {
        this.color = Color.rgbaToInt(red, green, blue, 255);
    }

    public void setLineWidth(float lineWidth) {
        this.lineWidth = lineWidth;
    }

    @Override
    public void drawSelf(MatrixStack ms, double mx, double my) {
        Render.drawOutlineRect(ms, this.x, this.y, this.getWidth(), this.getHeight(), this.color, this.lineWidth);
        super.drawSelf(ms, mx, my);
    }

    @Override
    public void drawSelfLast(MatrixStack ms, double mx, double my) {
        super.drawSelfLast(ms, mx, my);
    }
}

