/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout.controls;

import com.ldtteam.blockout.PaneParams;
import com.ldtteam.blockout.Parsers;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.ButtonImage;
import com.ldtteam.blockout.controls.ButtonVanilla;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;

public class ToggleButton
extends Button {
    private static final Pattern SHORT_TRANSLATION = Pattern.compile("(\\$[({]\\S+)\\.\\S+([})])\\|(\\$\\.[^$|\\s]+)");
    protected List<String> rawStates;
    protected List<IFormattableTextComponent> states;
    protected int active = 0;
    protected Button button;

    public ToggleButton(PaneParams params) {
        super(params);
        this.button = Button.construct(params);
        this.setStateList(params.getString("options", ""));
    }

    public ToggleButton(String ... options) {
        this.button = new ButtonVanilla();
        this.setStateList(String.join((CharSequence)"|", options));
    }

    public ToggleButton(ResourceLocation image, String ... options) {
        this.button = new ButtonImage();
        ((ButtonImage)this.button).setImage(image);
        this.setStateList(String.join((CharSequence)"|", options));
    }

    protected void setStateList(String options) {
        Matcher m = SHORT_TRANSLATION.matcher(options);
        while (m.find()) {
            options = options.replace(m.group(3), m.group(1) + m.group(3).substring(1) + m.group(2));
            m = SHORT_TRANSLATION.matcher(options);
        }
        this.rawStates = Arrays.asList(options.split("\\s*\\|(?!\\|)\\s*"));
        this.states = this.rawStates.stream().map(option -> Parsers.TEXT.apply((String)option)).collect(Collectors.toList());
        if (!this.states.isEmpty()) {
            this.button.setText(this.states.get(this.active));
        } else {
            this.button.clearText();
        }
    }

    public List<String> getStateStrings(boolean raw) {
        return raw ? this.rawStates : this.states.stream().map(ITextComponent::getString).collect(Collectors.toList());
    }

    public List<IFormattableTextComponent> getStates() {
        return this.states;
    }

    public boolean isActiveState(String state) {
        return this.states.get(this.active).getString().equals(state) || this.rawStates.get(this.active).equals(state) || this.rawStates.get(this.active).substring(0, this.rawStates.get(this.active).length() - 1).endsWith(state);
    }

    public boolean setActiveState(String state) {
        int index = -1;
        for (int i = 0; i < this.rawStates.size(); ++i) {
            String s = this.rawStates.get(i);
            if (!s.equals(state) && !s.substring(0, s.length() - 1).endsWith(state)) continue;
            index = i;
            break;
        }
        if (index >= 0) {
            this.active = index;
            this.button.setText(this.states.get(this.active));
            return true;
        }
        this.button.clearText();
        return false;
    }

    public void setButton(Button button) {
        this.button = button;
        if (!this.states.isEmpty()) {
            button.setText(this.states.get(this.active));
        } else {
            button.clearText();
        }
    }

    public Button getButton() {
        return this.button;
    }

    @Override
    public boolean handleClick(double mx, double my) {
        if (!this.states.isEmpty()) {
            this.active = (this.active + 1) % this.states.size();
            this.button.setText(this.states.get(this.active));
        }
        return super.handleClick(mx, my);
    }

    @Override
    public void drawSelf(MatrixStack ms, double mx, double my) {
        this.button.drawSelf(ms, mx, my);
    }

    @Override
    public void drawSelfLast(MatrixStack ms, double mx, double my) {
        this.button.drawSelfLast(ms, mx, my);
    }
}

