/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout;

import com.ldtteam.blockout.Log;
import com.ldtteam.blockout.Pane;
import com.ldtteam.blockout.PaneParams;
import com.ldtteam.blockout.controls.Button;
import com.ldtteam.blockout.controls.Gradient;
import com.ldtteam.blockout.controls.Image;
import com.ldtteam.blockout.controls.ImageRepeatable;
import com.ldtteam.blockout.controls.ItemIcon;
import com.ldtteam.blockout.controls.Text;
import com.ldtteam.blockout.controls.TextFieldVanilla;
import com.ldtteam.blockout.controls.ToggleButton;
import com.ldtteam.blockout.views.Box;
import com.ldtteam.blockout.views.DropDownList;
import com.ldtteam.blockout.views.Group;
import com.ldtteam.blockout.views.OverlayView;
import com.ldtteam.blockout.views.ScrollingGroup;
import com.ldtteam.blockout.views.ScrollingList;
import com.ldtteam.blockout.views.SwitchView;
import com.ldtteam.blockout.views.TreeView;
import com.ldtteam.blockout.views.View;
import com.ldtteam.blockout.views.Window;
import com.ldtteam.blockout.views.ZoomDragView;
import com.ldtteam.structurize.Structurize;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class Loader {
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
    private static final Map<ResourceLocation, Function<PaneParams, ? extends Pane>> paneFactories = new HashMap<ResourceLocation, Function<PaneParams, ? extends Pane>>();
    private static final Map<ResourceLocation, Tuple<Integer, PaneParams>> parsedCache;

    private Loader() {
    }

    public static void register(String name, Function<PaneParams, ? extends Pane> factoryMethod) {
        ResourceLocation key = new ResourceLocation(name);
        if (paneFactories.containsKey(key)) {
            throw new IllegalArgumentException("Duplicate pane type '" + name + "' when registering Pane class method.");
        }
        paneFactories.put(key, factoryMethod);
    }

    private static Pane createFromPaneParams(PaneParams params) {
        ResourceLocation paneType = new ResourceLocation(params.getType());
        if (paneFactories.containsKey(paneType)) {
            return paneFactories.get(paneType).apply(params);
        }
        if (paneFactories.containsKey(new ResourceLocation(paneType.func_110623_a()))) {
            Log.getLogger().warn("Namespace override for " + paneType.func_110623_a() + " not found. Using default.");
            return paneFactories.get(new ResourceLocation(paneType.func_110623_a())).apply(params);
        }
        Log.getLogger().error("There is no factory method for " + paneType.func_110623_a());
        return null;
    }

    public static Pane createFromPaneParams(PaneParams params, View parent) {
        if ("layout".equalsIgnoreCase(params.getType())) {
            params.getResource("source", r -> Loader.createFromXMLFile(r, parent));
            return null;
        }
        if (parent instanceof Window && params.getType().equals("window")) {
            ((Window)parent).loadParams(params);
            parent.parseChildren(params);
            return parent;
        }
        if (parent instanceof View && params.getType().equals("window")) {
            parent.parseChildren(params);
            return parent;
        }
        params.setParentView(parent);
        Pane pane = Loader.createFromPaneParams(params);
        if (pane != null) {
            pane.putInside(parent);
            pane.parseChildren(params);
        }
        return pane;
    }

    private static PaneParams createFromDocument(@Nullable Document doc, View parent) {
        if (doc == null) {
            return null;
        }
        doc.getDocumentElement().normalize();
        PaneParams root = new PaneParams(doc.getDocumentElement());
        Loader.createFromPaneParams(root, parent);
        return root;
    }

    private static Document parseXML(InputSource input) {
        try {
            DocumentBuilder dBuilder = DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
            Document doc = dBuilder.parse(input);
            input.getByteStream().close();
            return doc;
        }
        catch (IOException | ParserConfigurationException | SAXException exc) {
            Log.getLogger().error("Exception when parsing XML.", (Throwable)exc);
            return null;
        }
    }

    public static void createFromXML(String xmlString, View parent) {
        Loader.createFromDocument(Loader.parseXML(new InputSource(new StringReader(xmlString))), parent);
    }

    public static void createFromXMLFile(String filename, View parent) {
        Loader.createFromXMLFile(new ResourceLocation(filename), parent);
    }

    public static void createFromXMLFile(ResourceLocation resource, View parent) {
        if (parsedCache.containsKey(resource)) {
            Loader.createFromPaneParams((PaneParams)parsedCache.get(resource).func_76340_b(), parent);
        } else {
            Document doc = Loader.parseXML(new InputSource(Loader.createInputStream(resource)));
            Loader.addToCache(resource, Loader.createFromDocument(doc, parent));
        }
    }

    private static InputStream createInputStream(ResourceLocation res) {
        try {
            InputStream is = (InputStream)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> () -> Minecraft.func_71410_x().func_195551_G().func_199002_a(res).func_199027_b());
            if (is == null) {
                is = (InputStream)DistExecutor.unsafeCallWhenOn((Dist)Dist.DEDICATED_SERVER, () -> () -> Loader.class.getResourceAsStream(String.format("/assets/%s/%s", res.func_110624_b(), res.func_110623_a())));
            }
            return is;
        }
        catch (RuntimeException e) {
            Log.getLogger().error("IOException Loader.java", e.getCause());
            return null;
        }
    }

    public static void addToCache(ResourceLocation loc, PaneParams doc) {
        if (parsedCache.size() >= (Integer)Structurize.getConfig().getClient().windowCacheCap.get()) {
            parsedCache.remove(((Map.Entry)parsedCache.entrySet().stream().min((a, b) -> Math.min((Integer)((Tuple)a.getValue()).func_76341_a(), (Integer)((Tuple)b.getValue()).func_76341_a())).get()).getKey());
        }
        parsedCache.put(loc, (Tuple<Integer, PaneParams>)new Tuple((Object)1, (Object)doc));
    }

    public static void cleanParsedCache() {
        parsedCache.clear();
    }

    static {
        Loader.register("view", View::new);
        Loader.register("group", Group::new);
        Loader.register("scrollgroup", ScrollingGroup::new);
        Loader.register("list", ScrollingList::new);
        Loader.register("text", Text::new);
        Loader.register("button", Button::construct);
        Loader.register("buttonimage", Button::construct);
        Loader.register("toggle", ToggleButton::new);
        Loader.register("label", Text::new);
        Loader.register("input", TextFieldVanilla::new);
        Loader.register("image", Image::new);
        Loader.register("imagerepeat", ImageRepeatable::new);
        Loader.register("box", Box::new);
        Loader.register("itemicon", ItemIcon::new);
        Loader.register("switch", SwitchView::new);
        Loader.register("dropdown", DropDownList::new);
        Loader.register("overlay", OverlayView::new);
        Loader.register("gradient", Gradient::new);
        Loader.register("zoomdragview", ZoomDragView::new);
        Loader.register("treeview", TreeView::new);
        parsedCache = Collections.synchronizedMap(new HashMap<ResourceLocation, Tuple<Integer, PaneParams>>(){

            @Override
            public Tuple<Integer, PaneParams> get(Object o) {
                Tuple me = (Tuple)super.get(o);
                this.replace((ResourceLocation)o, new Tuple((Object)((Integer)me.func_76341_a() + 1), me.func_76340_b()));
                return me;
            }
        });
    }
}

