/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockout;

import com.ldtteam.blockout.Parsers;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import javax.annotation.Nullable;
import net.minecraft.util.math.MathHelper;

public final class Color {
    private static final Map<String, Integer> nameToColorMap = new HashMap<String, Integer>();

    private Color() {
    }

    public static int parse(String color, int def) {
        Integer result = Parsers.COLOR.apply(color);
        return result != null ? result : def;
    }

    public static int getByName(String name, int def) {
        Integer i = nameToColorMap.get(name.toLowerCase(Locale.ENGLISH));
        return i != null ? i : def;
    }

    @Nullable
    public static Integer getByName(String name) {
        return nameToColorMap.get(name.toLowerCase(Locale.ENGLISH));
    }

    public static int rgbaToInt(int r, int g, int b, int a) {
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static int rgbaToInt(Matcher m) {
        int r = MathHelper.func_76125_a((int)Integer.parseInt(m.group(1)), (int)0, (int)255);
        int g = MathHelper.func_76125_a((int)Integer.parseInt(m.group(2)), (int)0, (int)255);
        int b = MathHelper.func_76125_a((int)Integer.parseInt(m.group(3)), (int)0, (int)255);
        int a = MathHelper.func_76125_a((int)((int)Double.parseDouble(m.group(4)) * 255), (int)0, (int)255);
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static net.minecraft.util.text.Color toVanilla(int color) {
        return net.minecraft.util.text.Color.func_240743_a_((int)color);
    }

    static {
        nameToColorMap.put("aqua", 65535);
        nameToColorMap.put("black", 0);
        nameToColorMap.put("blue", 255);
        nameToColorMap.put("cyan", 65535);
        nameToColorMap.put("fuchsia", 0xFF00FF);
        nameToColorMap.put("green", 32768);
        nameToColorMap.put("ivory", 0xFFFFF0);
        nameToColorMap.put("lime", 65280);
        nameToColorMap.put("magenta", 0xFF00FF);
        nameToColorMap.put("orange", 16753920);
        nameToColorMap.put("orangered", 16729344);
        nameToColorMap.put("purple", 0x800080);
        nameToColorMap.put("red", 0xFF0000);
        nameToColorMap.put("white", 0xFFFFFF);
        nameToColorMap.put("yellow", 0xFFFF00);
        nameToColorMap.put("gray", 0x808080);
        nameToColorMap.put("darkgray", 0xA9A9A9);
        nameToColorMap.put("dimgray", 0x696969);
        nameToColorMap.put("lightgray", 0xD3D3D3);
        nameToColorMap.put("slategray", 7372944);
        nameToColorMap.put("darkgreen", 25600);
    }
}

