/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.integration;

import com.jaquadro.minecraft.storagedrawers.api.storage.EmptyDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.IFractionalDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.capabilities.CapabilityDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.config.CommonConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class DrawerOverlay {
    public boolean showContent = true;
    public boolean showStackLimit = true;
    public boolean showStatus = true;
    public boolean showStackRemainder;
    public boolean respectQuantifyKey;

    public DrawerOverlay() {
        this.showStackRemainder = (Boolean)CommonConfig.INTEGRATION.wailaStackRemainder.get();
        this.respectQuantifyKey = (Boolean)CommonConfig.INTEGRATION.wailaRespectQuantifyKey.get();
    }

    public List<ITextComponent> getOverlay(TileEntityDrawers tile) {
        ArrayList<ITextComponent> result = new ArrayList<ITextComponent>();
        IDrawerAttributes attr = (IDrawerAttributes)tile.getCapability(CapabilityDrawerAttributes.DRAWER_ATTRIBUTES_CAPABILITY, null).orElse((Object)EmptyDrawerAttributes.EMPTY);
        this.addContent(result, tile, attr);
        this.addStackLimit(result, tile, attr);
        this.addStatus(result, tile, attr);
        return result;
    }

    private void addContent(List<ITextComponent> result, TileEntityDrawers tile, IDrawerAttributes attr) {
        if (!this.showContent || attr.isConcealed()) {
            return;
        }
        boolean showCounts = !this.respectQuantifyKey || attr.isShowingQuantity();
        IDrawerGroup group = tile.getGroup();
        for (int i = 0; i < group.getDrawerCount(); ++i) {
            IDrawer drawer = group.getDrawer(i);
            if (!drawer.isEnabled()) continue;
            TranslationTextComponent name = new TranslationTextComponent("tooltip.storagedrawers.waila.empty");
            ItemStack stack = drawer.getStoredItemPrototype();
            if (!stack.func_190926_b()) {
                IFormattableTextComponent stackName = new StringTextComponent("").func_230529_a_(stack.func_200301_q());
                if (showCounts) {
                    if (drawer.getStoredItemCount() == Integer.MAX_VALUE) {
                        name = stackName.func_240702_b_("[\u221e]");
                    } else if (drawer instanceof IFractionalDrawer && ((IFractionalDrawer)drawer).getConversionRate() > 1) {
                        String text = (i == 0 ? " [" : " [+") + ((IFractionalDrawer)drawer).getStoredItemRemainder() + "]";
                        name = stackName.func_240702_b_(text);
                    } else if (this.showStackRemainder) {
                        int stacks = drawer.getStoredItemCount() / drawer.getStoredItemStackSize();
                        int remainder = drawer.getStoredItemCount() - stacks * drawer.getStoredItemStackSize();
                        name = stacks > 0 && remainder > 0 ? stackName.func_240702_b_(" [" + stacks + "x" + drawer.getStoredItemStackSize() + " + " + remainder + "]") : (stacks > 0 ? stackName.func_240702_b_(" [" + stacks + "x" + drawer.getStoredItemStackSize() + "]") : stackName.func_240702_b_(" [" + remainder + "]"));
                    } else {
                        name = stackName.func_240702_b_(" [" + drawer.getStoredItemCount() + "]");
                    }
                } else {
                    name = stackName;
                }
            }
            result.add((ITextComponent)new TranslationTextComponent("tooltip.storagedrawers.waila.drawer", new Object[]{i + 1, name}));
        }
    }

    private void addStackLimit(List<ITextComponent> result, TileEntityDrawers tile, IDrawerAttributes attr) {
        if (!this.showStackLimit) {
            return;
        }
        if (attr.isUnlimitedStorage() || tile.getDrawerAttributes().isUnlimitedVending()) {
            result.add((ITextComponent)new TranslationTextComponent("tooltip.storagedrawers.waila.nolimit"));
        } else {
            int multiplier = tile.upgrades().getStorageMultiplier();
            int limit = tile.getEffectiveDrawerCapacity() * multiplier;
            result.add((ITextComponent)new TranslationTextComponent("tooltip.storagedrawers.waila.limit", new Object[]{limit, multiplier}));
        }
    }

    private void addStatus(List<ITextComponent> result, TileEntityDrawers tile, IDrawerAttributes attr) {
        if (!this.showStatus) {
            return;
        }
        ArrayList<TranslationTextComponent> attribs = new ArrayList<TranslationTextComponent>();
        if (attr.isItemLocked(LockAttribute.LOCK_POPULATED)) {
            attribs.add(new TranslationTextComponent("tooltip.storagedrawers.waila.locked"));
        }
        if (attr.isVoid()) {
            attribs.add(new TranslationTextComponent("tooltip.storagedrawers.waila.void"));
        }
        if (!attribs.isEmpty()) {
            result.add((ITextComponent)attribs.stream().reduce((a, b) -> a.func_230529_a_((ITextComponent)new StringTextComponent(", ")).func_230529_a_((ITextComponent)b)).get());
        }
    }
}

