/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.renderer;

import com.jaquadro.minecraft.storagedrawers.inventory.ItemStackHelper;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ModelManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class StorageRenderItem
extends ItemRenderer {
    private ItemRenderer parent = Minecraft.func_71410_x().func_175599_af();
    @Nonnull
    public ItemStack overrideStack = ItemStack.field_190927_a;

    public StorageRenderItem(TextureManager texManager, ModelManager modelManager, ItemColors colors) {
        super(texManager, modelManager, colors);
    }

    public ItemModelMesher func_175037_a() {
        return this.parent.func_175037_a();
    }

    public void func_229111_a_(ItemStack itemStackIn, ItemCameraTransforms.TransformType transformTypeIn, boolean leftHand, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn, IBakedModel modelIn) {
        this.parent.func_229111_a_(itemStackIn, transformTypeIn, leftHand, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, modelIn);
    }

    public void func_229109_a_(@Nullable LivingEntity livingEntityIn, ItemStack itemStackIn, ItemCameraTransforms.TransformType transformTypeIn, boolean leftHand, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, @Nullable World worldIn, int combinedLightIn, int combinedOverlayIn) {
        this.parent.func_229109_a_(livingEntityIn, itemStackIn, transformTypeIn, leftHand, matrixStackIn, bufferIn, worldIn, combinedLightIn, combinedOverlayIn);
    }

    public void func_229110_a_(ItemStack itemStackIn, ItemCameraTransforms.TransformType transformTypeIn, int combinedLightIn, int combinedOverlayIn, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn) {
        this.parent.func_229110_a_(itemStackIn, transformTypeIn, combinedLightIn, combinedOverlayIn, matrixStackIn, bufferIn);
    }

    public void func_229112_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, List<BakedQuad> quadsIn, ItemStack itemStackIn, int combinedLightIn, int combinedOverlayIn) {
        this.parent.func_229112_a_(matrixStackIn, bufferIn, quadsIn, itemStackIn, combinedLightIn, combinedOverlayIn);
    }

    public IBakedModel func_184393_a(@Nonnull ItemStack stack, World world, LivingEntity entity) {
        return this.parent.func_184393_a(stack, world, entity);
    }

    public void func_175042_a(@Nonnull ItemStack stack, int x, int y) {
        this.parent.func_175042_a(stack, x, y);
    }

    public void func_180450_b(@Nonnull ItemStack stack, int xPosition, int yPosition) {
        this.parent.func_180450_b(stack, xPosition, yPosition);
    }

    public void func_184391_a(@Nullable LivingEntity entityIn, ItemStack itemIn, int x, int y) {
        this.parent.func_184391_a(entityIn, itemIn, x, y);
    }

    public void func_175030_a(FontRenderer fr, @Nonnull ItemStack stack, int xPosition, int yPosition) {
        this.parent.func_175030_a(fr, stack, xPosition, yPosition);
    }

    public void func_180453_a(FontRenderer font, @Nonnull ItemStack item, int x, int y, String text) {
        if (item != this.overrideStack) {
            super.func_180453_a(font, item, x, y, text);
            return;
        }
        if (!item.func_190926_b()) {
            ClientPlayerEntity clientplayerentity;
            float f3;
            item = ItemStackHelper.decodeItemStack(item);
            float scale = 0.5f;
            float xoff = 0.0f;
            int stackSize = item.func_190916_E();
            if (ItemStackHelper.isStackEncoded(item)) {
                stackSize = 0;
            }
            MatrixStack matrixstack = new MatrixStack();
            if (stackSize >= 0 || text != null) {
                text = stackSize >= 100000000 ? (text == null ? String.format("%.0fM", Float.valueOf((float)stackSize / 1000000.0f)) : text) : (stackSize >= 1000000 ? (text == null ? String.format("%.1fM", Float.valueOf((float)stackSize / 1000000.0f)) : text) : (stackSize >= 100000 ? (text == null ? String.format("%.0fK", Float.valueOf((float)stackSize / 1000.0f)) : text) : (stackSize >= 10000 ? (text == null ? String.format("%.1fK", Float.valueOf((float)stackSize / 1000.0f)) : text) : (text == null ? String.valueOf(stackSize) : text))));
                int textX = (int)(((float)(x + 16) + xoff - (float)font.func_78256_a(text) * scale) / scale) - 1;
                int textY = (int)(((float)(y + 16) - 7.0f * scale) / scale) - 1;
                int color = 0xFFFFFF;
                if (stackSize == 0) {
                    color = 0xFF6060;
                }
                matrixstack.func_227862_a_(scale, scale, 1.0f);
                matrixstack.func_227861_a_(0.0, 0.0, (double)(this.field_77023_b + 200.0f));
                IRenderTypeBuffer.Impl buffer = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
                font.func_228079_a_(text, (float)textX, (float)textY, color, true, matrixstack.func_227866_c_().func_227870_a_(), (IRenderTypeBuffer)buffer, false, 0, 0xF000F0);
                buffer.func_228461_a_();
            }
            if (item.func_77973_b().showDurabilityBar(item)) {
                RenderSystem.disableDepthTest();
                RenderSystem.disableTexture();
                RenderSystem.disableAlphaTest();
                RenderSystem.disableBlend();
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                double health = item.func_77973_b().getDurabilityForDisplay(item);
                int i = Math.round(13.0f - (float)health * 13.0f);
                int j = item.func_77973_b().getRGBDurabilityForDisplay(item);
                this.draw(bufferbuilder, x + 2, y + 13, 13, 2, 0, 0, 0, 255);
                this.draw(bufferbuilder, x + 2, y + 13, i, 1, j >> 16 & 0xFF, j >> 8 & 0xFF, j & 0xFF, 255);
                RenderSystem.enableBlend();
                RenderSystem.enableAlphaTest();
                RenderSystem.enableTexture();
                RenderSystem.enableDepthTest();
            }
            float f = f3 = (clientplayerentity = Minecraft.func_71410_x().field_71439_g) == null ? 0.0f : clientplayerentity.func_184811_cZ().func_185143_a(item.func_77973_b(), Minecraft.func_71410_x().func_184121_ak());
            if (f3 > 0.0f) {
                RenderSystem.disableDepthTest();
                RenderSystem.disableTexture();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                Tessellator tessellator1 = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder1 = tessellator1.func_178180_c();
                this.draw(bufferbuilder1, x, y + MathHelper.func_76141_d((float)(16.0f * (1.0f - f3))), 16, MathHelper.func_76123_f((float)(16.0f * f3)), 255, 255, 255, 127);
                RenderSystem.enableTexture();
                RenderSystem.enableDepthTest();
            }
        }
    }

    public void func_195410_a(IResourceManager p_195410_1_) {
        this.parent.func_195410_a(p_195410_1_);
    }

    private void draw(BufferBuilder tessellator, int x, int y, int w, int h, int r, int g, int b, int a) {
        tessellator.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        tessellator.func_225582_a_((double)(x + 0), (double)(y + 0), 0.0).func_225586_a_(r, g, b, a).func_181675_d();
        tessellator.func_225582_a_((double)(x + 0), (double)(y + h), 0.0).func_225586_a_(r, g, b, a).func_181675_d();
        tessellator.func_225582_a_((double)(x + w), (double)(y + h), 0.0).func_225586_a_(r, g, b, a).func_181675_d();
        tessellator.func_225582_a_((double)(x + w), (double)(y + 0), 0.0).func_225586_a_(r, g, b, a).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }
}

