/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.lib.xz;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import me.lucko.spark.lib.xz.ArrayCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicArrayCache
extends ArrayCache {
    private static final int CACHEABLE_SIZE_MIN = 32768;
    private static final int STACKS_MAX = 32;
    private static final int ELEMENTS_PER_STACK = 512;
    private final CacheMap<byte[]> byteArrayCache = new CacheMap();
    private final CacheMap<int[]> intArrayCache = new CacheMap();

    public static BasicArrayCache getInstance() {
        return LazyHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T getArray(CacheMap<T> cacheMap, int n) {
        Reference reference;
        CyclicStack cyclicStack;
        if (n < 32768) {
            return null;
        }
        CacheMap<T> cacheMap2 = cacheMap;
        synchronized (cacheMap2) {
            cyclicStack = (CyclicStack)cacheMap.get(n);
        }
        if (cyclicStack == null) {
            return null;
        }
        do {
            if ((reference = (Reference)cyclicStack.pop()) != null) continue;
            return null;
        } while ((cacheMap2 = reference.get()) == null);
        return (T)cacheMap2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> void putArray(CacheMap<T> cacheMap, T t, int n) {
        CyclicStack<SoftReference<T>> cyclicStack;
        if (n < 32768) {
            return;
        }
        CacheMap<T> cacheMap2 = cacheMap;
        synchronized (cacheMap2) {
            cyclicStack = (CyclicStack<SoftReference<T>>)cacheMap.get(n);
            if (cyclicStack == null) {
                cyclicStack = new CyclicStack<SoftReference<T>>();
                cacheMap.put(n, cyclicStack);
            }
        }
        cyclicStack.push(new SoftReference<T>(t));
    }

    @Override
    public byte[] getByteArray(int n, boolean bl) {
        byte[] byArray = BasicArrayCache.getArray(this.byteArrayCache, n);
        if (byArray == null) {
            byArray = new byte[n];
        } else if (bl) {
            Arrays.fill(byArray, (byte)0);
        }
        return byArray;
    }

    @Override
    public void putArray(byte[] byArray) {
        BasicArrayCache.putArray(this.byteArrayCache, byArray, byArray.length);
    }

    @Override
    public int[] getIntArray(int n, boolean bl) {
        int[] nArray = BasicArrayCache.getArray(this.intArrayCache, n);
        if (nArray == null) {
            nArray = new int[n];
        } else if (bl) {
            Arrays.fill(nArray, 0);
        }
        return nArray;
    }

    @Override
    public void putArray(int[] nArray) {
        BasicArrayCache.putArray(this.intArrayCache, nArray, nArray.length);
    }

    private static final class LazyHolder {
        static final BasicArrayCache INSTANCE = new BasicArrayCache();

        private LazyHolder() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CacheMap<T>
    extends LinkedHashMap<Integer, CyclicStack<Reference<T>>> {
        private static final long serialVersionUID = 1L;

        public CacheMap() {
            super(64, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Integer, CyclicStack<Reference<T>>> entry) {
            return this.size() > 32;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CyclicStack<T> {
        private final T[] elements = new Object[512];
        private int pos = 0;

        private CyclicStack() {
        }

        public synchronized T pop() {
            T t = this.elements[this.pos];
            this.elements[this.pos] = null;
            this.pos = this.pos - 1 & 0x1FF;
            return t;
        }

        public synchronized void push(T t) {
            this.pos = this.pos + 1 & 0x1FF;
            this.elements[this.pos] = t;
        }
    }
}

