/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.LongConsumer;
import java.util.zip.GZIPOutputStream;
import me.lucko.spark.lib.xz.LZMA2Options;
import me.lucko.spark.lib.xz.LZMAOutputStream;
import me.lucko.spark.lib.xz.XZOutputStream;

public enum Compression {
    GZIP{

        @Override
        public Path compress(Path file, LongConsumer progressHandler) throws IOException {
            Path compressedFile = file.getParent().resolve(file.getFileName().toString() + ".gz");
            try (InputStream in = Files.newInputStream(file, new OpenOption[0]);
                 OutputStream out = Files.newOutputStream(compressedFile, new OpenOption[0]);
                 GZIPOutputStream compressionOut = new GZIPOutputStream(out, 65536);){
                Compression.copy(in, compressionOut, progressHandler);
            }
            return compressedFile;
        }
    }
    ,
    XZ{

        @Override
        public Path compress(Path file, LongConsumer progressHandler) throws IOException {
            Path compressedFile = file.getParent().resolve(file.getFileName().toString() + ".xz");
            try (InputStream in = Files.newInputStream(file, new OpenOption[0]);
                 OutputStream out = Files.newOutputStream(compressedFile, new OpenOption[0]);
                 XZOutputStream compressionOut = new XZOutputStream(out, new LZMA2Options());){
                Compression.copy(in, compressionOut, progressHandler);
            }
            return compressedFile;
        }
    }
    ,
    LZMA{

        @Override
        public Path compress(Path file, LongConsumer progressHandler) throws IOException {
            Path compressedFile = file.getParent().resolve(file.getFileName().toString() + ".lzma");
            try (InputStream in = Files.newInputStream(file, new OpenOption[0]);
                 OutputStream out = Files.newOutputStream(compressedFile, new OpenOption[0]);
                 LZMAOutputStream compressionOut = new LZMAOutputStream(out, new LZMA2Options(), true);){
                Compression.copy(in, compressionOut, progressHandler);
            }
            return compressedFile;
        }
    };


    public abstract Path compress(Path var1, LongConsumer var2) throws IOException;

    private static long copy(InputStream from, OutputStream to, LongConsumer progress) throws IOException {
        int r;
        byte[] buf = new byte[65536];
        long total = 0L;
        long iterations = 0L;
        while ((r = from.read(buf)) != -1) {
            to.write(buf, 0, r);
            total += (long)r;
            if (iterations++ % 80L != 0L) continue;
            progress.accept(total);
        }
        return total;
    }
}

