/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.sampler.async;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import me.lucko.spark.common.SparkPlatform;
import me.lucko.spark.common.command.sender.CommandSender;
import me.lucko.spark.common.sampler.AbstractSampler;
import me.lucko.spark.common.sampler.ThreadDumper;
import me.lucko.spark.common.sampler.ThreadGrouper;
import me.lucko.spark.common.sampler.async.AsyncDataAggregator;
import me.lucko.spark.common.sampler.async.AsyncProfilerAccess;
import me.lucko.spark.common.sampler.async.AsyncStackTraceElement;
import me.lucko.spark.common.sampler.async.ProfileSegment;
import me.lucko.spark.common.sampler.async.jfr.JfrReader;
import me.lucko.spark.common.sampler.node.MergeMode;
import me.lucko.spark.common.sampler.node.ThreadNode;
import me.lucko.spark.common.util.ClassSourceLookup;
import me.lucko.spark.common.util.TemporaryFiles;
import me.lucko.spark.lib.asyncprofiler.AsyncProfiler;
import me.lucko.spark.proto.SparkSamplerProtos;

public class AsyncSampler
extends AbstractSampler {
    private final AsyncProfiler profiler = AsyncProfilerAccess.INSTANCE.getProfiler();
    private final AsyncDataAggregator dataAggregator;
    private boolean outputComplete = false;
    private Path outputFile;
    private ScheduledExecutorService timeoutExecutor;

    public AsyncSampler(int interval, ThreadDumper threadDumper, ThreadGrouper threadGrouper, long endTime) {
        super(interval, threadDumper, endTime);
        this.dataAggregator = new AsyncDataAggregator(threadGrouper);
    }

    private String execute(String command) {
        try {
            return this.profiler.execute(command);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception whilst executing profiler command", e);
        }
    }

    @Override
    public void start() {
        String resp;
        this.startTime = System.currentTimeMillis();
        try {
            this.outputFile = TemporaryFiles.create("spark-profile-", ".jfr.tmp");
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create temporary output file", e);
        }
        String command = "start,event=" + (Object)((Object)AsyncProfilerAccess.INSTANCE.getProfilingEvent()) + ",interval=" + this.interval + "us,threads,jfr,file=" + this.outputFile.toString();
        if (this.threadDumper instanceof ThreadDumper.Specific) {
            command = command + ",filter";
        }
        if (!(resp = this.execute(command).trim()).equalsIgnoreCase("profiling started")) {
            throw new RuntimeException("Unexpected response: " + resp);
        }
        if (this.threadDumper instanceof ThreadDumper.Specific) {
            ThreadDumper.Specific threadDumper = (ThreadDumper.Specific)this.threadDumper;
            for (Thread thread : threadDumper.getThreads()) {
                this.profiler.addThread(thread);
            }
        }
        this.recordInitialGcStats();
        this.scheduleTimeout();
    }

    private void scheduleTimeout() {
        if (this.endTime == -1L) {
            return;
        }
        long delay = this.endTime - System.currentTimeMillis();
        if (delay <= 0L) {
            return;
        }
        this.timeoutExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("spark-asyncsampler-timeout-thread").build());
        this.timeoutExecutor.schedule(() -> {
            this.stop();
            this.future.complete(this);
        }, delay, TimeUnit.MILLISECONDS);
    }

    @Override
    public void stop() {
        this.profiler.stop();
        if (this.timeoutExecutor != null) {
            this.timeoutExecutor.shutdown();
            this.timeoutExecutor = null;
        }
    }

    @Override
    public SparkSamplerProtos.SamplerData toProto(SparkPlatform platform, CommandSender creator, Comparator<ThreadNode> outputOrder, String comment, MergeMode mergeMode, ClassSourceLookup classSourceLookup) {
        SparkSamplerProtos.SamplerData.Builder proto = SparkSamplerProtos.SamplerData.newBuilder();
        this.writeMetadataToProto(proto, platform, creator, comment, this.dataAggregator);
        this.aggregateOutput();
        this.writeDataToProto(proto, this.dataAggregator, outputOrder, mergeMode, classSourceLookup);
        return (SparkSamplerProtos.SamplerData)proto.build();
    }

    private void aggregateOutput() {
        Predicate<String> threadFilter;
        if (this.outputComplete) {
            return;
        }
        this.outputComplete = true;
        if (this.threadDumper instanceof ThreadDumper.Specific) {
            ThreadDumper.Specific threadDumper = (ThreadDumper.Specific)this.threadDumper;
            threadFilter = n -> threadDumper.getThreadNames().contains(n.toLowerCase());
        } else {
            threadFilter = n -> true;
        }
        try (JfrReader reader = new JfrReader(this.outputFile);){
            this.readSegments(reader, threadFilter);
        }
        catch (IOException e) {
            throw new RuntimeException("Read error", e);
        }
        try {
            Files.deleteIfExists(this.outputFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void readSegments(JfrReader reader, Predicate<String> threadFilter) throws IOException {
        List<JfrReader.ExecutionSample> samples = reader.readAllEvents(JfrReader.ExecutionSample.class);
        for (int i = 0; i < samples.size(); ++i) {
            JfrReader.ExecutionSample sample = samples.get(i);
            long duration = i == 0 ? (long)this.interval : TimeUnit.NANOSECONDS.toMicros(sample.time - samples.get((int)(i - 1)).time);
            String threadName = reader.threads.get(sample.tid);
            if (!threadFilter.test(threadName)) continue;
            ProfileSegment segment = AsyncSampler.parseSegment(reader, sample, threadName, duration);
            this.dataAggregator.insertData(segment);
        }
    }

    private static ProfileSegment parseSegment(JfrReader reader, JfrReader.ExecutionSample sample, String threadName, long duration) {
        JfrReader.StackTrace stackTrace = reader.stackTraces.get(sample.stackTraceId);
        int len = stackTrace.methods.length;
        AsyncStackTraceElement[] stack = new AsyncStackTraceElement[len];
        for (int i = 0; i < len; ++i) {
            stack[i] = AsyncSampler.parseStackFrame(reader, stackTrace.methods[i]);
        }
        return new ProfileSegment(sample.tid, threadName, stack, duration);
    }

    private static AsyncStackTraceElement parseStackFrame(JfrReader reader, long methodId) {
        AsyncStackTraceElement result = reader.stackFrames.get(methodId);
        if (result != null) {
            return result;
        }
        JfrReader.MethodRef methodRef = reader.methods.get(methodId);
        JfrReader.ClassRef classRef = reader.classes.get(methodRef.cls);
        byte[] className = reader.symbols.get(classRef.name);
        byte[] methodName = reader.symbols.get(methodRef.name);
        if (className == null || className.length == 0) {
            result = new AsyncStackTraceElement("native", new String(methodName, StandardCharsets.UTF_8), null);
        } else {
            byte[] methodDesc = reader.symbols.get(methodRef.sig);
            result = new AsyncStackTraceElement(new String(className, StandardCharsets.UTF_8).replace('/', '.'), new String(methodName, StandardCharsets.UTF_8), new String(methodDesc, StandardCharsets.UTF_8));
        }
        reader.stackFrames.put(methodId, result);
        return result;
    }
}

