/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.platform.serverconfig;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;

public class PropertiesFileReader
extends FilterReader {
    public PropertiesFileReader(Reader in) {
        super(in);
    }

    public Map<String, Object> readProperties() throws IOException {
        Properties properties = new Properties();
        properties.load(this);
        HashMap<String, Object> values = new HashMap<String, Object>();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String key = k.toString();
            String value = v.toString();
            if ("true".equals(value) || "false".equals(value)) {
                values.put(key, Boolean.parseBoolean(value));
            } else if (value.matches("\\d+")) {
                try {
                    values.put(key, Long.parseLong(value));
                }
                catch (NumberFormatException e) {
                    values.put(key, value);
                }
            } else {
                values.put(key, value);
            }
        }));
        return values;
    }
}

