/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.monitor.tick;

import com.sun.management.GarbageCollectionNotificationInfo;
import java.text.DecimalFormat;
import java.util.DoubleSummaryStatistics;
import me.lucko.spark.common.SparkPlatform;
import me.lucko.spark.common.monitor.memory.GarbageCollectionMonitor;
import me.lucko.spark.common.monitor.tick.ReportPredicate;
import me.lucko.spark.common.tick.TickHook;
import me.lucko.spark.lib.adventure.text.Component;
import me.lucko.spark.lib.adventure.text.TextComponent;
import me.lucko.spark.lib.adventure.text.format.NamedTextColor;
import me.lucko.spark.lib.adventure.text.format.TextColor;

public abstract class TickMonitor
implements TickHook.Callback,
GarbageCollectionMonitor.Listener,
AutoCloseable {
    private static final DecimalFormat DF = new DecimalFormat("#.##");
    private final SparkPlatform platform;
    private final TickHook tickHook;
    private final int zeroTick;
    private final GarbageCollectionMonitor garbageCollectionMonitor;
    private final ReportPredicate reportPredicate;
    private Phase phase = null;
    private volatile double lastTickTime = 0.0;
    private final DoubleSummaryStatistics averageTickTimeCalc = new DoubleSummaryStatistics();
    private double averageTickTime;

    public TickMonitor(SparkPlatform platform, TickHook tickHook, ReportPredicate reportPredicate, boolean monitorGc) {
        this.platform = platform;
        this.tickHook = tickHook;
        this.zeroTick = tickHook.getCurrentTick();
        this.reportPredicate = reportPredicate;
        if (monitorGc) {
            this.garbageCollectionMonitor = new GarbageCollectionMonitor();
            this.garbageCollectionMonitor.addListener(this);
        } else {
            this.garbageCollectionMonitor = null;
        }
    }

    public int getCurrentTick() {
        return this.tickHook.getCurrentTick() - this.zeroTick;
    }

    protected abstract void sendMessage(Component var1);

    public void start() {
        this.tickHook.addCallback(this);
    }

    @Override
    public void close() {
        this.tickHook.removeCallback(this);
        if (this.garbageCollectionMonitor != null) {
            this.garbageCollectionMonitor.close();
        }
    }

    @Override
    public void onTick(int currentTick) {
        double percentageChange;
        double increase;
        double now = (double)System.nanoTime() / 1000000.0;
        if (this.phase == null) {
            this.phase = Phase.SETUP;
            this.lastTickTime = now;
            this.sendMessage(Component.text("Tick monitor started. Before the monitor becomes fully active, the server's average tick rate will be calculated over a period of 120 ticks (approx 6 seconds)."));
            return;
        }
        double last = this.lastTickTime;
        double tickDuration = now - last;
        this.lastTickTime = now;
        if (last == 0.0) {
            return;
        }
        if (this.phase == Phase.SETUP) {
            this.averageTickTimeCalc.accept(tickDuration);
            if (this.averageTickTimeCalc.getCount() >= 120L) {
                this.platform.getPlugin().executeAsync(() -> {
                    this.sendMessage(Component.text("Analysis is now complete.", (TextColor)NamedTextColor.GOLD));
                    this.sendMessage((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color(NamedTextColor.GRAY)).append((Component)Component.text(">", (TextColor)NamedTextColor.WHITE))).append((Component)Component.space())).append((Component)Component.text("Max: "))).append((Component)Component.text(DF.format(this.averageTickTimeCalc.getMax())))).append((Component)Component.text("ms"))).build());
                    this.sendMessage((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color(NamedTextColor.GRAY)).append((Component)Component.text(">", (TextColor)NamedTextColor.WHITE))).append((Component)Component.space())).append((Component)Component.text("Min: "))).append((Component)Component.text(DF.format(this.averageTickTimeCalc.getMin())))).append((Component)Component.text("ms"))).build());
                    this.sendMessage((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color(NamedTextColor.GRAY)).append((Component)Component.text(">", (TextColor)NamedTextColor.WHITE))).append((Component)Component.space())).append((Component)Component.text("Average: "))).append((Component)Component.text(DF.format(this.averageTickTimeCalc.getAverage())))).append((Component)Component.text("ms"))).build());
                    this.sendMessage(this.reportPredicate.monitoringStartMessage());
                });
                this.averageTickTime = this.averageTickTimeCalc.getAverage();
                this.phase = Phase.MONITORING;
            }
        }
        if (this.phase == Phase.MONITORING && this.reportPredicate.shouldReport(tickDuration, increase = tickDuration - this.averageTickTime, percentageChange = increase * 100.0 / this.averageTickTime)) {
            this.platform.getPlugin().executeAsync(() -> this.sendMessage((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color(NamedTextColor.GRAY)).append((Component)Component.text("Tick "))).append((Component)Component.text("#" + this.getCurrentTick(), (TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.text(" lasted "))).append((Component)Component.text(DF.format(tickDuration), (TextColor)NamedTextColor.GOLD))).append((Component)Component.text(" ms. "))).append((Component)Component.text("("))).append((Component)Component.text(DF.format(percentageChange) + "%", (TextColor)NamedTextColor.GOLD))).append((Component)Component.text(" increase from avg)"))).build()));
        }
    }

    @Override
    public void onGc(GarbageCollectionNotificationInfo data) {
        if (this.phase == Phase.SETUP) {
            this.lastTickTime = 0.0;
            return;
        }
        this.platform.getPlugin().executeAsync(() -> this.sendMessage((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().color(NamedTextColor.GRAY)).append((Component)Component.text("Tick "))).append((Component)Component.text("#" + this.getCurrentTick(), (TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.text(" included "))).append((Component)Component.text("GC", (TextColor)NamedTextColor.RED))).append((Component)Component.text(" lasting "))).append((Component)Component.text(DF.format(data.getGcInfo().getDuration()), (TextColor)NamedTextColor.GOLD))).append((Component)Component.text(" ms. (type = " + GarbageCollectionMonitor.getGcType(data) + ")"))).build()));
    }

    private static enum Phase {
        SETUP,
        MONITORING;

    }
}

