/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.util;

import java.util.Collections;
import java.util.Set;
import java.util.function.UnaryOperator;
import net.minecraft.item.ItemStack;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.BackpackInventoryHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.util.ItemStackKey;

public interface ISlotTracker {
    public Set<ItemStackKey> getFullStacks();

    public Set<ItemStackKey> getPartialStacks();

    public void removeAndSetSlotIndexes(BackpackInventoryHandler var1, int var2, ItemStack var3);

    public void clear();

    public void refreshSlotIndexesFrom(BackpackInventoryHandler var1);

    public ItemStack insertItemIntoHandler(BackpackInventoryHandler var1, IItemHandlerInserter var2, UnaryOperator<ItemStack> var3, ItemStack var4, boolean var5);

    public ItemStack insertItemIntoHandler(BackpackInventoryHandler var1, IItemHandlerInserter var2, UnaryOperator<ItemStack> var3, int var4, ItemStack var5, boolean var6);

    public static class Noop
    implements ISlotTracker {
        @Override
        public Set<ItemStackKey> getFullStacks() {
            return Collections.emptySet();
        }

        @Override
        public Set<ItemStackKey> getPartialStacks() {
            return Collections.emptySet();
        }

        @Override
        public void removeAndSetSlotIndexes(BackpackInventoryHandler inventoryHandler, int slot, ItemStack stack) {
        }

        @Override
        public void clear() {
        }

        @Override
        public void refreshSlotIndexesFrom(BackpackInventoryHandler itemHandler) {
        }

        @Override
        public ItemStack insertItemIntoHandler(BackpackInventoryHandler itemHandler, IItemHandlerInserter inserter, UnaryOperator<ItemStack> overflowHandler, ItemStack stack, boolean simulate) {
            ItemStack remainingStack = stack.func_77946_l();
            int slots = itemHandler.getSlots();
            for (int slot = 0; slot < slots && !remainingStack.func_190926_b(); ++slot) {
                remainingStack = inserter.insertItem(slot, remainingStack, simulate);
            }
            return remainingStack;
        }

        @Override
        public ItemStack insertItemIntoHandler(BackpackInventoryHandler itemHandler, IItemHandlerInserter inserter, UnaryOperator<ItemStack> overflowHandler, int slot, ItemStack stack, boolean simulate) {
            return inserter.insertItem(slot, stack, simulate);
        }
    }

    public static interface IItemHandlerInserter {
        public ItemStack insertItem(int var1, ItemStack var2, boolean var3);
    }
}

