/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.upgrades.stonecutter;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.StonecuttingRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntReferenceHolder;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.p3pp3rf1y.sophisticatedbackpacks.common.gui.SlotSuppliedHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.IServerUpdater;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.crafting.CraftingItemHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.stonecutter.StonecutterUpgradeContainer;
import net.p3pp3rf1y.sophisticatedbackpacks.upgrades.stonecutter.StonecutterUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedbackpacks.util.RecipeHelper;

public class StonecutterRecipeContainer {
    private static final String DATA_SELECTED_RECIPE_INDEX = "selectedRecipeIndex";
    private final Slot inputSlot;
    private final IServerUpdater serverUpdater;
    private final Slot outputSlot;
    private final CraftResultInventory resultInventory = new CraftResultInventory();
    private List<StonecuttingRecipe> recipes = Lists.newArrayList();
    private final IntReferenceHolder selectedRecipe = IntReferenceHolder.func_221492_a();
    private Item inputItem = Items.field_190931_a;
    private final CraftingItemHandler inputInventory;
    private Runnable inventoryUpdateListener = () -> {};
    private final Supplier<Optional<ResourceLocation>> getLastSelectedRecipeId;
    private final Consumer<ResourceLocation> setLastSelectedRecipeId;
    private long lastOnTake = -1L;

    public StonecutterRecipeContainer(StonecutterUpgradeContainer upgradeContainer, Consumer<Slot> addSlot, IServerUpdater serverUpdater, IWorldPosCallable worldPosCallable) {
        this.inputSlot = new SlotSuppliedHandler(((StonecutterUpgradeWrapper)upgradeContainer.getUpgradeWrapper())::getInputInventory, 0, -1, -1){

            public void func_75218_e() {
                super.func_75218_e();
                StonecutterRecipeContainer.this.onCraftMatrixChanged((IInventory)StonecutterRecipeContainer.this.inputInventory);
            }

            public ItemStack func_75209_a(int amount) {
                ItemStack ret = super.func_75209_a(amount);
                if (this.func_75211_c().func_190926_b()) {
                    this.func_75218_e();
                }
                return ret;
            }
        };
        this.serverUpdater = serverUpdater;
        addSlot.accept(this.inputSlot);
        this.inputInventory = new CraftingItemHandler(((StonecutterUpgradeWrapper)upgradeContainer.getUpgradeWrapper())::getInputInventory, this::onCraftMatrixChanged);
        this.outputSlot = new ResultSlot(worldPosCallable);
        addSlot.accept(this.outputSlot);
        this.getLastSelectedRecipeId = ((StonecutterUpgradeWrapper)upgradeContainer.getUpgradeWrapper())::getRecipeId;
        this.setLastSelectedRecipeId = ((StonecutterUpgradeWrapper)upgradeContainer.getUpgradeWrapper())::setRecipeId;
        this.onCraftMatrixChanged((IInventory)this.inputInventory);
    }

    private void onCraftMatrixChanged(IInventory inventoryIn) {
        ItemStack itemstack = this.inputSlot.func_75211_c();
        if (itemstack.func_77973_b() != this.inputItem) {
            this.inputItem = itemstack.func_77973_b();
            this.updateAvailableRecipes(inventoryIn, itemstack);
        }
        this.inventoryUpdateListener.run();
    }

    private void updateAvailableRecipes(IInventory inventory, ItemStack stack) {
        this.recipes.clear();
        this.selectedRecipe.func_221494_a(-1);
        this.outputSlot.func_75215_d(ItemStack.field_190927_a);
        if (!stack.func_190926_b()) {
            this.recipes = RecipeHelper.getStonecuttingRecipes(inventory);
            this.getLastSelectedRecipeId.get().ifPresent(id -> {
                for (int i = 0; i < this.recipes.size(); ++i) {
                    if (!this.recipes.get(i).func_199560_c().equals(id)) continue;
                    this.selectedRecipe.func_221494_a(i);
                    this.updateRecipeResultSlot();
                }
            });
        }
    }

    public Slot getInputSlot() {
        return this.inputSlot;
    }

    public Slot getOutputSlot() {
        return this.outputSlot;
    }

    public void setInventoryUpdateListener(Runnable listenerIn) {
        this.inventoryUpdateListener = listenerIn;
    }

    public List<StonecuttingRecipe> getRecipeList() {
        return this.recipes;
    }

    public int getSelectedRecipe() {
        return this.selectedRecipe.func_221495_b();
    }

    public boolean hasItemsInInputSlot() {
        return this.inputSlot.func_75216_d() && !this.recipes.isEmpty();
    }

    public boolean selectRecipe(int recipeIndex) {
        if (this.isIndexInRecipeBounds(recipeIndex)) {
            this.selectedRecipe.func_221494_a(recipeIndex);
            this.setLastSelectedRecipeId.accept(this.recipes.get(recipeIndex).func_199560_c());
            this.updateRecipeResultSlot();
            this.serverUpdater.sendDataToServer(() -> NBTHelper.putInt(new CompoundNBT(), DATA_SELECTED_RECIPE_INDEX, recipeIndex));
        }
        return true;
    }

    private boolean isIndexInRecipeBounds(int index) {
        return index >= 0 && index < this.recipes.size();
    }

    private void updateRecipeResultSlot() {
        if (!this.recipes.isEmpty() && this.isIndexInRecipeBounds(this.selectedRecipe.func_221495_b())) {
            StonecuttingRecipe stonecuttingrecipe = this.recipes.get(this.selectedRecipe.func_221495_b());
            this.resultInventory.func_193056_a((IRecipe)stonecuttingrecipe);
            this.outputSlot.func_75215_d(stonecuttingrecipe.func_77572_b((IInventory)this.inputInventory));
        } else {
            this.outputSlot.func_75215_d(ItemStack.field_190927_a);
        }
    }

    public boolean handleMessage(CompoundNBT data) {
        if (data.func_74764_b(DATA_SELECTED_RECIPE_INDEX)) {
            this.selectRecipe(data.func_74762_e(DATA_SELECTED_RECIPE_INDEX));
            return true;
        }
        return false;
    }

    public boolean isNotResultSlot(Slot slot) {
        return slot != this.outputSlot;
    }

    private class ResultSlot
    extends Slot {
        private final IWorldPosCallable worldPosCallable;

        public ResultSlot(IWorldPosCallable worldPosCallable) {
            super((IInventory)StonecutterRecipeContainer.this.resultInventory, 1, -1, -1);
            this.worldPosCallable = worldPosCallable;
        }

        public boolean func_75214_a(ItemStack stack) {
            return false;
        }

        public ItemStack func_190901_a(PlayerEntity thePlayer, ItemStack stack) {
            stack.func_77980_a(thePlayer.field_70170_p, thePlayer, stack.func_190916_E());
            StonecutterRecipeContainer.this.resultInventory.func_201560_d(thePlayer);
            ItemStack itemstack = StonecutterRecipeContainer.this.inputSlot.func_75209_a(1);
            if (!itemstack.func_190926_b()) {
                StonecutterRecipeContainer.this.updateRecipeResultSlot();
            }
            this.worldPosCallable.func_221486_a((world, pos) -> {
                long l = world.func_82737_E();
                if (StonecutterRecipeContainer.this.lastOnTake != l) {
                    world.func_184133_a(null, pos, SoundEvents.field_219719_ml, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    StonecutterRecipeContainer.this.lastOnTake = l;
                }
            });
            return super.func_190901_a(thePlayer, stack);
        }
    }
}

