/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.panels;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.script.ScriptException;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import org.zeith.hammerlib.annotations.RegistryName;
import org.zeith.hammerlib.annotations.SimplyRegister;
import org.zeith.hammerlib.util.cfg.ConfigFile;
import org.zeith.hammerlib.util.cfg.entries.ConfigEntryCategory;
import org.zeith.solarflux.SolarFlux;
import org.zeith.solarflux.block.SolarPanelBlock;
import org.zeith.solarflux.block.SolarPanelTile;
import org.zeith.solarflux.panels.SolarPanel;
import org.zeith.solarflux.panels.SolarScriptEngine;

@SimplyRegister
public class SolarPanels {
    public static final Map<String, SolarPanel> PANELS = new HashMap<String, SolarPanel>();
    @RegistryName(value="solar_panel")
    public static final TileEntityType<SolarPanelTile> SOLAR_PANEL_TYPE = new TileEntityType<SolarPanelTile>(SolarPanelTile::new, new HashSet(), null){

        public boolean func_223045_a(Block blockIn) {
            return blockIn instanceof SolarPanelBlock;
        }
    };
    public static double LOOSE_ENERGY;
    public static float RAIN_MULTIPLIER;
    public static float THUNDER_MULTIPLIER;
    public static final SolarPanel[] CORE_PANELS;
    public static File CONFIG_DIR;
    public static final List<ResourceLocation> RECIPE_KEYS;
    private static final List<ResourceLocation> ENABLED_RECIPES;

    @SimplyRegister
    public static void registerPanels(Consumer<Block> registry) {
        SolarPanels.listPanelBlocks().forEach(registry);
    }

    public static Stream<SolarPanel> listPanels() {
        return PANELS.values().stream();
    }

    public static Stream<SolarPanelBlock> listPanelBlocks() {
        return SolarPanels.listPanels().map(SolarPanel::getBlock);
    }

    public static void init() {
        File custom_panels;
        Throwable throwable;
        InputStream in5;
        byte[] buf;
        File items;
        Object in22;
        File blocks;
        File textures;
        CONFIG_DIR = FMLPaths.CONFIGDIR.get().resolve("solarflux").toFile();
        File solarflux = CONFIG_DIR;
        if (!solarflux.isDirectory()) {
            solarflux.mkdirs();
        }
        new File(solarflux, "compat").mkdirs();
        int[] generations = new int[]{1, 8, 32, 128, 512, 2048, 8192, 32768};
        int[] transfers = new int[]{8, 64, 256, 1024, 4096, 16348, 65536, 262144};
        int[] capacities = new int[]{25000, 125000, 425000, 2000000, 8000000, 32000000, 64000000, 128000000};
        ConfigFile cfgs = new ConfigFile(new File(solarflux, "main.hlc"));
        cfgs.setComment("Main configuration file for Solar Flux Reborn!\nTo implement custom panels, look for the custom_panels.js file!");
        ConfigEntryCategory spc = cfgs.getCategory("Solar Panels");
        LOOSE_ENERGY = spc.getFloatEntry("Pickup Energy Loss", 5.0f, 0.0f, 100.0f).setDescription("How much energy (percent) will get lost while picking up the solar panel?").getValue().floatValue();
        for (int i = 0; i < CORE_PANELS.length; ++i) {
            ConfigEntryCategory spsc = spc.getCategory("Solar Panel " + (i + 1));
            long gen = spsc.getLongEntry("Generation Rate", (long)generations[i], 1L, Long.MAX_VALUE).getValue();
            long transfer = spsc.getLongEntry("Transfer Rate", (long)transfers[i], 1L, Long.MAX_VALUE).getValue();
            long capacity = spsc.getLongEntry("Capacity", (long)capacities[i], 1L, Long.MAX_VALUE).getValue();
            SolarPanels.CORE_PANELS[i] = SolarPanel.builder().name(Integer.toString(i + 1)).generation(gen).transfer(transfer).capacity(capacity).buildAndRegister();
        }
        ConfigEntryCategory main = cfgs.getCategory("Main");
        RAIN_MULTIPLIER = main.getFloatEntry("Rain Multiplier", 0.6f, 0.0f, 1.0f).setDescription("How much energy should be generated when it is raining? 0 - nothing, 1 - full power.").getValue().floatValue();
        THUNDER_MULTIPLIER = main.getFloatEntry("Thunder Multiplier", 0.4f, 0.0f, 1.0f).setDescription("How much energy should be generated when it is thundering? 0 - nothing, 1 - full power.").getValue().floatValue();
        if (cfgs.hasChanged()) {
            cfgs.save();
        }
        if (!(textures = new File(solarflux, "textures")).isDirectory()) {
            textures.mkdirs();
            blocks = new File(textures, "blocks");
            if (!blocks.isDirectory()) {
                int r;
                Throwable throwable2;
                Throwable capacity;
                FileOutputStream out;
                blocks.mkdirs();
                byte[] buf2 = new byte[768];
                try {
                    out = new FileOutputStream(new File(blocks, "example_base.png"));
                    capacity = null;
                    try {
                        in22 = SolarFlux.class.getResourceAsStream("/assets/solarflux/textures/blocks/sp_example_base.png");
                        throwable2 = null;
                        try {
                            while ((r = ((InputStream)in22).read(buf2)) > 0) {
                                out.write(buf2, 0, r);
                            }
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (in22 != null) {
                                if (throwable2 != null) {
                                    try {
                                        ((InputStream)in22).close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                } else {
                                    ((InputStream)in22).close();
                                }
                            }
                        }
                    }
                    catch (Throwable in22) {
                        capacity = in22;
                        throw in22;
                    }
                    finally {
                        if (out != null) {
                            if (capacity != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable in22) {
                                    capacity.addSuppressed(in22);
                                }
                            } else {
                                out.close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                try {
                    out = new FileOutputStream(new File(blocks, "example_top.png"));
                    capacity = null;
                    try {
                        in22 = SolarFlux.class.getResourceAsStream("/assets/solarflux/textures/blocks/sp_example_top.png");
                        throwable2 = null;
                        try {
                            while ((r = ((InputStream)in22).read(buf2)) > 0) {
                                out.write(buf2, 0, r);
                            }
                        }
                        catch (Throwable throwable5) {
                            throwable2 = throwable5;
                            throw throwable5;
                        }
                        finally {
                            if (in22 != null) {
                                if (throwable2 != null) {
                                    try {
                                        ((InputStream)in22).close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable2.addSuppressed(throwable6);
                                    }
                                } else {
                                    ((InputStream)in22).close();
                                }
                            }
                        }
                    }
                    catch (Throwable in3) {
                        capacity = in3;
                        throw in3;
                    }
                    finally {
                        if (out != null) {
                            if (capacity != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable in3) {
                                    capacity.addSuppressed(in3);
                                }
                            } else {
                                out.close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!(items = new File(textures, "items")).isDirectory()) {
                items.mkdirs();
                buf = new byte[768];
                try {
                    FileOutputStream out = new FileOutputStream(new File(items, "example.png"));
                    in22 = null;
                    try {
                        in5 = SolarFlux.class.getResourceAsStream("/assets/solarflux/textures/items/_example.png");
                        throwable = null;
                        try {
                            int r;
                            while ((r = in5.read(buf)) > 0) {
                                out.write(buf, 0, r);
                            }
                        }
                        catch (Throwable throwable7) {
                            throwable = throwable7;
                            throw throwable7;
                        }
                        finally {
                            if (in5 != null) {
                                if (throwable != null) {
                                    try {
                                        in5.close();
                                    }
                                    catch (Throwable throwable8) {
                                        throwable.addSuppressed(throwable8);
                                    }
                                } else {
                                    in5.close();
                                }
                            }
                        }
                    }
                    catch (Throwable in4) {
                        in22 = in4;
                        throw in4;
                    }
                    finally {
                        if (out != null) {
                            if (in22 != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable in4) {
                                    ((Throwable)in22).addSuppressed(in4);
                                }
                            } else {
                                out.close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            blocks = new File(textures, "blocks");
            if (!blocks.isDirectory()) {
                blocks.mkdirs();
                SolarPanels.move(textures, blocks);
            }
            if (!(items = new File(textures, "items")).isDirectory()) {
                items.mkdirs();
                buf = new byte[768];
                try {
                    FileOutputStream out = new FileOutputStream(new File(items, "example.png"));
                    in22 = null;
                    try {
                        in5 = SolarFlux.class.getResourceAsStream("/assets/solarflux/textures/items/_example.png");
                        throwable = null;
                        try {
                            int r;
                            while ((r = in5.read(buf)) > 0) {
                                out.write(buf, 0, r);
                            }
                        }
                        catch (Throwable throwable9) {
                            throwable = throwable9;
                            throw throwable9;
                        }
                        finally {
                            if (in5 != null) {
                                if (throwable != null) {
                                    try {
                                        in5.close();
                                    }
                                    catch (Throwable throwable10) {
                                        throwable.addSuppressed(throwable10);
                                    }
                                } else {
                                    in5.close();
                                }
                            }
                        }
                    }
                    catch (Throwable in5) {
                        in22 = in5;
                        throw in5;
                    }
                    finally {
                        if (out != null) {
                            if (in22 != null) {
                                try {
                                    out.close();
                                }
                                catch (Throwable in5) {
                                    ((Throwable)in22).addSuppressed(in5);
                                }
                            } else {
                                out.close();
                            }
                        }
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (!(custom_panels = new File(solarflux, "custom_panels.js")).isFile()) {
            try (FileOutputStream fos = new FileOutputStream(custom_panels);
                 InputStream in6 = SolarFlux.class.getResourceAsStream("/__custom_panels.js");){
                int r;
                byte[] buf3 = new byte[768];
                while ((r = in6.read(buf3)) > 0) {
                    fos.write(buf3, 0, r);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            SolarScriptEngine engine = new SolarScriptEngine(Files.readAllLines(custom_panels.toPath(), StandardCharsets.UTF_8).stream());
            engine.callFunction("init", new Object[0]);
        }
        catch (IOException | ReflectiveOperationException | ScriptException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setupPanel(ConfigEntryCategory cat, String name, AtomicLong generation, AtomicLong transfer, AtomicLong capacity) {
        ConfigEntryCategory spsc = cat.getCategory("Solar Panel " + name);
        generation.set(spsc.getLongEntry("Generation Rate", generation.get(), 1L, Long.MAX_VALUE).getValue());
        transfer.set(spsc.getLongEntry("Transfer Rate", transfer.get(), 1L, Long.MAX_VALUE).getValue());
        capacity.set(spsc.getLongEntry("Capacity", capacity.get(), 1L, Long.MAX_VALUE).getValue());
    }

    public static long[] setupPanel(ConfigEntryCategory cat, String name, long generation, long transfer, long capacity) {
        long[] out = new long[3];
        ConfigEntryCategory spsc = cat.getCategory("Solar Panel " + name);
        out[0] = spsc.getLongEntry("Generation Rate", generation, 1L, Long.MAX_VALUE).getValue();
        out[1] = spsc.getLongEntry("Transfer Rate", transfer, 1L, Long.MAX_VALUE).getValue();
        out[2] = spsc.getLongEntry("Capacity", capacity, 1L, Long.MAX_VALUE).getValue();
        return out;
    }

    private static void move(File dir, File to) {
        if (dir.isDirectory() && to.isDirectory() && !dir.getAbsolutePath().startsWith(to.getAbsolutePath())) {
            for (File f : dir.listFiles()) {
                if (f.getAbsolutePath().startsWith(to.getAbsolutePath())) continue;
                if (f.isFile()) {
                    f.renameTo(new File(to, f.getName()));
                    continue;
                }
                if (!f.isDirectory()) continue;
                File nd = new File(to, f.getName());
                if (!nd.isDirectory()) {
                    nd.mkdirs();
                }
                SolarPanels.move(f, nd);
                f.delete();
            }
        }
    }

    public static void refreshConfigs() {
        ConfigFile panels = new ConfigFile(new File(CONFIG_DIR, "panels.hlc"));
        SolarPanels.listPanels().forEach(i -> {
            ConfigEntryCategory cat = i.isCustom ? panels.getCategory("Solar Flux: Custom") : (i.getCompatMod() == null ? panels.getCategory("Solar Flux") : panels.getCategory(ModList.get().getMods().stream().filter(m -> m.getModId().equals(i.getCompatMod())).findFirst().map(ModInfo::getDisplayName).orElse("Unknown")));
            i.configureBase(cat.getCategory(i.name));
        });
        if (panels.hasChanged()) {
            panels.save();
        }
    }

    public static void refreshRecipes() {
        ConfigFile recipes = new ConfigFile(new File(CONFIG_DIR, "recipes.hlc"));
        ConfigEntryCategory cat = recipes.getCategory("recipes").setDescription("List of all the recipes that Solar Flux adds.\nDefaulted to true, but you may disable any of the recipes listed.\nAfter you're done changing, you may apply the code right away, using /reload command");
        RECIPE_KEYS.forEach(recipe -> {
            boolean enabled = cat.getBooleanEntry(recipe.toString(), true).getValue();
            if (enabled) {
                ENABLED_RECIPES.add((ResourceLocation)recipe);
            }
        });
        recipes.save();
    }

    public static boolean isRecipeActive(ResourceLocation id) {
        return ENABLED_RECIPES.contains(id);
    }

    public static void indexRecipes(ResourceLocation ... ids) {
        RECIPE_KEYS.addAll(Arrays.asList(ids));
    }

    public static Ingredient getGeneratingSolars(long generation) {
        return Ingredient.func_234819_a_(SolarPanels.listPanels().filter(sp -> sp.delegateData.generation == generation).map(SolarPanel::getBlock).map(ItemStack::new));
    }

    public static Ingredient getGeneratingSolars(SolarPanel baseGeneration) {
        return SolarPanels.getGeneratingSolars(baseGeneration.delegateData.generation);
    }

    static {
        RAIN_MULTIPLIER = 0.6f;
        THUNDER_MULTIPLIER = 0.4f;
        CORE_PANELS = new SolarPanel[8];
        RECIPE_KEYS = new ArrayList<ResourceLocation>();
        ENABLED_RECIPES = new ArrayList<ResourceLocation>();
    }
}

