/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.items;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.zeith.hammerlib.annotations.RegistryName;
import org.zeith.hammerlib.annotations.SimplyRegister;
import org.zeith.hammerlib.api.inv.SimpleInventory;
import org.zeith.solarflux.block.SolarPanelTile;
import org.zeith.solarflux.items.ItemTraversalUpgrade;
import org.zeith.solarflux.items.UpgradeItem;
import org.zeith.solarflux.util.BlockPosFace;

@SimplyRegister
public class ItemBlockChargingUpgrade
extends UpgradeItem {
    @RegistryName(value="block_charging_upgrade")
    public static final ItemBlockChargingUpgrade BLOCK_CHARGING_UPGRADE = new ItemBlockChargingUpgrade();

    public ItemBlockChargingUpgrade() {
        super(1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (this.func_77636_d(stack)) {
            CompoundNBT nbt = stack.func_77978_p();
            if (nbt.func_150297_b("Dim", 8)) {
                tooltip.add((ITextComponent)new StringTextComponent("Dimension: " + nbt.func_74779_i("Dim")));
            }
            tooltip.add((ITextComponent)new StringTextComponent("Facing: " + Direction.values()[nbt.func_74771_c("Face")]));
            BlockPos pos = BlockPos.func_218283_e((long)nbt.func_74763_f("Pos"));
            tooltip.add((ITextComponent)new StringTextComponent("X: " + pos.func_177958_n() + ", Y: " + pos.func_177956_o() + ", Z: " + pos.func_177952_p()));
        }
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        TileEntity tile = context.func_195991_k().func_175625_s(context.func_195995_a());
        return tile != null ? tile.getCapability(CapabilityEnergy.ENERGY, context.func_196000_l()).filter(IEnergyStorage::canReceive).map(estorage -> {
            ItemStack held = context.func_195996_i();
            CompoundNBT nbt = held.func_77978_p();
            if (nbt == null) {
                nbt = new CompoundNBT();
                held.func_77982_d(nbt);
            }
            nbt.func_74778_a("Dim", context.func_195991_k().func_234923_W_().func_240901_a_().toString());
            nbt.func_74772_a("Pos", context.func_195995_a().func_218275_a());
            nbt.func_74774_a("Face", (byte)context.func_196000_l().ordinal());
            estorage = null;
            context.func_195991_k().func_184133_a(null, context.func_195995_a(), SoundEvents.field_187802_ec, SoundCategory.PLAYERS, 0.25f, 1.8f);
            return ActionResultType.SUCCESS;
        }).orElse(ActionResultType.FAIL) : ActionResultType.FAIL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_150297_b("Pos", 4) && stack.func_77978_p().func_150297_b("Face", 1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canInstall(SolarPanelTile tile, ItemStack stack, SimpleInventory upgradeInv) {
        BlockPos blockPos;
        if (!stack.func_77942_o()) return false;
        if (!stack.func_77978_p().func_150297_b("Pos", 4)) return false;
        if (!stack.func_77978_p().func_150297_b("Face", 1)) return false;
        if (stack.func_77978_p().func_150297_b("Dim", 8)) {
            if (!tile.func_145831_w().func_234923_W_().func_240901_a_().toString().equals(stack.func_77978_p().func_74779_i("Dim"))) return false;
        }
        BlockPos pos = BlockPos.func_218283_e((long)stack.func_77978_p().func_74763_f("Pos"));
        if (!(tile.func_174877_v().func_177951_i((Vector3i)blockPos) <= 256.0)) return false;
        TileEntity t = tile.func_145831_w().func_175625_s(pos);
        if (t == null) return false;
        if (!t.getCapability(CapabilityEnergy.ENERGY, Direction.values()[stack.func_77978_p().func_74771_c("Face")]).isPresent()) return false;
        return true;
    }

    @Override
    public void update(SolarPanelTile tile, ItemStack stack, int amount) {
        CompoundNBT nbt = stack.func_77978_p();
        if (tile.func_145831_w().func_72820_D() % 20L == 0L) {
            double d;
            BlockPos pos = BlockPos.func_218283_e((long)nbt.func_74763_f("Pos"));
            double d2 = tile.func_174877_v().func_177951_i((Vector3i)pos);
            if (d <= 256.0) {
                d2 /= 256.0;
                tile.traversal.clear();
                if (tile.getUpgrades(ItemTraversalUpgrade.TRAVERSAL_UPGRADE) > 0) {
                    ItemTraversalUpgrade.cache.clear();
                    ItemTraversalUpgrade.cache.add(pos);
                    ItemTraversalUpgrade.findMachines(tile, ItemTraversalUpgrade.cache, tile.traversal);
                }
                tile.traversal.add(new BlockPosFace(pos, Direction.values()[nbt.func_74771_c("Face")], (float)(1.0 - d2)));
            }
        }
    }
}

