/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.compat.de;

import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.draconicevolution.api.crafting.FusionRecipe;
import com.brandon3055.draconicevolution.init.DEContent;
import java.io.File;
import java.util.Arrays;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import org.zeith.hammerlib.core.adapter.recipe.ShapedRecipeBuilder;
import org.zeith.hammerlib.event.recipe.RegisterRecipesEvent;
import org.zeith.hammerlib.util.cfg.ConfigFile;
import org.zeith.hammerlib.util.cfg.entries.ConfigEntryCategory;
import org.zeith.solarflux.compat.ISFCompat;
import org.zeith.solarflux.compat.SFCompat;
import org.zeith.solarflux.panels.SolarPanel;
import org.zeith.solarflux.panels.SolarPanels;

@SFCompat(value="draconicevolution")
public class DraconicEvoCompat
implements ISFCompat {
    public static final ResourceLocation WYVERN_PANEL = new ResourceLocation("solarflux", "wyvern_panel");
    public static final ResourceLocation DRACONIC_PANEL = new ResourceLocation("solarflux", "draconic_panel");
    public static final ResourceLocation CHAOTIC_PANEL = new ResourceLocation("solarflux", "chaotic_panel");
    private SolarPanel wyvernPanel;
    private SolarPanel draconicPanel;
    private SolarPanel chaoticPanel;
    public boolean enabled = true;
    private long[] wspCfg = new long[]{65536L, 512000L, 256000000L};
    private long[] drspCfg = new long[]{262144L, 1024000L, 512000000L};
    private long[] chspCfg = new long[]{524288L, 4096000L, 2048000000L};
    private ConfigFile cfg;

    public DraconicEvoCompat() {
        SolarPanels.indexRecipes(WYVERN_PANEL, DRACONIC_PANEL, CHAOTIC_PANEL);
    }

    @Override
    public void setupConfigFile(File file) {
        this.cfg = new ConfigFile(file);
        ConfigEntryCategory general = this.cfg.getCategory("General");
        this.enabled = general.getBooleanEntry("Enabled", true).getValue();
        ConfigEntryCategory solar_panels = this.cfg.getCategory("Solar Panels");
        this.wspCfg = SolarPanels.setupPanel(solar_panels, "Wyvern", this.wspCfg[0], this.wspCfg[1], this.wspCfg[2]);
        this.drspCfg = SolarPanels.setupPanel(solar_panels, "Draconic", this.drspCfg[0], this.drspCfg[1], this.drspCfg[2]);
        this.chspCfg = SolarPanels.setupPanel(solar_panels, "Chaotic", this.chspCfg[0], this.chspCfg[1], this.chspCfg[2]);
        if (this.cfg.hasChanged()) {
            this.cfg.save();
        }
    }

    @Override
    public void registerPanels() {
        if (!this.enabled) {
            return;
        }
        this.wyvernPanel = SolarPanel.builder().name("de.wyvern").generation(this.wspCfg[0]).transfer(this.wspCfg[1]).capacity(this.wspCfg[2]).buildAndRegister();
        this.draconicPanel = SolarPanel.builder().name("de.draconic").generation(this.drspCfg[0]).transfer(this.drspCfg[1]).capacity(this.drspCfg[2]).buildAndRegister();
        this.chaoticPanel = SolarPanel.builder().name("de.chaotic").generation(this.chspCfg[0]).transfer(this.chspCfg[1]).capacity(this.chspCfg[2]).buildAndRegister();
    }

    @Override
    public void reloadRecipes(RegisterRecipesEvent e) {
        if (!this.enabled) {
            return;
        }
        ((ShapedRecipeBuilder)((ShapedRecipeBuilder)e.shaped().id(WYVERN_PANEL)).result(new ItemStack((IItemProvider)this.wyvernPanel, 2))).shape(new String[]{"sps", "pcp", "sps"}).map('s', (Object)SolarPanels.getGeneratingSolars(SolarPanels.CORE_PANELS[7].getPanelData().generation)).map('p', (Object)DEContent.energy_core_wyvern).map('c', (Object)DEContent.core_wyvern).registerIf(SolarPanels::isRecipeActive);
        ((ShapedRecipeBuilder)((ShapedRecipeBuilder)e.shaped().id(DRACONIC_PANEL)).result(new ItemStack((IItemProvider)this.draconicPanel, 2))).shape(new String[]{"sps", "pcp", "sps"}).map('s', (Object)SolarPanels.getGeneratingSolars(this.wyvernPanel.getPanelData().generation)).map('p', (Object)DEContent.energy_core_draconic).map('c', (Object)DEContent.core_awakened).registerIf(SolarPanels::isRecipeActive);
        if (SolarPanels.isRecipeActive(CHAOTIC_PANEL)) {
            e.add((IRecipe)new FusionRecipe(CHAOTIC_PANEL, new ItemStack((IItemProvider)this.chaoticPanel, 2), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{DEContent.core_chaotic}), 256000000L, TechLevel.CHAOTIC, Arrays.asList(new FusionRecipe.FusionIngredient(SolarPanels.getGeneratingSolars(this.draconicPanel.getPanelData().generation), true), new FusionRecipe.FusionIngredient(SolarPanels.getGeneratingSolars(this.draconicPanel.getPanelData().generation), true), new FusionRecipe.FusionIngredient(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{DEContent.core_awakened}), true), new FusionRecipe.FusionIngredient(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{DEContent.core_awakened}), true), new FusionRecipe.FusionIngredient(SolarPanels.getGeneratingSolars(this.draconicPanel.getPanelData().generation), true), new FusionRecipe.FusionIngredient(SolarPanels.getGeneratingSolars(this.draconicPanel.getPanelData().generation), true), new FusionRecipe.FusionIngredient(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{DEContent.core_awakened}), true), new FusionRecipe.FusionIngredient(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{DEContent.core_awakened}), true))));
        }
    }
}

