/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.solarflux.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import org.zeith.hammerlib.api.inv.SimpleInventory;
import org.zeith.hammerlib.api.tiles.IContainerTile;
import org.zeith.hammerlib.tiles.TileSyncableTickable;
import org.zeith.solarflux.attribute.SimpleAttributeProperty;
import org.zeith.solarflux.block.SolarPanelBlock;
import org.zeith.solarflux.container.SolarPanelContainer;
import org.zeith.solarflux.items.UpgradeItem;
import org.zeith.solarflux.panels.SolarPanel;
import org.zeith.solarflux.panels.SolarPanelInstance;
import org.zeith.solarflux.panels.SolarPanels;
import org.zeith.solarflux.util.BlockPosFace;

public class SolarPanelTile
extends TileSyncableTickable
implements IContainerTile,
IEnergyStorage {
    public long energy;
    public long currentGeneration;
    public float sunIntensity;
    private SolarPanel delegate;
    private SolarPanelInstance instance;
    public final SimpleInventory upgradeInventory = new SimpleInventory(5);
    public final SimpleInventory chargeInventory = new SimpleInventory(1);
    public final List<BlockPosFace> traversal = new ArrayList<BlockPosFace>();
    public final SimpleAttributeProperty generation = new SimpleAttributeProperty();
    public final SimpleAttributeProperty transfer = new SimpleAttributeProperty();
    public final SimpleAttributeProperty capacity = new SimpleAttributeProperty();
    List<ResourceLocation> tickedUpgrades = new ArrayList<ResourceLocation>();
    int effCacheTime;
    float effCache;
    public boolean cache$seeSky;
    public byte cache$seeSkyTimer;
    public static final ModelProperty<World> WORLD_PROP = new ModelProperty();
    public static final ModelProperty<BlockPos> POS_PROP = new ModelProperty();
    LazyOptional chargeableItems;
    LazyOptional energyStorageTile;
    int voxelTimer = 0;
    VoxelShape shape;

    public SolarPanelTile() {
        super(SolarPanels.SOLAR_PANEL_TYPE);
    }

    public Container openContainer(PlayerEntity player, int windowId) {
        return new SolarPanelContainer(windowId, player.field_71071_by, this);
    }

    public int getUpgrades(Item type) {
        int c = 0;
        for (int i = 0; i < this.upgradeInventory.getSlots(); ++i) {
            ItemStack stack = this.upgradeInventory.getStackInSlot(i);
            if (stack.func_190926_b() || stack.func_77973_b() != type) continue;
            c += stack.func_190916_E();
        }
        return c;
    }

    public boolean isSameLevel(SolarPanelTile other) {
        if (other == null) {
            return false;
        }
        if (other.getDelegate() == null || this.getDelegate() == null) {
            return false;
        }
        return Objects.equals(other.getDelegate(), this.getDelegate());
    }

    public SolarPanel getDelegate() {
        if (this.delegate == null) {
            Block blk = this.func_195044_w().func_177230_c();
            this.delegate = blk instanceof SolarPanelBlock ? ((SolarPanelBlock)blk).panel : SolarPanels.CORE_PANELS[0];
        }
        return this.delegate;
    }

    public SolarPanelInstance getInstance() {
        if (this.instance == null || this.instance.getDelegate() != this.getDelegate()) {
            this.instance = this.getDelegate().createInstance(this);
        }
        return this.instance;
    }

    public void tickUpgrades() {
        ItemStack stack;
        int i;
        this.generation.clearAttributes();
        this.transfer.clearAttributes();
        this.capacity.clearAttributes();
        for (i = 0; i < this.upgradeInventory.getSlots(); ++i) {
            stack = this.upgradeInventory.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof UpgradeItem && ((UpgradeItem)stack.func_77973_b()).canStayInPanel(this, stack, this.upgradeInventory)) {
                ResourceLocation id = stack.func_77973_b().getRegistryName();
                if (this.tickedUpgrades.contains(id)) continue;
                UpgradeItem iu = (UpgradeItem)stack.func_77973_b();
                iu.update(this, stack, this.getUpgrades(iu));
                this.tickedUpgrades.add(id);
                continue;
            }
            ItemStack s = this.upgradeInventory.getStackInSlot(i);
            s.func_77946_l();
            this.upgradeInventory.setStackInSlot(i, ItemStack.field_190927_a);
            if (this.field_145850_b.field_72995_K) continue;
            this.field_145850_b.func_217376_c((Entity)new ItemEntity(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, stack));
        }
        if (this.energy > 0L && this.getInstance() != null) {
            for (i = 0; i < this.chargeInventory.getSlots(); ++i) {
                stack = this.chargeInventory.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                stack.getCapability(CapabilityEnergy.ENERGY, null).filter(e -> e.getEnergyStored() < e.getMaxEnergyStored()).ifPresent(e -> {
                    this.transfer.setBaseValue(this.getInstance().transfer);
                    int transfer = this.transfer.getValueI();
                    this.energy -= (long)e.receiveEnergy(Math.min(this.getEnergyStored(), transfer), false);
                });
            }
        }
        this.tickedUpgrades.clear();
    }

    public void update() {
        Block blk;
        if (this.voxelTimer > 0) {
            --this.voxelTimer;
        }
        if (!((blk = this.func_195044_w().func_177230_c()) instanceof SolarPanelBlock)) {
            return;
        }
        this.delegate = ((SolarPanelBlock)blk).panel;
        if (this.cache$seeSkyTimer > 0) {
            this.cache$seeSkyTimer = (byte)(this.cache$seeSkyTimer - 1);
        }
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.field_145850_b.func_82737_E() % 20L == 0L) {
            this.traversal.clear();
        }
        this.tickUpgrades();
        int gen = this.getGeneration();
        this.capacity.setBaseValue(this.getInstance().cap);
        this.energy += Math.min(this.capacity.getValueL() - this.energy, (long)gen);
        this.currentGeneration = gen;
        this.energy = Math.min(Math.max(this.energy, 0L), this.capacity.getValueL());
        for (Direction hor : Direction.values()) {
            TileEntity tile;
            if (hor.func_176740_k() == Direction.Axis.Y || !((tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(hor))) instanceof SolarPanelTile)) continue;
            this.autoBalanceEnergy((SolarPanelTile)tile);
        }
        this.transfer.setBaseValue(this.getInstance().transfer);
        int transfer = this.transfer.getValueI();
        for (Direction hor : Direction.values()) {
            TileEntity tile;
            if (hor == Direction.UP || (tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(hor))) == null) continue;
            tile.getCapability(CapabilityEnergy.ENERGY, hor.func_176734_d()).ifPresent(storage -> {
                if (storage.canReceive()) {
                    this.energy -= (long)storage.receiveEnergy(Math.min(this.getEnergyStored(), transfer), false);
                }
            });
        }
        if (!this.traversal.isEmpty()) {
            for (BlockPosFace traverse : this.traversal) {
                TileEntity tile = this.field_145850_b.func_175625_s(traverse.pos);
                if (this.energy < 1L) break;
                if (tile == null) continue;
                tile.getCapability(CapabilityEnergy.ENERGY, traverse.face).ifPresent(storage -> {
                    if (storage.canReceive()) {
                        this.energy -= (long)storage.receiveEnergy(Math.min(this.getEnergyStored(), Math.round((float)transfer * traverse.rate)), false);
                    }
                });
            }
        }
        this.field_145850_b.func_175666_e(this.field_174879_c, this.func_195044_w().func_177230_c());
        if (this.effCacheTime > 0) {
            --this.effCacheTime;
        }
    }

    public int getGeneration() {
        float eff = this.effCache;
        if (this.effCacheTime <= 0) {
            eff = this.getInstance().computeSunIntensity(this);
            float raining = this.field_145850_b.func_72867_j(1.0f);
            raining = raining > 0.2f ? (raining - 0.2f) / 0.8f : 0.0f;
            raining = (float)Math.sin((double)raining * Math.PI / 2.0);
            raining = 1.0f - raining * (1.0f - SolarPanels.RAIN_MULTIPLIER);
            float thundering = this.field_145850_b.func_72819_i(1.0f);
            thundering = thundering > 0.75f ? (thundering - 0.75f) / 0.25f : 0.0f;
            thundering = (float)Math.sin((double)thundering * Math.PI / 2.0);
            thundering = 1.0f - thundering * (1.0f - SolarPanels.THUNDER_MULTIPLIER);
            this.effCache = eff *= raining * thundering;
            this.effCacheTime = 2;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.sunIntensity = eff;
        }
        float gen = (float)this.getInstance().gen * eff;
        this.generation.setBaseValue(gen);
        return this.generation.getValueI();
    }

    public int autoBalanceEnergy(SolarPanelTile solar) {
        int delta = this.getEnergyStored() - solar.getEnergyStored();
        if (delta < 0) {
            return solar.autoBalanceEnergy(this);
        }
        if (delta > 0) {
            return this.extractEnergy(solar.receiveEnergyInternal(this.extractEnergy(solar.receiveEnergyInternal(delta / 2, true), true), false), false);
        }
        return 0;
    }

    public boolean doesSeeSky() {
        if (this.cache$seeSkyTimer < 1) {
            this.cache$seeSkyTimer = (byte)20;
            this.cache$seeSky = this.field_145850_b != null && this.field_145850_b.func_226658_a_(LightType.SKY, this.field_174879_c) > 0 && this.field_174879_c != null && this.field_145850_b.func_226660_f_(this.field_174879_c);
        }
        return this.cache$seeSky;
    }

    public IModelData getModelData() {
        return new ModelDataMap.Builder().withInitial(WORLD_PROP, (Object)this.field_145850_b).withInitial(POS_PROP, (Object)this.field_174879_c).build();
    }

    public CompoundNBT writeNBT(CompoundNBT nbt) {
        this.upgradeInventory.writeToNBT(nbt, "Upgrades");
        this.chargeInventory.writeToNBT(nbt, "Chargeable");
        nbt.func_74772_a("Energy", this.energy);
        return nbt;
    }

    public void readNBT(CompoundNBT nbt) {
        this.upgradeInventory.readFromNBT(nbt, "Upgrades");
        this.chargeInventory.readFromNBT(nbt, "Chargeable");
        this.energy = nbt.func_74763_f("Energy");
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.chargeableItems == null) {
                this.chargeableItems = LazyOptional.of(() -> this.chargeInventory);
            }
            return this.chargeableItems.cast();
        }
        if (cap == CapabilityEnergy.ENERGY) {
            if (this.energyStorageTile == null) {
                this.energyStorageTile = LazyOptional.of(() -> this);
            }
            return this.energyStorageTile.cast();
        }
        return super.getCapability(cap, side);
    }

    public void resetVoxelShape() {
        this.shape = null;
    }

    public VoxelShape getShape(SolarPanelBlock block) {
        if (this.shape == null || this.voxelTimer <= 0) {
            this.shape = block.recalcShape((IBlockReader)this.field_145850_b, this.field_174879_c);
            this.voxelTimer = 20;
        }
        return this.shape;
    }

    public ITextComponent getDisplayName() {
        return new TranslationTextComponent(this.func_195044_w().func_177230_c().func_149739_a());
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        this.transfer.setBaseValue(this.getInstance().transfer);
        int transfer = this.transfer.getValueI();
        int energyExtracted = Math.min(this.getEnergyStored(), Math.min(transfer, maxExtract));
        if (!simulate) {
            this.energy -= (long)energyExtracted;
        }
        return energyExtracted;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int receiveEnergyInternal(int maxReceive, boolean simulate) {
        this.transfer.setBaseValue(this.getInstance().transfer);
        int transfer = this.transfer.getValueI();
        this.capacity.setBaseValue(this.getInstance().cap);
        long cap = this.capacity.getValueL();
        int energyReceived = Math.min((int)Math.min(cap - this.energy, Integer.MAX_VALUE), Math.min(transfer, maxReceive));
        if (!simulate) {
            this.energy += (long)energyReceived;
        }
        return energyReceived;
    }

    public int getEnergyStored() {
        return (int)Math.min(this.energy, Integer.MAX_VALUE);
    }

    public int getMaxEnergyStored() {
        return (int)Math.min(this.getInstance().cap, Integer.MAX_VALUE);
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return false;
    }

    public ItemStack generateItem(IItemProvider item) {
        ItemStack stack = new ItemStack(item);
        stack.func_77982_d(new CompoundNBT());
        stack.func_77978_p().func_74772_a("Energy", this.energy - Math.round((double)this.energy * SolarPanels.LOOSE_ENERGY / 100.0));
        this.upgradeInventory.writeToNBT(stack.func_77978_p(), "Upgrades");
        this.chargeInventory.writeToNBT(stack.func_77978_p(), "Chargeable");
        return stack;
    }

    public void loadFromItem(ItemStack stack) {
        if (stack.func_77942_o()) {
            this.energy = stack.func_77978_p().func_74763_f("Energy");
            this.upgradeInventory.readFromNBT(stack.func_77978_p(), "Upgrades");
            this.chargeInventory.readFromNBT(stack.func_77978_p(), "Chargeable");
        }
    }

    public void setDelegate(SolarPanel delegate) {
        this.delegate = delegate;
    }
}

