/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.block;

import com.supermartijn642.core.block.BaseTileEntity;
import java.util.List;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BaseBlock
extends Block {
    private final boolean saveTileData;

    public BaseBlock(String registryName, boolean saveTileData, AbstractBlock.Properties properties) {
        super(properties);
        this.setRegistryName(registryName);
        this.saveTileData = saveTileData;
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (!this.saveTileData) {
            return;
        }
        CompoundNBT tag = stack.func_77978_p();
        CompoundNBT compoundNBT = tag == null ? null : (tag = tag.func_74764_b("tileData") ? tag.func_74775_l("tileData") : null);
        if (tag == null || tag.isEmpty()) {
            return;
        }
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile instanceof BaseTileEntity) {
            ((BaseTileEntity)tile).readData(tag);
        }
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        List items = super.func_220076_a(state, builder);
        if (!this.saveTileData) {
            return items;
        }
        TileEntity tile = (TileEntity)builder.func_216019_b(LootParameters.field_216288_h);
        if (!(tile instanceof BaseTileEntity)) {
            return items;
        }
        CompoundNBT tileTag = ((BaseTileEntity)tile).writeItemStackData();
        if (tileTag == null || tileTag.isEmpty()) {
            return items;
        }
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a("tileData", (INBT)tileTag);
        for (ItemStack stack : items) {
            if (!(stack.func_77973_b() instanceof BlockItem) || ((BlockItem)stack.func_77973_b()).func_179223_d() != this) continue;
            stack.func_77982_d(tag);
        }
        return items;
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        ItemStack stack = super.getPickBlock(state, target, world, pos, player);
        if (!this.saveTileData) {
            return stack;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof BaseTileEntity)) {
            return stack;
        }
        CompoundNBT tileTag = ((BaseTileEntity)tile).writeItemStackData();
        if (tileTag == null || tileTag.isEmpty()) {
            return stack;
        }
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a("tileData", (INBT)tileTag);
        if (stack.func_77973_b() instanceof BlockItem && ((BlockItem)stack.func_77973_b()).func_179223_d() == this) {
            stack.func_77982_d(tag);
        }
        return stack;
    }
}

