/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.configlib;

import com.supermartijn642.configlib.ConfigSyncPacket;
import com.supermartijn642.configlib.ModConfig;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

@Mod(value="supermartijn642configlib")
public class ConfigLib {
    private static final List<ModConfig> CONFIGS = new ArrayList<ModConfig>();
    private static final Map<ModConfig.Type, List<ModConfig>> CONFIGS_PER_TYPE = new EnumMap<ModConfig.Type, List<ModConfig>>(ModConfig.Type.class);
    private static final Map<String, Map<ModConfig.Type, ModConfig>> CONFIGS_PER_MOD;
    private static final List<ModConfig> SYNCABLE_CONFIGS;
    private static final SimpleChannel CHANNEL;

    public ConfigLib() {
        CHANNEL.registerMessage(0, ConfigSyncPacket.class, ConfigSyncPacket::encode, ConfigSyncPacket::new, ConfigSyncPacket::handle);
    }

    protected static synchronized void addConfig(ModConfig config) {
        CONFIGS.add(config);
        CONFIGS_PER_MOD.putIfAbsent(config.getModid(), new EnumMap(ModConfig.Type.class));
        CONFIGS_PER_MOD.get(config.getModid()).put(config.getType(), config);
        CONFIGS_PER_TYPE.get((Object)config.getType()).add(config);
        if (config.getType() == ModConfig.Type.SERVER || config.getType() == ModConfig.Type.COMMON) {
            SYNCABLE_CONFIGS.add(config);
        }
    }

    protected static synchronized ModConfig getConfig(String modid, ModConfig.Type type) {
        Map<ModConfig.Type, ModConfig> configs = CONFIGS_PER_MOD.get(modid);
        if (configs != null) {
            return configs.get((Object)type);
        }
        return null;
    }

    protected static void clearSyncedValues() {
        for (ModConfig config : SYNCABLE_CONFIGS) {
            config.clearSyncedValues();
        }
    }

    static {
        for (ModConfig.Type type : ModConfig.Type.values()) {
            CONFIGS_PER_TYPE.put(type, new ArrayList());
        }
        CONFIGS_PER_MOD = new HashMap<String, Map<ModConfig.Type, ModConfig>>();
        SYNCABLE_CONFIGS = new ArrayList<ModConfig>();
        CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("supermartijn642configlib", "main"), () -> "1", "1"::equals, "1"::equals);
    }

    @Mod.EventBusSubscriber
    public static class ConfigEvents {
        @SubscribeEvent
        public static void onWorldLoad(WorldEvent.Load e) {
            if (e.getWorld().func_201670_d() || !(e.getWorld() instanceof World) || ((World)e.getWorld()).func_234923_W_() == World.field_234918_g_) {
                return;
            }
            for (ModConfig config : CONFIGS) {
                config.updateValues();
            }
        }

        @SubscribeEvent
        public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent e) {
            if (!e.getPlayer().field_70170_p.field_72995_K) {
                for (ModConfig config : SYNCABLE_CONFIGS) {
                    CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)e.getPlayer()), (Object)new ConfigSyncPacket(config));
                }
            }
        }
    }
}

