/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.entities;

import com.talhanation.smallships.Main;
import com.talhanation.smallships.config.SmallShipsConfig;
import com.talhanation.smallships.entities.AbstractInventoryBoat;
import com.talhanation.smallships.entities.TNBoatEntity;
import com.talhanation.smallships.network.MessagePaddleState;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class AbstractRowBoatEntity
extends AbstractInventoryBoat {
    private final float[] paddlePositions = new float[2];
    public float momentum;
    public float outOfControlTicks;
    public float deltaRotation;
    public boolean field_70128_L;
    private double waterLevel;
    public boolean leftInputDown;
    public boolean rightInputDown;
    public boolean forwardInputDown;
    public boolean backInputDown;
    private float boatGlide;
    private TNBoatEntity.Status status;
    private TNBoatEntity.Status previousStatus;
    public int passengerwaittime;
    public float passengerfaktor;

    public AbstractRowBoatEntity(EntityType<? extends AbstractRowBoatEntity> entityType, World worldIn) {
        super(entityType, worldIn);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
    }

    @Override
    public void func_70071_h_() {
        --this.passengerwaittime;
        if (this.func_184179_bs() != null && this.func_184179_bs() instanceof PlayerEntity && this.forwardInputDown && this.getBoatStatus().equals((Object)TNBoatEntity.Status.IN_WATER)) {
            this.Watersplash();
        }
        this.previousStatus = this.status;
        this.status = this.getBoatStatus();
        this.outOfControlTicks = this.status != TNBoatEntity.Status.UNDER_WATER && this.status != TNBoatEntity.Status.UNDER_FLOWING_WATER ? 0.0f : (this.outOfControlTicks += 1.0f);
        if (!this.field_70170_p.field_72995_K && this.outOfControlTicks >= 60.0f) {
            this.func_184226_ay();
        }
        if (this.getTimeSinceHit() > 0) {
            this.setTimeSinceHit(this.getTimeSinceHit() - 1);
        }
        super.func_70071_h_();
        this.tickLerp();
        if (this.func_184186_bw()) {
            if (this.func_184188_bt().isEmpty() || !(this.func_184188_bt().get(0) instanceof PlayerEntity)) {
                this.setPaddleState(false, false);
            }
            this.updateMotion();
            if (this.field_70170_p.field_72995_K) {
                this.controlBoat();
                Main.SIMPLE_CHANNEL.sendToServer((Object)new MessagePaddleState(this.getPaddleState(0), this.getPaddleState(1)));
            }
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        } else {
            this.func_213317_d(Vector3d.field_186680_a);
        }
        for (int i = 0; i <= 1; ++i) {
            if (this.getPaddleState(i)) {
                SoundEvent soundevent;
                if (!this.func_174814_R() && (double)(this.paddlePositions[i] % ((float)Math.PI * 2)) <= 0.7853981852531433 && ((double)this.paddlePositions[i] + (double)0.3926991f) % 6.2831854820251465 >= 0.7853981852531433 && (soundevent = this.getPaddleSound()) != null) {
                    Vector3d vector3d = this.func_70676_i(1.0f);
                    double d0 = i == 1 ? -vector3d.field_72449_c : vector3d.field_72449_c;
                    double d1 = i == 1 ? vector3d.field_72450_a : -vector3d.field_72450_a;
                    this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_() + d0, this.func_226278_cu_(), this.func_226281_cx_() + d1, soundevent, this.func_184176_by(), 1.0f, 0.8f + 0.4f * this.field_70146_Z.nextFloat());
                    this.field_70170_p.func_184148_a((PlayerEntity)null, this.func_226277_ct_() + d0, this.func_226278_cu_(), this.func_226281_cx_() + d1, soundevent, this.func_184176_by(), 1.0f, 0.2f + 0.4f * this.field_70146_Z.nextFloat());
                }
                this.paddlePositions[i] = (float)((double)this.paddlePositions[i] + (double)0.3926991f);
                continue;
            }
            this.paddlePositions[i] = 0.0f;
        }
        if (this.forwardInputDown && this.getBoatStatus().equals((Object)TNBoatEntity.Status.IN_WATER) && this.func_184179_bs() instanceof PlayerEntity && ((Boolean)SmallShipsConfig.PlaySwimmSound.get()).booleanValue()) {
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187549_bG, this.func_184176_by(), 0.05f, 0.8f + 0.4f * this.field_70146_Z.nextFloat());
        }
        this.func_145775_I();
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72314_b((double)0.2f, (double)-0.01f, (double)0.2f), EntityPredicates.func_200823_a((Entity)this));
        if (!list.isEmpty()) {
            boolean flag = !this.field_70170_p.field_72995_K && !(this.func_184179_bs() instanceof PlayerEntity);
            for (int j = 0; j < list.size(); ++j) {
                Entity entity = (Entity)list.get(j);
                if (entity.func_184196_w((Entity)this)) continue;
                if (flag && this.func_184188_bt().size() < 8 && !entity.func_184218_aH() && entity.func_213311_cf() < this.func_213311_cf() && entity instanceof LivingEntity && !(entity instanceof WaterMobEntity) && !(entity instanceof PlayerEntity)) {
                    if (this.passengerwaittime >= 0) continue;
                    entity.func_184220_m((Entity)this);
                    continue;
                }
                this.func_70108_f(entity);
            }
        }
    }

    public void tickLerp() {
    }

    @Override
    public void Watersplash() {
        super.Watersplash();
        Vector3d vector3d = this.func_70676_i(0.0f);
        float f0 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * 0.8f;
        float f1 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * 0.8f;
        float f2 = 2.5f - this.field_70146_Z.nextFloat() * 0.7f;
        for (int i = 0; i < 2; ++i) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_206864_X, this.func_226277_ct_() - vector3d.field_72450_a * (double)f2 + (double)f0, this.func_226278_cu_() - vector3d.field_72448_b + 0.5, this.func_226281_cx_() - vector3d.field_72449_c * (double)f2 + (double)f1, 0.0, 0.0, 0.0);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_206864_X, this.func_226277_ct_() - vector3d.field_72450_a * (double)f2 - (double)f0, this.func_226278_cu_() - vector3d.field_72448_b + 0.5, this.func_226281_cx_() - vector3d.field_72449_c * (double)f2 - (double)f1, 0.0, 0.0, 0.0);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218422_X, this.func_226277_ct_() - vector3d.field_72450_a * (double)f2 + (double)f0, this.func_226278_cu_() - vector3d.field_72448_b + 0.8, this.func_226281_cx_() - vector3d.field_72449_c * (double)f2 + (double)f1, 0.0, 0.0, 0.0);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218422_X, this.func_226277_ct_() - vector3d.field_72450_a * (double)f2 - (double)f0, this.func_226278_cu_() - vector3d.field_72448_b + 0.8, this.func_226281_cx_() - vector3d.field_72449_c * (double)f2 - (double)f1, 0.0, 0.0, 0.0);
        }
    }

    public TNBoatEntity.Status getBoatStatus() {
        TNBoatEntity.Status boatentity$status = this.getUnderwaterStatus();
        if (boatentity$status != null) {
            this.waterLevel = this.func_174813_aQ().field_72337_e;
            return boatentity$status;
        }
        if (this.checkInWater()) {
            return TNBoatEntity.Status.IN_WATER;
        }
        float f = this.getBoatGlide();
        if (f > 0.0f) {
            this.boatGlide = 0.0f;
            return TNBoatEntity.Status.ON_LAND;
        }
        return TNBoatEntity.Status.IN_AIR;
    }

    public void updateMotion() {
        double d0 = -0.03;
        double d1 = this.func_189652_ae() ? 0.0 : d0;
        double d2 = 0.0;
        double RowBoatTurnFactor = (Double)SmallShipsConfig.RowBoatTurnFactor.get();
        this.momentum = 1.0f;
        this.passengerfaktor = 0.0f;
        if (this.previousStatus == TNBoatEntity.Status.IN_AIR && this.status != TNBoatEntity.Status.IN_AIR && this.status != TNBoatEntity.Status.ON_LAND) {
            this.waterLevel = this.func_174813_aQ().field_72338_b + (double)this.func_213302_cg();
            this.func_70107_b(this.func_226277_ct_(), (double)(this.getWaterLevelAbove() - this.func_213302_cg()) + 0.101, this.func_226281_cx_());
            this.func_213317_d(this.func_213322_ci().func_216372_d(10.0, 0.0, 10.0));
            this.status = TNBoatEntity.Status.IN_WATER;
        } else {
            if (this.status == TNBoatEntity.Status.IN_WATER) {
                d2 = (this.waterLevel - this.func_174813_aQ().field_72338_b + 0.1) / (double)this.func_213302_cg();
                this.momentum = 0.9f;
            } else if (this.status == TNBoatEntity.Status.UNDER_FLOWING_WATER) {
                d1 = -7.0E-4;
                this.momentum = 0.9f;
            } else if (this.status == TNBoatEntity.Status.UNDER_WATER) {
                d2 = 0.01f;
                this.momentum = 0.45f;
            } else if (this.status == TNBoatEntity.Status.IN_AIR) {
                this.momentum = 0.9f;
            } else if (this.status == TNBoatEntity.Status.ON_LAND) {
                this.momentum = this.boatGlide * 0.001f;
                if (this.func_184179_bs() instanceof PlayerEntity) {
                    this.boatGlide /= 1.0f;
                }
            }
            Vector3d vec3d = this.func_213322_ci();
            this.func_213293_j(vec3d.field_72450_a * (double)(this.momentum - this.passengerfaktor), vec3d.field_72448_b + d1, vec3d.field_72449_c * (double)(this.momentum - this.passengerfaktor));
            this.deltaRotation = (float)((double)this.deltaRotation * ((double)(this.momentum - this.passengerfaktor) * RowBoatTurnFactor));
            if (d2 > 0.0) {
                Vector3d vec3d1 = this.func_213322_ci();
                this.func_213293_j(vec3d1.field_72450_a, (vec3d1.field_72448_b + d2 * 0.06) * 0.75, vec3d1.field_72449_c);
            }
        }
    }

    protected void controlBoat() {
        double RowBoatSpeedFactor = (Double)SmallShipsConfig.RowBoatSpeedFactor.get();
        if (this.func_184207_aI()) {
            float f = 0.0f;
            if (this.leftInputDown) {
                this.deltaRotation -= 1.0f;
            }
            if (this.rightInputDown) {
                this.deltaRotation += 1.0f;
            }
            if (this.rightInputDown != this.leftInputDown && !this.forwardInputDown && !this.backInputDown) {
                f += 0.005f;
            }
            this.field_70177_z += this.deltaRotation;
            if (this.backInputDown) {
                f = (float)((double)f - (double)0.005f * RowBoatSpeedFactor);
            }
            if (this.forwardInputDown) {
                f = (float)((double)f + (double)0.04f * RowBoatSpeedFactor);
            }
            this.func_213317_d(this.func_213322_ci().func_72441_c((double)(MathHelper.func_76126_a((float)(-this.field_70177_z * ((float)Math.PI / 180))) * f), 0.0, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * f)));
            this.setPaddleState(this.rightInputDown && !this.leftInputDown || this.forwardInputDown, this.leftInputDown && !this.rightInputDown || this.forwardInputDown);
        }
    }

    @Override
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Nullable
    private TNBoatEntity.Status getUnderwaterStatus() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        double d0 = axisalignedbb.field_72337_e + 0.001;
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72337_e);
        int l = MathHelper.func_76143_f((double)d0);
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        boolean flag = false;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutable.func_181079_c(k1, l1, i2);
                    FluidState fluidstate = this.field_70170_p.func_204610_c((BlockPos)blockpos$mutable);
                    if (!fluidstate.func_206884_a((ITag)FluidTags.field_206959_a) || !(d0 < (double)((float)blockpos$mutable.func_177956_o() + fluidstate.func_215679_a((IBlockReader)this.field_70170_p, (BlockPos)blockpos$mutable)))) continue;
                    if (!fluidstate.func_206889_d()) {
                        return TNBoatEntity.Status.UNDER_FLOWING_WATER;
                    }
                    flag = true;
                }
            }
        }
        return flag ? TNBoatEntity.Status.UNDER_WATER : null;
    }

    private boolean checkInWater() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int l = MathHelper.func_76143_f((double)(axisalignedbb.field_72338_b + 0.001));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        boolean flag = false;
        this.waterLevel = Double.MIN_VALUE;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutable.func_181079_c(k1, l1, i2);
                    FluidState fluidstate = this.field_70170_p.func_204610_c((BlockPos)blockpos$mutable);
                    if (!fluidstate.func_206884_a((ITag)FluidTags.field_206959_a)) continue;
                    float f = (float)l1 + fluidstate.func_215679_a((IBlockReader)this.field_70170_p, (BlockPos)blockpos$mutable);
                    this.waterLevel = Math.max((double)f, this.waterLevel);
                    flag |= axisalignedbb.field_72338_b < (double)f;
                }
            }
        }
        return flag;
    }

    @Override
    public boolean func_70104_M() {
        return false;
    }

    @Override
    public void func_70108_f(Entity entityIn) {
        super.func_70108_f(entityIn);
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        double RowBoatHealth = (Double)SmallShipsConfig.RowBoatHealth.get();
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S()) {
            boolean flag;
            if (source == DamageSource.field_76367_g) {
                return false;
            }
            if (source instanceof IndirectEntityDamageSource && source.func_76346_g() != null && this.func_184196_w(source.func_76346_g())) {
                return false;
            }
            this.setForwardDirection(-this.getForwardDirection());
            this.setTimeSinceHit(3);
            this.setDamageTaken(this.getDamageTaken() + amount * 10.0f);
            boolean bl = flag = source.func_76346_g() instanceof PlayerEntity && ((PlayerEntity)source.func_76346_g()).field_71075_bZ.field_75098_d;
            if (flag || (double)this.getDamageTaken() > RowBoatHealth) {
                this.onDestroyed(source, flag);
                this.func_70106_y();
            }
            return true;
        }
        return false;
    }

    @Override
    protected void func_184200_o(Entity passenger) {
        super.func_184200_o(passenger);
    }

    @Override
    @Nullable
    protected SoundEvent getPaddleSound() {
        switch (this.getBoatStatus()) {
            case IN_WATER: 
            case UNDER_WATER: 
            case UNDER_FLOWING_WATER: {
                return SoundEvents.field_193779_I;
            }
            case ON_LAND: {
                return SoundEvents.field_193778_H;
            }
        }
        return null;
    }

    @Override
    public void setPaddleState(boolean left, boolean right) {
        super.setPaddleState(left, right);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float getRowingTime(int side, float limbSwing) {
        return this.getPaddleState(side) ? (float)MathHelper.func_151238_b((double)((double)this.paddlePositions[side] - (double)0.3926991f), (double)this.paddlePositions[side], (double)limbSwing) : 0.0f;
    }

    @Override
    public boolean getPaddleState(int side) {
        return super.getPaddleState(side);
    }

    @Override
    public Vector3d func_230268_c_(LivingEntity rider) {
        return super.func_230268_c_(rider);
    }

    @Override
    public PlayerEntity getDriver() {
        return super.getDriver();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void updateInputs(boolean leftInputDown, boolean rightInputDown, boolean forwardInputDown, boolean backInputDown) {
        this.leftInputDown = leftInputDown;
        this.rightInputDown = rightInputDown;
        this.forwardInputDown = forwardInputDown;
        this.backInputDown = backInputDown;
    }
}

