/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.simplemagnets;

import com.supermartijn642.core.block.BaseTileEntity;
import com.supermartijn642.simplemagnets.ItemSpawnHandler;
import com.supermartijn642.simplemagnets.SMConfig;
import com.supermartijn642.simplemagnets.SimpleMagnets;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.AxisAlignedBB;

public class DemagnetizationCoilTile
extends BaseTileEntity
implements ITickableTileEntity {
    private final int minRange;
    private final int maxRange;
    private final boolean hasFilter;
    public int rangeX;
    public int rangeY;
    public int rangeZ;
    public final List<ItemStack> filter = new ArrayList<ItemStack>(9);
    public boolean filterWhitelist;
    public boolean filterDurability = true;

    public DemagnetizationCoilTile(TileEntityType<?> tileEntityType, int minRange, int maxRange, int range, boolean hasFilter) {
        super(tileEntityType);
        this.minRange = minRange;
        this.maxRange = maxRange;
        this.rangeY = this.rangeZ = range;
        this.rangeX = this.rangeZ;
        this.hasFilter = hasFilter;
        for (int i = 0; i < 9; ++i) {
            this.filter.add(ItemStack.field_190927_a);
        }
    }

    public void func_73660_a() {
        AxisAlignedBB area = this.getArea();
        List affectedItems = this.field_145850_b.func_217394_a(EntityType.field_200765_E, area, item -> item.func_70089_S() && this.shouldEffectItem(item.func_92059_d()));
        affectedItems.forEach(item -> {
            item.getPersistentData().func_74757_a("PreventRemoteMovement", true);
            item.getPersistentData().func_74757_a("AllowMachineRemoteMovement", true);
        });
    }

    public AxisAlignedBB getArea() {
        return new AxisAlignedBB(this.field_174879_c).func_72314_b((double)(this.rangeX - 1), (double)(this.rangeY - 1), (double)(this.rangeZ - 1));
    }

    public boolean shouldEffectItem(ItemStack stack) {
        if (!this.hasFilter) {
            return true;
        }
        if (stack.func_190926_b()) {
            return false;
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack filter = this.filter.get(i);
            if (!ItemStack.func_179545_c((ItemStack)filter, (ItemStack)stack) || this.filterDurability && !ItemStack.func_77970_a((ItemStack)filter, (ItemStack)stack)) continue;
            return this.filterWhitelist;
        }
        return !this.filterWhitelist;
    }

    public void setRangeX(int range) {
        int old = this.rangeX;
        this.rangeX = Math.min(Math.max(range, this.minRange), this.maxRange);
        if (this.rangeX != old) {
            this.dataChanged();
        }
    }

    public void setRangeY(int range) {
        int old = this.rangeY;
        this.rangeY = Math.min(Math.max(range, this.minRange), this.maxRange);
        if (this.rangeY != old) {
            this.dataChanged();
        }
    }

    public void setRangeZ(int range) {
        int old = this.rangeZ;
        this.rangeZ = Math.min(Math.max(range, this.minRange), this.maxRange);
        if (this.rangeZ != old) {
            this.dataChanged();
        }
    }

    protected CompoundNBT writeData() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a("rangeX", this.rangeX);
        tag.func_74768_a("rangeY", this.rangeY);
        tag.func_74768_a("rangeZ", this.rangeZ);
        if (this.hasFilter) {
            for (int i = 0; i < 9; ++i) {
                if (this.filter.get(i).func_190926_b()) continue;
                tag.func_218657_a("filter" + i, (INBT)this.filter.get(i).func_77955_b(new CompoundNBT()));
            }
            tag.func_74757_a("filterWhitelist", this.filterWhitelist);
            tag.func_74757_a("filterDurability", this.filterDurability);
        }
        return tag;
    }

    protected void readData(CompoundNBT tag) {
        if (tag.func_74764_b("rangeX")) {
            this.rangeX = tag.func_74762_e("rangeX");
        }
        if (tag.func_74764_b("rangeY")) {
            this.rangeY = tag.func_74762_e("rangeY");
        }
        if (tag.func_74764_b("rangeZ")) {
            this.rangeZ = tag.func_74762_e("rangeZ");
        }
        if (this.hasFilter) {
            for (int i = 0; i < 9; ++i) {
                this.filter.set(i, tag.func_74764_b("filter" + i) ? ItemStack.func_199557_a((CompoundNBT)tag.func_74775_l("filter" + i)) : ItemStack.field_190927_a);
            }
            this.filterWhitelist = tag.func_74764_b("filterWhitelist") && tag.func_74767_n("filterWhitelist");
            this.filterDurability = tag.func_74764_b("filterDurability") && tag.func_74767_n("filterDurability");
        }
    }

    public void onLoad() {
        ItemSpawnHandler.add(this);
    }

    public static class AdvancedDemagnetizationCoilTile
    extends DemagnetizationCoilTile {
        public AdvancedDemagnetizationCoilTile() {
            super(SimpleMagnets.advanced_demagnetization_coil_tile, SMConfig.advancedCoilMinRange.get(), SMConfig.advancedCoilMaxRange.get(), SMConfig.advancedCoilRange.get(), SMConfig.advancedCoilFilter.get());
        }
    }

    public static class BasicDemagnetizationCoilTile
    extends DemagnetizationCoilTile {
        public BasicDemagnetizationCoilTile() {
            super(SimpleMagnets.basic_demagnetization_coil_tile, SMConfig.basicCoilMinRange.get(), SMConfig.basicCoilMaxRange.get(), SMConfig.basicCoilRange.get(), SMConfig.basicCoilFilter.get());
        }
    }
}

