/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.tile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.silentchaos512.lib.util.MCMathUtils;

public abstract class LockableSidedInventoryTileEntity
extends LockableTileEntity
implements ISidedInventory {
    protected NonNullList<ItemStack> items;
    private final LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    protected LockableSidedInventoryTileEntity(TileEntityType<?> typeIn, int inventorySize) {
        super(typeIn);
        this.items = NonNullList.func_191197_a((int)inventorySize, (Object)ItemStack.field_190927_a);
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.items) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        if (index < 0 || index >= this.items.size()) {
            return ItemStack.field_190927_a;
        }
        return (ItemStack)this.items.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.items, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.items, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.items.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
    }

    public boolean func_70300_a(PlayerEntity player) {
        return this.field_145850_b != null && this.field_145850_b.func_175625_s(this.field_174879_c) == this && MCMathUtils.distanceSq((Entity)player, (Vector3i)this.field_174879_c) <= 64.0;
    }

    public void func_174888_l() {
        this.items.clear();
    }

    public void func_230337_a_(BlockState stateIn, CompoundNBT tags) {
        super.func_230337_a_(stateIn, tags);
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)tags, this.items);
    }

    public CompoundNBT func_189515_b(CompoundNBT tags) {
        super.func_189515_b(tags);
        ItemStackHelper.func_191282_a((CompoundNBT)tags, this.items);
        return tags;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT tags = this.func_189517_E_();
        ItemStackHelper.func_191282_a((CompoundNBT)tags, this.items);
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, tags);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        super.onDataPacket(net, packet);
        ItemStackHelper.func_191283_b((CompoundNBT)packet.func_148857_g(), this.items);
    }

    @Nullable
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (!this.field_145846_f && side != null && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (side == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (side == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_145843_s() {
        super.func_145843_s();
        for (LazyOptional<? extends IItemHandler> handler : this.handlers) {
            handler.invalidate();
        }
    }
}

