/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.data.recipe;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.RecipeUnlockedTrigger;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.lib.util.NameUtils;

public class ExtendedSingleItemRecipeBuilder {
    private final IRecipeSerializer<?> serializer;
    private final Collection<Consumer<JsonObject>> extraData = new ArrayList<Consumer<JsonObject>>();
    private final Ingredient ingredients;
    private final Item result;
    private final int count;
    private final Advancement.Builder advancementBuilder = Advancement.Builder.func_200278_a();
    private boolean hasAdvancementCriterion = false;
    private String group = "";

    protected ExtendedSingleItemRecipeBuilder(IRecipeSerializer<?> serializer, Ingredient ingredients, IItemProvider result, int count) {
        this.serializer = serializer;
        this.ingredients = ingredients;
        this.result = result.func_199767_j();
        this.count = count;
    }

    public static ExtendedSingleItemRecipeBuilder builder(IRecipeSerializer<?> serializer, Ingredient ingredient, IItemProvider result) {
        return ExtendedSingleItemRecipeBuilder.builder(serializer, ingredient, result, 1);
    }

    public static ExtendedSingleItemRecipeBuilder builder(IRecipeSerializer<?> serializer, Ingredient ingredient, IItemProvider result, int count) {
        return new ExtendedSingleItemRecipeBuilder(serializer, ingredient, result, count);
    }

    public static ExtendedSingleItemRecipeBuilder stonecuttingBuilder(Ingredient ingredient, IItemProvider result) {
        return ExtendedSingleItemRecipeBuilder.stonecuttingBuilder(ingredient, result, 1);
    }

    public static ExtendedSingleItemRecipeBuilder stonecuttingBuilder(Ingredient ingredient, IItemProvider result, int count) {
        return new ExtendedSingleItemRecipeBuilder(IRecipeSerializer.field_222175_s, ingredient, result, count);
    }

    protected void serializeExtra(JsonObject json) {
        this.extraData.forEach(consumer -> consumer.accept(json));
    }

    public ExtendedSingleItemRecipeBuilder addExtraData(Consumer<JsonObject> extraDataIn) {
        this.extraData.add(extraDataIn);
        return this;
    }

    public ExtendedSingleItemRecipeBuilder addCriterion(String name, ICriterionInstance criterion) {
        this.advancementBuilder.func_200275_a(name, criterion);
        this.hasAdvancementCriterion = true;
        return this;
    }

    public ExtendedSingleItemRecipeBuilder setGroup(String group) {
        this.group = group;
        return this;
    }

    public void build(Consumer<IFinishedRecipe> consumer) {
        ResourceLocation itemId = NameUtils.from(this.result);
        ResourceLocation serializerId = NameUtils.from(this.serializer);
        this.build(consumer, new ResourceLocation(itemId.func_110624_b(), serializerId.func_110623_a() + "/" + itemId.func_110623_a()));
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        if (this.hasAdvancementCriterion && !this.advancementBuilder.func_200277_c().isEmpty()) {
            this.advancementBuilder.func_200272_a(new ResourceLocation("recipes/root")).func_200275_a("has_the_recipe", (ICriterionInstance)new RecipeUnlockedTrigger.Instance(EntityPredicate.AndPredicate.field_234582_a_, id)).func_200271_a(AdvancementRewards.Builder.func_200280_c((ResourceLocation)id)).func_200270_a(IRequirementsStrategy.field_223215_b_);
        }
        ResourceLocation advancementId = new ResourceLocation(id.func_110624_b(), "recipes/" + this.result.func_77640_w().func_200300_c() + "/" + id.func_110623_a());
        consumer.accept(new Result(id, this, advancementId));
    }

    public static class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final ExtendedSingleItemRecipeBuilder builder;
        private final ResourceLocation advancementId;

        public Result(ResourceLocation id, ExtendedSingleItemRecipeBuilder builder, ResourceLocation advancementId) {
            this.id = id;
            this.builder = builder;
            this.advancementId = advancementId;
        }

        public void func_218610_a(JsonObject json) {
            if (!this.builder.group.isEmpty()) {
                json.addProperty("group", this.builder.group);
            }
            json.add("ingredient", this.builder.ingredients.func_200304_c());
            json.addProperty("result", NameUtils.from(this.builder.result).toString());
            json.addProperty("count", (Number)this.builder.count);
            this.builder.serializeExtra(json);
        }

        public IRecipeSerializer<?> func_218609_c() {
            return this.builder.serializer;
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return this.builder.hasAdvancementCriterion ? this.builder.advancementBuilder.func_200273_b() : null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return this.builder.hasAdvancementCriterion ? this.advancementId : null;
        }
    }
}

