/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.PacketBuffer;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.part.IGearPart;
import net.silentchaos512.gear.gear.part.PartManager;
import net.silentchaos512.gear.gear.part.PartSerializers;
import net.silentchaos512.gear.network.LoginPacket;
import net.silentchaos512.gear.network.Network;

public class SyncGearPartsPacket
extends LoginPacket {
    private final List<IGearPart> parts;

    public SyncGearPartsPacket() {
        this(PartManager.getValues());
    }

    public SyncGearPartsPacket(Collection<IGearPart> parts) {
        this.parts = new ArrayList<IGearPart>(parts);
    }

    public static SyncGearPartsPacket fromBytes(PacketBuffer buf) {
        SilentGear.LOGGER.debug("Gear parts packet: {} bytes", (Object)buf.readableBytes());
        SyncGearPartsPacket packet = new SyncGearPartsPacket(Collections.emptyList());
        Network.verifyNetworkVersion(buf);
        int count = buf.func_150792_a();
        for (int i = 0; i < count; ++i) {
            packet.parts.add(PartSerializers.read(buf));
        }
        return packet;
    }

    public void toBytes(PacketBuffer buf) {
        Network.writeModVersionInfoToNetwork(buf);
        buf.func_150787_b(this.parts.size());
        this.parts.forEach(part -> PartSerializers.write(part, buf));
    }

    public List<IGearPart> getParts() {
        return Collections.unmodifiableList(this.parts);
    }
}

