/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.gear;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.part.IPartData;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.client.KeyTracker;
import net.silentchaos512.gear.client.util.GearClientHelper;
import net.silentchaos512.gear.entity.projectile.GearArrowEntity;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.TextUtil;

public class CoreArrow
extends ArrowItem
implements ICoreItem {
    private static final Set<ItemStat> RELEVANT_STATS = ImmutableSet.of((Object)ItemStats.DURABILITY, (Object)ItemStats.REPAIR_EFFICIENCY, (Object)ItemStats.RANGED_DAMAGE, (Object)ItemStats.PROJECTILE_SPEED, (Object)ItemStats.PROJECTILE_ACCURACY);
    private static final Set<ItemStat> EXCLUDED_STATS = ImmutableSet.of((Object)ItemStats.ARMOR_DURABILITY, (Object)ItemStats.REPAIR_VALUE, (Object)ItemStats.MELEE_DAMAGE, (Object)ItemStats.ATTACK_SPEED, (Object)ItemStats.ATTACK_REACH, (Object)ItemStats.RANGED_SPEED, (Object[])new ItemStat[]{ItemStats.ARMOR, ItemStats.ARMOR_TOUGHNESS, ItemStats.MAGIC_ARMOR, ItemStats.KNOCKBACK_RESISTANCE});
    private static final Collection<PartType> REQUIRED_PARTS = ImmutableList.of((Object)PartType.MAIN, (Object)PartType.ROD, (Object)PartType.FLETCHING);

    public CoreArrow(Item.Properties builder) {
        super(builder);
    }

    @Override
    public GearType getGearType() {
        return GearType.ARROW;
    }

    @Override
    public float getRepairModifier(ItemStack stack) {
        int durability = GearData.getStatInt(stack, this.getDurabilityStat());
        if (durability == 0) {
            return 1.0f;
        }
        return (float)this.getMaxDamage(stack) / (float)durability;
    }

    @Override
    public Set<ItemStat> getRelevantStats(ItemStack stack) {
        return RELEVANT_STATS;
    }

    @Override
    public Set<ItemStat> getExcludedStats(ItemStack stack) {
        return EXCLUDED_STATS;
    }

    @Override
    public Collection<PartType> getRequiredParts() {
        return REQUIRED_PARTS;
    }

    @Override
    public Collection<PartType> getRenderParts() {
        return ImmutableList.of((Object)PartType.ROD, (Object)PartType.FLETCHING, (Object)PartType.MAIN);
    }

    @Override
    public ItemStack construct(Collection<? extends IPartData> parts) {
        ItemStack result = ICoreItem.super.construct(parts);
        result.func_196085_b(result.func_77958_k() - 64);
        return result;
    }

    @Override
    public boolean hasTexturesFor(PartType partType) {
        return REQUIRED_PARTS.contains(partType) || partType.isUpgrade();
    }

    public AbstractArrowEntity func_200887_a(World worldIn, ItemStack stack, LivingEntity shooter) {
        GearArrowEntity arrow = new GearArrowEntity(worldIn, shooter);
        arrow.setArrowStack(stack);
        arrow.func_70239_b(GearData.getStat(stack, ItemStats.RANGED_DAMAGE));
        if (shooter instanceof PlayerEntity && !((PlayerEntity)shooter).field_71075_bZ.field_75098_d) {
            stack.func_196085_b(stack.func_77952_i() + 1);
        }
        return arrow;
    }

    public boolean isInfinite(ItemStack stack, ItemStack bow, PlayerEntity player) {
        return !GearHelper.isBroken(stack);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        ItemStack usedStack = playerIn.func_184586_b(handIn);
        boolean used = false;
        if (usedStack.func_77952_i() > 0) {
            for (ItemStack stack : playerIn.field_71071_by.field_70462_a) {
                if (stack.func_77973_b() != this || stack.func_77952_i() <= 0 || !GearHelper.isEquivalent(usedStack, stack)) continue;
                int count = stack.func_77958_k() - stack.func_77952_i();
                int merged = Math.min(usedStack.func_77952_i(), count);
                usedStack.func_196085_b(usedStack.func_77952_i() - merged);
                stack.func_196085_b(stack.func_77952_i() + merged);
                used |= usedStack.func_77952_i() != stack.func_77952_i();
                if (stack.func_77952_i() >= stack.func_77958_k()) {
                    playerIn.field_71071_by.func_184437_d(stack);
                }
                if (usedStack.func_77952_i() > 0) continue;
                break;
            }
        }
        return used ? ActionResult.func_226248_a_((Object)usedStack) : ActionResult.func_226250_c_((Object)usedStack);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        return GearHelper.onItemUse(context);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (!(KeyTracker.isDisplayStatsDown() || KeyTracker.isDisplayTraitsDown() || KeyTracker.isDisplayConstructionDown())) {
            tooltip.add((ITextComponent)new StringTextComponent("Do not use with vanilla crossbows, see issue #270").func_240699_a_(TextFormatting.RED));
        }
        tooltip.add((ITextComponent)TextUtil.misc("ammo", stack.func_77958_k() - stack.func_77952_i()));
        GearClientHelper.addInformation(stack, worldIn, tooltip, flagIn);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        return GearHelper.getAttributeModifiers(slot, stack);
    }

    public int getItemEnchantability(ItemStack stack) {
        return GearHelper.getEnchantability(stack);
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        return GearHelper.getDisplayName(stack);
    }

    public Rarity func_77613_e(ItemStack stack) {
        return GearHelper.getRarity(stack);
    }

    public int getMaxDamage(ItemStack stack) {
        return 256;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return stack.func_77952_i() > 0;
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return GearHelper.damageItem(stack, amount, entity, onBroken);
    }

    public boolean func_77636_d(ItemStack stack) {
        return GearClientHelper.hasEffect(stack);
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        GearHelper.fillItemGroup(this, group, items);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        GearHelper.inventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return GearClientHelper.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }
}

