/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.blueprint;

import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.tags.ITag;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.item.blueprint.BlueprintType;
import net.silentchaos512.gear.item.blueprint.IBlueprint;

public abstract class AbstractBlueprintItem
extends Item
implements IBlueprint {
    final boolean singleUse;

    AbstractBlueprintItem(Item.Properties properties, boolean singleUse) {
        super(properties);
        this.singleUse = singleUse;
    }

    public abstract ITag.INamedTag<Item> getItemTag();

    protected abstract ITextComponent getCraftedName(ItemStack var1);

    public boolean isSingleUse() {
        return this.singleUse;
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        ItemStack copy = itemStack.func_77946_l();
        copy.func_190920_e(1);
        return copy;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return !this.singleUse;
    }

    boolean isDisabled() {
        BlueprintType config = (BlueprintType)((Object)Config.Common.blueprintTypes.get());
        return this.singleUse && !config.allowTemplate() || !this.singleUse && !config.allowBlueprint();
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (!this.isDisabled()) {
            super.func_150895_a(group, items);
        }
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        String key = "item.silentgear." + (this.singleUse ? "template" : "blueprint");
        return new TranslationTextComponent(key, new Object[]{this.getCraftedName(stack)});
    }

    public Rarity func_77613_e(ItemStack stack) {
        return this.singleUse ? Rarity.COMMON : Rarity.UNCOMMON;
    }

    public boolean hasStandardModel() {
        return true;
    }
}

