/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.init;

import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.village.PointOfInterestType;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.common.Mod;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.init.ModBlocks;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.gear.init.Registration;
import net.silentchaos512.gear.item.CraftingItems;
import net.silentchaos512.lib.block.IBlockProvider;

public class GearVillages {
    public static final ResourceLocation GEAR_SMITH = SilentGear.getId("gear_smith");
    public static final ResourceLocation HOTV_GEAR_SMITH = SilentGear.getId("gameplay/hero_of_the_village/gear_smith");
    public static final RegistryObject<PointOfInterestType> POI_GEAR_SMITHING_TABLE = GearVillages.registerPointOfInterest("gear_smithing_table", ModBlocks.GEAR_SMITHING_TABLE);
    public static final RegistryObject<VillagerProfession> PROF_GEAR_SMITH = GearVillages.registerProfession("gear_smith", POI_GEAR_SMITHING_TABLE, SoundEvents.field_219705_mM);

    private static RegistryObject<PointOfInterestType> registerPointOfInterest(String name, IBlockProvider block) {
        return Registration.POINTS_OF_INTEREST.register(name, () -> {
            PointOfInterestType type = new PointOfInterestType("silentgear:" + name, (Set)ImmutableSet.of((Object)block.asBlockState()), 1, 1);
            PointOfInterestType.func_221052_a((PointOfInterestType)type);
            return type;
        });
    }

    private static RegistryObject<VillagerProfession> registerProfession(String name, Supplier<PointOfInterestType> poi, SoundEvent sound) {
        return Registration.PROFESSIONS.register(name, () -> new VillagerProfession(SilentGear.getId(name).toString(), (PointOfInterestType)poi.get(), ImmutableSet.of(), ImmutableSet.of(), sound));
    }

    public static void init() {
    }

    public static void register() {
    }

    private static class SellingItemTrade
    implements VillagerTrades.ITrade {
        private final ItemStack givenItem;
        private final int emeraldCount;
        private final int sellingItemCount;
        private final int maxUses;
        private final int xpValue;
        private final float priceMultiplier;

        public SellingItemTrade(IItemProvider givenItem, int emeraldCount, int sellingItemCount, int xpValue) {
            this(new ItemStack(givenItem), emeraldCount, sellingItemCount, 12, xpValue);
        }

        public SellingItemTrade(IItemProvider givenItem, int emeraldCount, int sellingItemCount, int maxUses, int xpValue) {
            this(new ItemStack(givenItem), emeraldCount, sellingItemCount, maxUses, xpValue);
        }

        public SellingItemTrade(ItemStack givenItem, int emeraldCount, int sellingItemCount, int maxUses, int xpValue) {
            this(givenItem, emeraldCount, sellingItemCount, maxUses, xpValue, 0.05f);
        }

        public SellingItemTrade(ItemStack givenItem, int emeraldCount, int sellingItemCount, int maxUses, int xpValue, float priceMultiplier) {
            this.givenItem = givenItem;
            this.emeraldCount = emeraldCount;
            this.sellingItemCount = sellingItemCount;
            this.maxUses = maxUses;
            this.xpValue = xpValue;
            this.priceMultiplier = priceMultiplier;
        }

        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            return new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, this.emeraldCount), new ItemStack((IItemProvider)this.givenItem.func_77973_b(), this.sellingItemCount), this.maxUses, this.xpValue, this.priceMultiplier);
        }
    }

    private static class BuyingItemTrade
    implements VillagerTrades.ITrade {
        private final Item wantedItem;
        private final int count;
        private final int maxUses;
        private final int xpValue;
        private final float priceMultiplier;

        public BuyingItemTrade(IItemProvider wantedItem, int countIn, int maxUsesIn, int xpValueIn) {
            this.wantedItem = wantedItem.func_199767_j();
            this.count = countIn;
            this.maxUses = maxUsesIn;
            this.xpValue = xpValueIn;
            this.priceMultiplier = 0.05f;
        }

        public MerchantOffer func_221182_a(Entity trader, Random rand) {
            ItemStack stack = new ItemStack((IItemProvider)this.wantedItem, this.count);
            return new MerchantOffer(stack, new ItemStack((IItemProvider)Items.field_151166_bC), this.maxUses, this.xpValue, this.priceMultiplier);
        }
    }

    @Mod.EventBusSubscriber(modid="silentgear")
    public static final class Events {
        private Events() {
        }

        @SubscribeEvent
        public static void registerTrades(VillagerTradesEvent event) {
            Int2ObjectMap trades = event.getTrades();
            if (GEAR_SMITH.equals((Object)event.getType().getRegistryName())) {
                ((List)trades.get(1)).add(new BuyingItemTrade(CraftingItems.FLAX_FLOWERS, 24, 16, 2));
                ((List)trades.get(1)).add(new SellingItemTrade(CraftingItems.BLUEPRINT_PAPER, 1, 12, 12, 2));
                ((List)trades.get(2)).add(new SellingItemTrade((IItemProvider)ModItems.EXCAVATOR_BLUEPRINT, 7, 1, 2, 12));
                ((List)trades.get(2)).add(new SellingItemTrade((IItemProvider)ModItems.HAMMER_BLUEPRINT, 7, 1, 2, 12));
                ((List)trades.get(2)).add(new SellingItemTrade((IItemProvider)ModItems.PAXEL_BLUEPRINT, 9, 1, 2, 12));
                ((List)trades.get(2)).add(new SellingItemTrade((IItemProvider)ModItems.PROSPECTOR_HAMMER_BLUEPRINT, 5, 1, 2, 12));
                ((List)trades.get(2)).add(new SellingItemTrade((IItemProvider)ModItems.SAW_BLUEPRINT, 7, 1, 4, 12));
                ((List)trades.get(2)).add(new SellingItemTrade((IItemProvider)ModItems.TIP_BLUEPRINT, 4, 1, 4, 7));
                ((List)trades.get(2)).add(new SellingItemTrade((IItemProvider)ModItems.STURDY_REPAIR_KIT, 8, 1, 3, 10));
                ((List)trades.get(2)).add(new BuyingItemTrade(CraftingItems.CRIMSON_IRON_INGOT, 3, 12, 10));
            }
        }
    }
}

