/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.trait;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.traits.ITraitSerializer;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.gear.trait.SimpleTrait;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.lib.util.NameUtils;
import org.apache.commons.lang3.tuple.Triple;

public final class EnchantmentTrait
extends SimpleTrait {
    private static final ResourceLocation SERIALIZER_ID = SilentGear.getId("enchantment_trait");
    public static final ITraitSerializer<EnchantmentTrait> SERIALIZER = new SimpleTrait.Serializer<EnchantmentTrait>(SERIALIZER_ID, EnchantmentTrait::new, EnchantmentTrait::readJson, EnchantmentTrait::readBuffer, EnchantmentTrait::writeBuffer);
    private final Map<String, List<EnchantmentData>> enchantments = new HashMap<String, List<EnchantmentData>>();

    private EnchantmentTrait(ResourceLocation id) {
        super(id, SERIALIZER);
    }

    @Override
    public void onRecalculatePost(TraitActionContext context) {
        ItemStack gear = context.getGear();
        GearType gearType = GearHelper.getType(gear);
        int traitLevel = context.getTraitLevel();
        this.enchantments.forEach((type, list) -> {
            if (gearType.matches((String)type)) {
                this.addEnchantments(gear, traitLevel, (Iterable<EnchantmentData>)list);
            }
        });
    }

    public static void removeTraitEnchantments(ItemStack gear) {
        Map<Enchantment, Triple<Integer, ResourceLocation, Integer>> enchants = EnchantmentTrait.getEnchantmentsOnGear(gear);
        ArrayList<Enchantment> toRemove = new ArrayList<Enchantment>();
        for (Enchantment enchantment : enchants.keySet()) {
            Triple<Integer, ResourceLocation, Integer> info = enchants.get(enchantment);
            if ((Integer)info.getRight() <= 0) continue;
            toRemove.add(enchantment);
        }
        for (Enchantment enchantment : toRemove) {
            enchants.remove(enchantment);
        }
        EnchantmentTrait.setEnchantmentsOnGear(gear, enchants);
    }

    private void addEnchantments(ItemStack gear, int traitLevel, Iterable<EnchantmentData> list) {
        Map<Enchantment, Triple<Integer, ResourceLocation, Integer>> enchants = EnchantmentTrait.getEnchantmentsOnGear(gear);
        for (EnchantmentData data : list) {
            Enchantment enchantment = data.getEnchantment();
            if (enchantment == null || enchants.containsKey(enchantment)) continue;
            boolean compatible = true;
            for (Enchantment current : enchants.keySet()) {
                if (current.func_191560_c(enchantment)) continue;
                compatible = false;
                break;
            }
            if (!compatible) continue;
            int enchantmentLevel = data.getLevel(traitLevel);
            enchants.put(enchantment, (Triple<Integer, ResourceLocation, Integer>)Triple.of((Object)enchantmentLevel, (Object)this.getId(), (Object)traitLevel));
            SilentGear.LOGGER.debug("Adding {} enchantment from {} trait to {}", (Object)enchantment.func_200305_d(enchantmentLevel).getString(), (Object)this.getDisplayName(traitLevel).getString(), (Object)gear.func_200301_q().getString());
        }
        EnchantmentTrait.setEnchantmentsOnGear(gear, enchants);
    }

    private static Map<Enchantment, Triple<Integer, ResourceLocation, Integer>> getEnchantmentsOnGear(ItemStack gear) {
        LinkedHashMap<Enchantment, Triple<Integer, ResourceLocation, Integer>> map = new LinkedHashMap<Enchantment, Triple<Integer, ResourceLocation, Integer>>();
        ListNBT tagList = gear.func_77986_q();
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT nbt = tagList.func_150305_b(i);
            Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(nbt.func_74779_i("id")));
            if (enchantment == null) continue;
            int level = nbt.func_74762_e("lvl");
            String traitKey = nbt.func_74779_i("SGearTrait");
            if (!traitKey.isEmpty()) {
                try {
                    String[] parts = traitKey.split("#");
                    ResourceLocation traitId = new ResourceLocation(parts[0]);
                    Integer traitLevel = Integer.valueOf(parts[1]);
                    map.put(enchantment, (Triple<Integer, ResourceLocation, Integer>)Triple.of((Object)level, (Object)traitId, (Object)traitLevel));
                }
                catch (Exception ex) {
                    map.put(enchantment, (Triple<Integer, ResourceLocation, Integer>)Triple.of((Object)level, (Object)new ResourceLocation("null"), (Object)0));
                }
                continue;
            }
            map.put(enchantment, (Triple<Integer, ResourceLocation, Integer>)Triple.of((Object)level, (Object)new ResourceLocation("null"), (Object)0));
        }
        return map;
    }

    private static void setEnchantmentsOnGear(ItemStack gear, Map<Enchantment, Triple<Integer, ResourceLocation, Integer>> map) {
        ListNBT tagList = new ListNBT();
        for (Map.Entry<Enchantment, Triple<Integer, ResourceLocation, Integer>> entry : map.entrySet()) {
            Enchantment enchantment = entry.getKey();
            if (enchantment == null) continue;
            int level = (Integer)entry.getValue().getLeft();
            ResourceLocation traitId = (ResourceLocation)entry.getValue().getMiddle();
            int traitLevel = (Integer)entry.getValue().getRight();
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74778_a("id", NameUtils.from((IForgeRegistryEntry)enchantment).toString());
            nbt.func_74777_a("lvl", (short)level);
            if (traitLevel > 0) {
                nbt.func_74778_a("SGearTrait", traitId + "#" + traitLevel);
            }
            tagList.add((Object)nbt);
        }
        if (tagList.isEmpty()) {
            gear.func_196083_e("Enchantments");
        } else {
            gear.func_77983_a("Enchantments", (INBT)tagList);
        }
    }

    private static void readJson(EnchantmentTrait trait, JsonObject json) {
        if (!json.has("enchantments")) {
            throw new JsonParseException("Enchantment trait '" + trait.getId() + "' is missing 'enchantments' object");
        }
        JsonObject jsonEffects = json.getAsJsonObject("enchantments");
        for (Map.Entry entry : jsonEffects.entrySet()) {
            String key = (String)entry.getKey();
            JsonElement element = (JsonElement)entry.getValue();
            if (!element.isJsonArray()) {
                throw new JsonParseException("Expected array, found " + element.getClass().getSimpleName());
            }
            JsonArray array = element.getAsJsonArray();
            ArrayList<EnchantmentData> list = new ArrayList<EnchantmentData>();
            for (JsonElement elem : array) {
                if (!elem.isJsonObject()) {
                    throw new JsonParseException("Expected object, found " + elem.getClass().getSimpleName());
                }
                list.add(EnchantmentData.from(elem.getAsJsonObject()));
            }
            if (list.isEmpty()) continue;
            trait.enchantments.put(key, list);
        }
    }

    private static void readBuffer(EnchantmentTrait trait, PacketBuffer buffer) {
        trait.enchantments.clear();
        int gearTypeCount = buffer.readByte();
        for (int typeIndex = 0; typeIndex < gearTypeCount; ++typeIndex) {
            ArrayList<EnchantmentData> list = new ArrayList<EnchantmentData>();
            String gearType = buffer.func_218666_n();
            int dataCount = buffer.readByte();
            for (int dataIndex = 0; dataIndex < dataCount; ++dataIndex) {
                list.add(EnchantmentData.read(buffer));
            }
            trait.enchantments.put(gearType, list);
        }
    }

    private static void writeBuffer(EnchantmentTrait trait, PacketBuffer buffer) {
        buffer.writeByte(trait.enchantments.size());
        for (Map.Entry<String, List<EnchantmentData>> entry : trait.enchantments.entrySet()) {
            buffer.func_180714_a(entry.getKey());
            buffer.writeByte(entry.getValue().size());
            for (EnchantmentData data : entry.getValue()) {
                data.write(buffer);
            }
        }
    }

    @Override
    public Collection<String> getExtraWikiLines() {
        Collection<String> ret = super.getExtraWikiLines();
        this.enchantments.forEach((type, list) -> {
            ret.add("  - " + type);
            list.forEach(mod -> ret.add("    - " + mod.getWikiLine()));
        });
        return ret;
    }

    public static class EnchantmentData {
        private ResourceLocation enchantmentId;
        private int[] levels;

        public static EnchantmentData of(Enchantment enchantment, int ... levels) {
            EnchantmentData ret = new EnchantmentData();
            ret.enchantmentId = enchantment.getRegistryName();
            ret.levels = (int[])levels.clone();
            return ret;
        }

        public JsonObject serialize() {
            JsonObject json = new JsonObject();
            json.addProperty("enchantment", this.enchantmentId.toString());
            JsonArray levelsJson = new JsonArray();
            Arrays.stream(this.levels).forEach(arg_0 -> ((JsonArray)levelsJson).add(arg_0));
            json.add("level", (JsonElement)levelsJson);
            return json;
        }

        static EnchantmentData from(JsonObject json) {
            EnchantmentData ret = new EnchantmentData();
            ret.enchantmentId = new ResourceLocation(JSONUtils.func_151219_a((JsonObject)json, (String)"enchantment", (String)"unknown"));
            JsonElement elementLevel = json.get("level");
            if (elementLevel == null) {
                throw new JsonParseException("level element not found, should be either int or array");
            }
            if (elementLevel.isJsonPrimitive()) {
                ret.levels = new int[]{JSONUtils.func_151208_a((JsonObject)json, (String)"level", (int)1)};
            } else if (elementLevel.isJsonArray()) {
                JsonArray array = elementLevel.getAsJsonArray();
                ret.levels = new int[array.size()];
                for (int i = 0; i < ret.levels.length; ++i) {
                    ret.levels[i] = array.get(i).getAsInt();
                }
            } else {
                throw new JsonParseException("Expected level to be int or array, was " + elementLevel.getClass().getSimpleName());
            }
            return ret;
        }

        static EnchantmentData read(PacketBuffer buffer) {
            EnchantmentData ret = new EnchantmentData();
            ret.enchantmentId = buffer.func_192575_l();
            ret.levels = buffer.func_186863_b();
            return ret;
        }

        void write(PacketBuffer buffer) {
            buffer.func_192572_a(this.enchantmentId);
            buffer.func_186875_a(this.levels);
        }

        @Nullable
        Enchantment getEnchantment() {
            return (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(this.enchantmentId);
        }

        int getLevel(int traitLevel) {
            int index = MathHelper.func_76125_a((int)traitLevel, (int)1, (int)this.levels.length) - 1;
            return this.levels[index];
        }

        public String getWikiLine() {
            CharSequence[] levelsText = new String[this.levels.length];
            for (int i = 0; i < this.levels.length; ++i) {
                levelsText[i] = Integer.toString(this.levels[i]);
            }
            return this.enchantmentId + ": [" + String.join((CharSequence)", ", levelsText) + "]";
        }
    }
}

