/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.part;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.silentchaos512.gear.api.item.GearTypeMatcher;
import net.silentchaos512.gear.api.part.IPartSerializer;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.gear.part.AbstractGearPart;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.gear.part.PartSerializers;
import net.silentchaos512.gear.util.GearHelper;

public class UpgradePart
extends AbstractGearPart {
    private GearTypeMatcher gearTypes = GearTypeMatcher.ALL;

    public UpgradePart(ResourceLocation registryName) {
        super(registryName);
    }

    @Override
    public PartType getType() {
        return PartType.MISC_UPGRADE;
    }

    @Override
    public IPartSerializer<?> getSerializer() {
        return PartSerializers.UPGRADE_PART;
    }

    @Override
    public int getColor(PartData part, ItemStack gear, int layer, int animationFrame) {
        return 0xFFFFFF;
    }

    @Override
    public void addInformation(PartData part, ItemStack gear, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add(1, part.getDisplayName(gear));
    }

    @Override
    public boolean canAddToGear(ItemStack gear, PartData part) {
        return this.gearTypes.test(GearHelper.getType(gear));
    }

    public static class Serializer
    extends AbstractGearPart.Serializer<UpgradePart> {
        public Serializer(ResourceLocation serializerId, Function<ResourceLocation, UpgradePart> function) {
            super(serializerId, function);
        }

        @Override
        public UpgradePart read(ResourceLocation id, JsonObject json) {
            UpgradePart part = (UpgradePart)super.read(id, json, false);
            JsonElement gearTypesJson = json.get("gear_types");
            if (gearTypesJson != null && gearTypesJson.isJsonObject()) {
                part.gearTypes = GearTypeMatcher.deserialize(gearTypesJson.getAsJsonObject());
            }
            return part;
        }

        @Override
        public UpgradePart read(ResourceLocation id, PacketBuffer buffer) {
            UpgradePart part = (UpgradePart)super.read(id, buffer);
            part.gearTypes = GearTypeMatcher.read(buffer);
            return part;
        }

        @Override
        public void write(PacketBuffer buffer, UpgradePart part) {
            super.write(buffer, part);
            part.gearTypes.write(buffer);
        }
    }
}

