/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.part;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.part.IGearPart;
import net.silentchaos512.gear.api.part.IPartData;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.gear.material.LazyMaterialInstance;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.gear.part.PartManager;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.util.DataResource;

public class LazyPartData
implements IPartData {
    private final ResourceLocation partId;
    private final ItemStack craftingItem;

    public LazyPartData(ResourceLocation partId) {
        this(partId, ItemStack.field_190927_a);
    }

    public LazyPartData(ResourceLocation partId, ItemStack craftingItem) {
        this.partId = partId;
        this.craftingItem = craftingItem;
    }

    public static LazyPartData of(ResourceLocation partId) {
        return new LazyPartData(partId);
    }

    public static LazyPartData of(ResourceLocation partId, ItemStack craftingItem) {
        return new LazyPartData(partId, craftingItem);
    }

    public static LazyPartData of(DataResource<IGearPart> part, ItemStack craftingItem) {
        return new LazyPartData(part.getId(), craftingItem);
    }

    public static LazyPartData of(DataResource<IGearPart> part, CompoundPartItem partItem, List<LazyMaterialInstance> materials) {
        return new LazyPartData(part.getId(), partItem.create(materials));
    }

    public static LazyPartData of(DataResource<IGearPart> part, CompoundPartItem partItem, LazyMaterialInstance material) {
        return LazyPartData.of(part, partItem, Collections.singletonList(material));
    }

    public static LazyPartData of(DataResource<IGearPart> part, CompoundPartItem partItem, DataResource<IMaterial> material) {
        return LazyPartData.of(part, partItem, LazyMaterialInstance.of(material));
    }

    @Override
    public ResourceLocation getId() {
        return this.partId;
    }

    @Override
    @Nullable
    public IGearPart get() {
        return PartManager.get(this.partId);
    }

    @Override
    public ItemStack getItem() {
        IGearPart part;
        if (this.craftingItem.func_190926_b() && (part = this.get()) != null) {
            return PartData.of(part).getItem();
        }
        return this.craftingItem;
    }

    @Override
    public ITextComponent getDisplayName(PartType type, ItemStack gear) {
        IGearPart part = this.get();
        return part != null ? part.getDisplayName(this, type, gear) : new StringTextComponent("INVALID");
    }

    @Override
    public CompoundNBT write(CompoundNBT tags) {
        tags.func_74778_a("ID", this.partId.toString());
        if (!this.craftingItem.func_190926_b()) {
            tags.func_218657_a("Item", (INBT)this.craftingItem.func_77955_b(new CompoundNBT()));
        }
        return tags;
    }

    @Override
    public String getModelKey() {
        return SilentGear.shortenId(this.partId);
    }

    public boolean isValid() {
        return this.get() != null;
    }

    public static LazyPartData deserialize(JsonElement json) {
        if (json.isJsonPrimitive()) {
            String key = json.getAsString();
            return new LazyPartData(new ResourceLocation(key));
        }
        JsonObject jsonObject = json.getAsJsonObject();
        String key = JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"part");
        return new LazyPartData(new ResourceLocation(key));
    }

    public static List<PartData> createPartList(Collection<LazyPartData> parts) {
        return parts.stream().filter(LazyPartData::isValid).map(LazyPartData::get).filter(Objects::nonNull).map(PartData::of).collect(Collectors.toList());
    }
}

