/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data.recipes;

import com.google.gson.JsonObject;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.crafting.ingredient.GearPartIngredient;
import net.silentchaos512.gear.crafting.ingredient.PartMaterialIngredient;
import net.silentchaos512.gear.init.ModRecipes;
import net.silentchaos512.lib.util.NameUtils;

public class GearSmithingRecipeBuilder {
    private final IRecipeSerializer<?> serializer;
    private final Item gearItem;
    private final Ingredient addition;

    public GearSmithingRecipeBuilder(IRecipeSerializer<?> serializer, Item gearItem, Ingredient addition) {
        this.serializer = serializer;
        this.gearItem = gearItem;
        this.addition = addition;
    }

    public static GearSmithingRecipeBuilder coating(IItemProvider gearItem) {
        return new GearSmithingRecipeBuilder((IRecipeSerializer)ModRecipes.SMITHING_COATING.get(), gearItem.func_199767_j(), PartMaterialIngredient.of(PartType.COATING));
    }

    public static GearSmithingRecipeBuilder upgrade(IItemProvider gearItem, PartType partType) {
        return new GearSmithingRecipeBuilder((IRecipeSerializer)ModRecipes.SMITHING_UPGRADE.get(), gearItem.func_199767_j(), GearPartIngredient.of(partType));
    }

    public void build(Consumer<IFinishedRecipe> consumer) {
        this.build(consumer, new ResourceLocation(this.serializer.getRegistryName() + "/" + NameUtils.from((IForgeRegistryEntry)this.gearItem).func_110623_a()));
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation recipeId) {
        consumer.accept(new Result(recipeId, this));
    }

    public class Result
    implements IFinishedRecipe {
        private final ResourceLocation recipeId;
        private final GearSmithingRecipeBuilder builder;

        public Result(ResourceLocation recipeId, GearSmithingRecipeBuilder builder) {
            this.recipeId = recipeId;
            this.builder = builder;
        }

        public void func_218610_a(JsonObject json) {
            json.add("gear", Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{this.builder.gearItem}).func_200304_c());
            json.add("addition", this.builder.addition.func_200304_c());
        }

        public ResourceLocation func_200442_b() {
            return this.recipeId;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return this.builder.serializer;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

