/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data.loot;

import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.advancements.criterion.EnchantmentPredicate;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.ILootConditionConsumer;
import net.minecraft.loot.ILootFunctionConsumer;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.conditions.BlockStateProperty;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.conditions.MatchTool;
import net.minecraft.loot.conditions.TableBonus;
import net.minecraft.loot.functions.ApplyBonus;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.state.Property;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gear.init.ModBlocks;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.gear.item.CraftingItems;

public class ModBlockLootTables
extends BlockLootTables {
    private static final float[] DEFAULT_SAPLING_DROP_RATES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};
    private static final ILootCondition.IBuilder SILK_TOUCH = MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_218003_a(new EnchantmentPredicate(Enchantments.field_185306_r, MinMaxBounds.IntBound.func_211340_b((int)1))));
    private static final ILootCondition.IBuilder SHEARS = MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_200307_a((ITag)Tags.Items.SHEARS));
    private static final ILootCondition.IBuilder SILK_TOUCH_OR_SHEARS = SHEARS.func_216297_a(SILK_TOUCH);
    private static final ILootCondition.IBuilder NOT_SILK_TOUCH_OR_SHEARS = SILK_TOUCH_OR_SHEARS.func_216298_a();

    protected void addTables() {
        this.func_218507_a((Block)ModBlocks.BORT_ORE.get(), ModBlockLootTables.func_218476_a((Block)((Block)ModBlocks.BORT_ORE.get()), (Item)CraftingItems.BORT.func_199767_j()));
        this.func_218507_a((Block)ModBlocks.DEEPSLATE_BORT_ORE.get(), ModBlockLootTables.func_218476_a((Block)((Block)ModBlocks.DEEPSLATE_BORT_ORE.get()), (Item)CraftingItems.BORT.func_199767_j()));
        this.func_218507_a((Block)ModBlocks.CRIMSON_IRON_ORE.get(), ModBlockLootTables.func_218476_a((Block)((Block)ModBlocks.CRIMSON_IRON_ORE.get()), (Item)CraftingItems.RAW_CRIMSON_IRON.func_199767_j()));
        this.func_218507_a((Block)ModBlocks.AZURE_SILVER_ORE.get(), ModBlockLootTables.func_218476_a((Block)((Block)ModBlocks.AZURE_SILVER_ORE.get()), (Item)CraftingItems.RAW_AZURE_SILVER.func_199767_j()));
        this.func_218492_c((Block)ModBlocks.RAW_CRIMSON_IRON_BLOCK.get());
        this.func_218492_c((Block)ModBlocks.RAW_AZURE_SILVER_BLOCK.get());
        this.func_218492_c((Block)ModBlocks.BLAZE_GOLD_BLOCK.get());
        this.func_218492_c((Block)ModBlocks.BORT_BLOCK.get());
        this.func_218492_c((Block)ModBlocks.CRIMSON_IRON_BLOCK.get());
        this.func_218492_c((Block)ModBlocks.CRIMSON_STEEL_BLOCK.get());
        this.func_218492_c((Block)ModBlocks.AZURE_SILVER_BLOCK.get());
        this.func_218492_c((Block)ModBlocks.AZURE_ELECTRUM_BLOCK.get());
        this.func_218492_c((Block)ModBlocks.TYRIAN_STEEL_BLOCK.get());
        this.func_218492_c((Block)ModBlocks.MATERIAL_GRADER.get());
        this.func_218492_c((Block)ModBlocks.NETHERWOOD_CHARCOAL_BLOCK.get());
        this.func_218492_c((Block)ModBlocks.NETHERWOOD_FENCE.get());
        this.func_218492_c((Block)ModBlocks.NETHERWOOD_FENCE_GATE.get());
        this.func_218522_a((Block)ModBlocks.NETHERWOOD_LEAVES.get(), ModBlockLootTables.netherwoodLeaves(ModBlocks.NETHERWOOD_SAPLING, CraftingItems.NETHERWOOD_STICK, DEFAULT_SAPLING_DROP_RATES));
        this.func_218492_c((Block)ModBlocks.NETHERWOOD_LOG.get());
        this.func_218492_c((Block)ModBlocks.STRIPPED_NETHERWOOD_LOG.get());
        this.func_218492_c((Block)ModBlocks.NETHERWOOD_WOOD.get());
        this.func_218492_c((Block)ModBlocks.STRIPPED_NETHERWOOD_WOOD.get());
        this.func_218492_c((Block)ModBlocks.NETHERWOOD_PLANKS.get());
        this.func_218492_c((Block)ModBlocks.NETHERWOOD_SAPLING.get());
        this.func_218522_a((Block)ModBlocks.NETHERWOOD_DOOR.get(), block -> ModBlockLootTables.func_218562_a((Block)block, (Property)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.LOWER));
        this.func_218492_c((Block)ModBlocks.NETHERWOOD_TRAPDOOR.get());
        this.func_218522_a((Block)ModBlocks.NETHERWOOD_SLAB.get(), BlockLootTables::func_218513_d);
        this.func_218492_c((Block)ModBlocks.NETHERWOOD_STAIRS.get());
        this.func_218492_c((Block)ModBlocks.STONE_TORCH.get());
        this.func_218507_a((Block)ModBlocks.PHANTOM_LIGHT.get(), ModBlockLootTables.func_218482_a());
        this.func_218547_a((Block)ModBlocks.POTTED_NETHERWOOD_SAPLING.get());
        this.func_218492_c((Block)ModBlocks.GEAR_SMITHING_TABLE.get());
        this.func_218492_c((Block)ModBlocks.METAL_ALLOYER.get());
        this.func_218492_c((Block)ModBlocks.METAL_PRESS.get());
        this.func_218492_c((Block)ModBlocks.RECRYSTALLIZER.get());
        this.func_218492_c((Block)ModBlocks.REFABRICATOR.get());
        this.func_218492_c((Block)ModBlocks.SALVAGER.get());
        this.func_218492_c((Block)ModBlocks.STARLIGHT_CHARGER.get());
        this.func_218492_c((Block)ModBlocks.WHITE_FLUFFY_BLOCK.get());
        this.func_218492_c((Block)ModBlocks.ORANGE_FLUFFY_BLOCK.get());
        this.func_218492_c((Block)ModBlocks.MAGENTA_FLUFFY_BLOCK.get());
        this.func_218492_c((Block)ModBlocks.LIGHT_BLUE_FLUFFY_BLOCK.get());
        this.func_218492_c((Block)ModBlocks.YELLOW_FLUFFY_BLOCK.get());
        this.func_218492_c((Block)ModBlocks.LIME_FLUFFY_BLOCK.get());
        this.func_218492_c((Block)ModBlocks.PINK_FLUFFY_BLOCK.get());
        this.func_218492_c((Block)ModBlocks.GRAY_FLUFFY_BLOCK.get());
        this.func_218492_c((Block)ModBlocks.LIGHT_GRAY_FLUFFY_BLOCK.get());
        this.func_218492_c((Block)ModBlocks.CYAN_FLUFFY_BLOCK.get());
        this.func_218492_c((Block)ModBlocks.PURPLE_FLUFFY_BLOCK.get());
        this.func_218492_c((Block)ModBlocks.BLUE_FLUFFY_BLOCK.get());
        this.func_218492_c((Block)ModBlocks.BROWN_FLUFFY_BLOCK.get());
        this.func_218492_c((Block)ModBlocks.GREEN_FLUFFY_BLOCK.get());
        this.func_218492_c((Block)ModBlocks.RED_FLUFFY_BLOCK.get());
        this.func_218492_c((Block)ModBlocks.BLACK_FLUFFY_BLOCK.get());
        this.func_218507_a((Block)ModBlocks.FLAX_PLANT.get(), ModBlockLootTables.flaxPlant((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)((Block)ModBlocks.FLAX_PLANT.get())).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)CropsBlock.field_176488_a, 7))));
        this.func_218493_a((Block)ModBlocks.WILD_FLAX_PLANT.get(), (IItemProvider)ModItems.FLAX_SEEDS);
        this.func_218507_a((Block)ModBlocks.FLUFFY_PLANT.get(), ModBlockLootTables.fluffyPlant((ILootCondition.IBuilder)BlockStateProperty.func_215985_a((Block)((Block)ModBlocks.FLUFFY_PLANT.get())).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)CropsBlock.field_176488_a, 7))));
        this.func_218493_a((Block)ModBlocks.WILD_FLUFFY_PLANT.get(), (IItemProvider)ModItems.FLUFFY_SEEDS);
    }

    @Nonnull
    private static Function<Block, LootTable.Builder> netherwoodLeaves(IItemProvider sapling, IItemProvider stick, float ... chances) {
        return block -> ModBlockLootTables.func_218494_a((Block)block, (ILootCondition.IBuilder)SILK_TOUCH_OR_SHEARS, (LootEntry.Builder)((StandaloneLootEntry.Builder)ModBlockLootTables.func_218560_a((IItemProvider)block, (ILootConditionConsumer)ItemLootEntry.func_216168_a((IItemProvider)sapling))).func_212840_b_(TableBonus.func_215955_a((Enchantment)Enchantments.field_185308_t, (float[])chances))).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(NOT_SILK_TOUCH_OR_SHEARS).func_216045_a(((StandaloneLootEntry.Builder)ModBlockLootTables.func_218552_a((IItemProvider)block, (ILootFunctionConsumer)ItemLootEntry.func_216168_a((IItemProvider)stick).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f))))).func_212840_b_(TableBonus.func_215955_a((Enchantment)Enchantments.field_185308_t, (float[])new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f})))).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(NOT_SILK_TOUCH_OR_SHEARS).func_216045_a(((StandaloneLootEntry.Builder)ModBlockLootTables.func_218560_a((IItemProvider)block, (ILootConditionConsumer)ItemLootEntry.func_216168_a(ModItems.NETHER_BANANA))).func_212840_b_(TableBonus.func_215955_a((Enchantment)Enchantments.field_185308_t, (float[])new float[]{0.005f, 0.0055555557f, 0.00625f, 0.008333334f, 0.025f}))));
    }

    private static LootTable.Builder flaxPlant(ILootCondition.IBuilder builder) {
        return (LootTable.Builder)ModBlockLootTables.func_218552_a(ModBlocks.FLAX_PLANT, (ILootFunctionConsumer)LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_212840_b_(builder).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)CraftingItems.FLAX_FIBER).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215870_a((Enchantment)Enchantments.field_185308_t, (float)0.5714286f, (int)3)))).func_216040_a(LootPool.func_216096_a().func_212840_b_(builder).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a(ModItems.FLAX_SEEDS).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215870_a((Enchantment)Enchantments.field_185308_t, (float)0.5714286f, (int)3)))).func_216040_a(LootPool.func_216096_a().func_212840_b_(builder).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)CraftingItems.FLAX_FLOWERS).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215870_a((Enchantment)Enchantments.field_185308_t, (float)0.5f, (int)1)))));
    }

    private static LootTable.Builder fluffyPlant(ILootCondition.IBuilder builder) {
        return (LootTable.Builder)ModBlockLootTables.func_218552_a(ModBlocks.FLUFFY_PLANT, (ILootFunctionConsumer)LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_212840_b_(builder).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)CraftingItems.FLUFFY_PUFF).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215870_a((Enchantment)Enchantments.field_185308_t, (float)0.5714286f, (int)3)))).func_216040_a(LootPool.func_216096_a().func_212840_b_(builder).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a(ModItems.FLUFFY_SEEDS).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215870_a((Enchantment)Enchantments.field_185308_t, (float)0.5714286f, (int)3)))));
    }

    protected Iterable<Block> getKnownBlocks() {
        return ForgeRegistries.BLOCKS.getValues().stream().filter(block -> "silentgear".equals(block.getRegistryName().func_110624_b())).collect(Collectors.toSet());
    }
}

