/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe;

import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.init.ModRecipes;
import net.silentchaos512.gear.item.ModKitItem;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.lib.collection.StackList;

public class ModKitRemovePartRecipe
extends SpecialRecipe {
    public ModKitRemovePartRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        ItemStack gear = ItemStack.field_190927_a;
        boolean foundModKit = false;
        PartType type = PartType.NONE;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (gear.func_190926_b() && stack.func_77973_b() instanceof ICoreItem) {
                gear = stack;
                continue;
            }
            if (!foundModKit && stack.func_77973_b() instanceof ModKitItem) {
                type = ModKitItem.getSelectedType(stack);
                if (type == PartType.NONE) {
                    return false;
                }
                foundModKit = true;
                continue;
            }
            return false;
        }
        return !gear.func_190926_b() && foundModKit && GearData.hasPartOfType(gear, type);
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        PartType type;
        StackList list = StackList.from((IInventory)inv);
        ItemStack gear = list.uniqueOfType(ICoreItem.class);
        ItemStack modKit = list.uniqueOfType(ModKitItem.class);
        if (gear.func_190926_b() || modKit.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack result = gear.func_77946_l();
        if (GearData.removeFirstPartOfType(result, type = ModKitItem.getSelectedType(modKit))) {
            GearData.recalculateStats(result, ForgeHooks.getCraftingPlayer());
        }
        return result;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height >= 2;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList list = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStack gear = StackList.from((IInventory)inv).uniqueOfType(ICoreItem.class);
        ItemStack modKit = StackList.from((IInventory)inv).uniqueOfType(ModKitItem.class);
        PartType type = ModKitItem.getSelectedType(modKit);
        PartData part = GearData.getPartOfType(gear, type);
        for (int i = 0; i < list.size(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_77973_b() instanceof ICoreItem) {
                list.set(i, (Object)(part != null ? part.getItem() : ItemStack.field_190927_a));
                continue;
            }
            if (!stack.hasContainerItem()) continue;
            list.set(i, (Object)stack.getContainerItem());
        }
        return list;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipes.MOD_KIT_REMOVE_PART.get();
    }
}

