/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.part.PartDataList;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.init.ModRecipes;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.lib.collection.StackList;

public class GearPartSwapRecipe
extends SpecialRecipe {
    public GearPartSwapRecipe(ResourceLocation idIn) {
        super(idIn);
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        StackList list = StackList.from((IInventory)inv);
        ItemStack gear = list.uniqueOfType(ICoreItem.class);
        if (gear.func_190926_b()) {
            return false;
        }
        ICoreItem item = (ICoreItem)gear.func_77973_b();
        Collection others = list.allMatches(stack -> !(stack.func_77973_b() instanceof ICoreItem));
        if (others.isEmpty()) {
            return false;
        }
        HashMap<PartType, Integer> typeCounts = new HashMap<PartType, Integer>();
        for (ItemStack stack2 : others) {
            PartData part = PartData.from(stack2);
            if (part == null) {
                return false;
            }
            PartType type = part.getType();
            if (!item.supportsPart(gear, part) || typeCounts.getOrDefault(type, 0) >= type.getMaxPerItem(item.getGearType())) {
                return false;
            }
            typeCounts.merge(type, 1, Integer::sum);
        }
        return true;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        StackList list = StackList.from((IInventory)inv);
        ItemStack gear = list.uniqueOfType(ICoreItem.class);
        if (gear.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        Collection others = list.allMatches(stack -> !(stack.func_77973_b() instanceof ICoreItem));
        if (others.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        ItemStack result = gear.func_77946_l();
        PartDataList parts = GearData.getConstructionParts(result);
        for (ItemStack stack2 : others) {
            PartData part = PartData.from(stack2);
            if (part == null) {
                return ItemStack.field_190927_a;
            }
            PartType type = part.getType();
            ArrayList<PartData> partsOfType = new ArrayList<PartData>(parts.getPartsOfType(type));
            int maxPerItem = type.getMaxPerItem(GearHelper.getType(result));
            if (partsOfType.size() >= maxPerItem) {
                PartData oldPart = (PartData)partsOfType.get(0);
                partsOfType.remove(oldPart);
                parts.remove(oldPart);
                oldPart.onRemoveFromGear(result);
            }
            parts.add(part);
            part.onAddToGear(result);
        }
        GearData.writeConstructionParts(result, parts);
        GearData.removeExcessParts(result);
        GearData.recalculateStats(result, ForgeHooks.getCraftingPlayer());
        return result;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        NonNullList list = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStack gear = StackList.from((IInventory)inv).uniqueMatch(s -> s.func_77973_b() instanceof ICoreItem);
        PartDataList oldParts = GearData.getConstructionParts(gear);
        HashMap<PartType, Integer> removedCount = new HashMap<PartType, Integer>();
        for (int i = 0; i < list.size(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_77973_b() instanceof ICoreItem) {
                list.set(i, (Object)ItemStack.field_190927_a);
                continue;
            }
            PartData newPart = PartData.from(stack);
            if (newPart == null) continue;
            PartType type = newPart.getType();
            List<PartData> partsOfType = oldParts.getPartsOfType(type);
            if (partsOfType.size() >= type.getMaxPerItem(GearHelper.getType(gear))) {
                int index = removedCount.getOrDefault(type, 0);
                if (index >= partsOfType.size()) continue;
                PartData oldPart = partsOfType.get(index);
                oldPart.onRemoveFromGear(gear);
                list.set(i, (Object)oldPart.getItem());
                removedCount.merge(type, 1, Integer::sum);
                continue;
            }
            list.set(i, (Object)ItemStack.field_190927_a);
        }
        return list;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipes.SWAP_GEAR_PART.get();
    }
}

